/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.impl;

import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.impl.VertxInternal;

public class CountingCompletionHandler<T> {
    private final DefaultContext context;
    private final VertxInternal vertx;
    private int count;
    private int required;
    private Handler<AsyncResult<T>> doneHandler;
    private Throwable cause;
    private boolean failed;

    public CountingCompletionHandler(VertxInternal vertx) {
        this(vertx, 0);
    }

    public CountingCompletionHandler(VertxInternal vertx, int required) {
        this.vertx = vertx;
        this.context = vertx.getOrCreateContext();
        this.required = required;
    }

    public synchronized void complete() {
        ++this.count;
        this.checkDone();
    }

    public synchronized void failed(Throwable t) {
        if (!this.failed) {
            if (this.doneHandler != null) {
                this.callHandler(new DefaultFutureResult<Throwable>(t));
            } else {
                this.cause = t;
            }
            this.failed = true;
        }
    }

    public synchronized void incRequired() {
        ++this.required;
    }

    public synchronized void setHandler(Handler<AsyncResult<T>> doneHandler) {
        this.doneHandler = doneHandler;
        this.checkDone();
    }

    private void callHandler(final AsyncResult<T> result) {
        if (this.vertx.getContext() == this.context) {
            this.doneHandler.handle(result);
        } else {
            this.context.execute(new Runnable(){

                @Override
                public void run() {
                    CountingCompletionHandler.this.doneHandler.handle(result);
                }
            });
        }
    }

    void checkDone() {
        if (this.doneHandler != null) {
            if (this.cause != null) {
                this.callHandler(new DefaultFutureResult<Throwable>(this.cause));
            } else if (this.count == this.required) {
                DefaultFutureResult<Object> res = new DefaultFutureResult<Object>((Object)null);
                this.callHandler(res);
            }
        }
    }
}

