/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.dns.impl.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.vertx.core.dns.impl.netty.DnsMessage;
import io.vertx.core.dns.impl.netty.DnsResponseDecoder;
import io.vertx.core.dns.impl.netty.DnsResponseHeader;

public class DnsResponse
extends DnsMessage<DnsResponseHeader>
implements ByteBufHolder {
    private final ByteBuf rawPacket;
    private final int originalIndex;

    public DnsResponse(ByteBuf rawPacket) {
        this.rawPacket = rawPacket;
        this.originalIndex = rawPacket.readerIndex();
    }

    @Override
    public ByteBuf content() {
        return this.rawPacket;
    }

    @Override
    public int refCnt() {
        return this.rawPacket.refCnt();
    }

    @Override
    public boolean release() {
        return this.rawPacket.release();
    }

    @Override
    public DnsResponse copy() {
        return DnsResponseDecoder.decodeResponse(this.rawPacket.copy(), this.rawPacket.alloc());
    }

    @Override
    public ByteBufHolder duplicate() {
        return DnsResponseDecoder.decodeResponse(this.rawPacket.duplicate(), this.rawPacket.alloc());
    }

    @Override
    public DnsResponse retain() {
        this.rawPacket.retain();
        return this;
    }

    @Override
    public DnsResponse retain(int increment) {
        this.rawPacket.retain(increment);
        return this;
    }

    @Override
    public boolean release(int decrement) {
        return this.rawPacket.release(decrement);
    }

    public int originalIndex() {
        return this.originalIndex;
    }
}

