/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.http.impl.ConnectionLifeCycleListener;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientRequestImpl;
import io.vertx.core.http.impl.HttpClientResponseImpl;
import io.vertx.core.http.impl.WebSocketImpl;
import io.vertx.core.http.impl.ws.WebSocketFrameInternal;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.NetSocketImpl;
import io.vertx.core.net.impl.VertxNetHandler;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;

class ClientConnection
extends ConnectionBase {
    private static final Logger log = LoggerFactory.getLogger(ClientConnection.class);
    private final HttpClientImpl client;
    private final String hostHeader;
    private final boolean ssl;
    private final String host;
    private final int port;
    private final ConnectionLifeCycleListener listener;
    private final Queue<HttpClientRequestImpl> requests = new ArrayDeque<HttpClientRequestImpl>();
    private final Handler<Throwable> exceptionHandler;
    private final Object metric;
    private final HttpClientMetrics metrics;
    private WebSocketClientHandshaker handshaker;
    private HttpClientRequestImpl currentRequest;
    private HttpClientResponseImpl currentResponse;
    private HttpClientRequestImpl requestForResponse;
    private WebSocketImpl ws;

    ClientConnection(VertxInternal vertx, HttpClientImpl client, Handler<Throwable> exceptionHandler, Channel channel, boolean ssl, String host, int port, ContextImpl context, ConnectionLifeCycleListener listener, HttpClientMetrics metrics) {
        super(vertx, channel, context, metrics);
        this.client = client;
        this.ssl = ssl;
        this.host = host;
        this.port = port;
        this.hostHeader = port == 80 && !ssl || port == 443 && ssl ? host : host + ':' + port;
        this.listener = listener;
        this.exceptionHandler = exceptionHandler;
        this.metrics = metrics;
        this.metric = metrics.connected(this.remoteAddress());
    }

    @Override
    protected Object metric() {
        return this.metric;
    }

    protected HttpClientMetrics metrics() {
        return this.metrics;
    }

    synchronized void toWebSocket(String requestURI, MultiMap headers, WebsocketVersion vers, String subProtocols, int maxWebSocketFrameSize, Handler<WebSocket> wsConnect) {
        if (this.ws != null) {
            throw new IllegalStateException("Already websocket");
        }
        try {
            DefaultHttpHeaders nettyHeaders;
            URI wsuri = new URI(requestURI);
            if (!wsuri.isAbsolute()) {
                wsuri = new URI((this.ssl ? "https:" : "http:") + "//" + this.host + ":" + this.port + requestURI);
            }
            WebSocketVersion version = WebSocketVersion.valueOf((vers == null ? WebSocketVersion.V13 : vers).toString());
            if (headers != null) {
                nettyHeaders = new DefaultHttpHeaders();
                for (Map.Entry entry : headers) {
                    ((HttpHeaders)nettyHeaders).add((String)entry.getKey(), entry.getValue());
                }
            } else {
                nettyHeaders = null;
            }
            this.handshaker = WebSocketClientHandshakerFactory.newHandshaker(wsuri, version, subProtocols, false, nettyHeaders, maxWebSocketFrameSize);
            ChannelPipeline p = this.channel.pipeline();
            p.addBefore("handler", "handshakeCompleter", new HandshakeInboundHandler(wsConnect, version != WebSocketVersion.V00));
            this.handshaker.handshake(this.channel).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                if (!future.isSuccess() && this.exceptionHandler != null) {
                    this.exceptionHandler.handle(future.cause());
                }
            }));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void closeHandler(Handler<Void> handler) {
        this.closeHandler = handler;
    }

    boolean isClosed() {
        return !this.channel.isOpen();
    }

    int getOutstandingRequestCount() {
        return this.requests.size();
    }

    @Override
    public synchronized void handleInterestedOpsChanged() {
        if (!this.isNotWritable()) {
            if (this.currentRequest != null) {
                this.currentRequest.handleDrained();
            } else if (this.ws != null) {
                this.ws.writable();
            }
        }
    }

    void handleResponse(HttpResponse resp) {
        HttpClientResponseImpl nResp;
        this.requestForResponse = resp.getStatus().code() == 100 ? this.requests.peek() : this.requests.poll();
        if (this.requestForResponse == null) {
            throw new IllegalStateException("No response handler");
        }
        this.currentResponse = nResp = new HttpClientResponseImpl(this.vertx, this.requestForResponse, this, resp);
        this.requestForResponse.handleResponse(nResp);
    }

    void handleResponseChunk(Buffer buff) {
        this.currentResponse.handleChunk(buff);
    }

    void handleResponseEnd(LastHttpContent trailer) {
        this.currentResponse.handleEnd(trailer);
        if (this.currentResponse.statusCode() != 100 && this.requestForResponse.getRequest().getMethod() != HttpMethod.CONNECT) {
            this.listener.responseEnded(this);
        }
    }

    synchronized void handleWsFrame(WebSocketFrameInternal frame) {
        if (this.ws != null) {
            this.ws.handleFrame(frame);
        }
    }

    @Override
    protected synchronized void handleClosed() {
        super.handleClosed();
        if (this.ws != null) {
            this.ws.handleClosed();
        }
        VertxException e = new VertxException("Connection was closed");
        for (HttpClientRequestImpl req : this.requests) {
            req.handleException(e);
        }
        if (this.currentRequest != null) {
            this.currentRequest.handleException(e);
        } else if (this.currentResponse != null) {
            this.currentResponse.handleException(e);
        }
    }

    @Override
    protected ContextImpl getContext() {
        return super.getContext();
    }

    @Override
    protected synchronized void handleException(Throwable e) {
        super.handleException(e);
        if (this.currentRequest != null) {
            this.currentRequest.handleException(e);
        } else if (this.currentResponse != null) {
            this.currentResponse.handleException(e);
        }
    }

    synchronized void setCurrentRequest(HttpClientRequestImpl req) {
        if (this.currentRequest != null) {
            throw new IllegalStateException("Connection is already writing a request");
        }
        this.currentRequest = req;
        this.requests.add(req);
    }

    synchronized void endRequest() {
        if (this.currentRequest == null) {
            throw new IllegalStateException("No write in progress");
        }
        this.currentRequest = null;
        this.listener.requestEnded(this);
    }

    public String hostHeader() {
        return this.hostHeader;
    }

    @Override
    public synchronized void close() {
        if (this.handshaker == null) {
            super.close();
        } else {
            this.endReadAndFlush();
            this.handshaker.close(this.channel, new CloseWebSocketFrame(1000, null));
        }
    }

    NetSocket createNetSocket() {
        NetSocketImpl socket = new NetSocketImpl(this.vertx, this.channel, this.context, this.client.getSslHelper(), true, this.metrics, this.metric);
        HashMap<Channel, NetSocketImpl> connectionMap = new HashMap<Channel, NetSocketImpl>(1);
        connectionMap.put(this.channel, socket);
        this.endReadAndFlush();
        ChannelPipeline pipeline = this.channel.pipeline();
        HttpContentDecompressor inflater = pipeline.get(HttpContentDecompressor.class);
        if (inflater != null) {
            pipeline.remove(inflater);
        }
        pipeline.remove("codec");
        pipeline.replace("handler", "handler", (ChannelHandler)new VertxNetHandler(connectionMap){

            @Override
            public void exceptionCaught(ChannelHandlerContext chctx, Throwable t) throws Exception {
                ClientConnection.this.client.removeChannel(ClientConnection.this.channel);
                super.exceptionCaught(chctx, t);
            }

            @Override
            public void channelInactive(ChannelHandlerContext chctx) throws Exception {
                ClientConnection.this.client.removeChannel(ClientConnection.this.channel);
                super.channelInactive(chctx);
            }

            @Override
            public void channelRead(ChannelHandlerContext chctx, Object msg) throws Exception {
                if (msg instanceof HttpContent) {
                    ReferenceCountUtil.release(msg);
                    return;
                }
                super.channelRead(chctx, msg);
            }
        });
        return socket;
    }

    private final class HandshakeInboundHandler
    extends ChannelInboundHandlerAdapter {
        private final boolean supportsContinuation;
        private final Handler<WebSocket> wsConnect;
        private final ContextImpl context;
        private final Queue<Object> buffered = new ArrayDeque<Object>();
        private FullHttpResponse response;
        private boolean handshaking = true;

        public HandshakeInboundHandler(Handler<WebSocket> wsConnect, boolean supportsContinuation) {
            this.supportsContinuation = supportsContinuation;
            this.wsConnect = wsConnect;
            this.context = ClientConnection.this.vertx.getContext();
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            super.channelInactive(ctx);
            if (this.handshaking) {
                this.handleException(new WebSocketHandshakeException("Connection closed while handshake in process"));
            }
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (ClientConnection.this.handshaker != null && this.handshaking) {
                if (msg instanceof HttpResponse) {
                    HttpResponse resp = (HttpResponse)msg;
                    if (resp.getStatus().code() != 101) {
                        this.handleException(new WebSocketHandshakeException("Websocket connection attempt returned HTTP status code " + resp.getStatus().code()));
                        return;
                    }
                    this.response = new DefaultFullHttpResponse(resp.getProtocolVersion(), resp.getStatus());
                    this.response.headers().add(resp.headers());
                }
                if (msg instanceof HttpContent && this.response != null) {
                    this.response.content().writeBytes(((HttpContent)msg).content());
                    if (msg instanceof LastHttpContent) {
                        this.response.trailingHeaders().add(((LastHttpContent)msg).trailingHeaders());
                        try {
                            Object m;
                            this.handshakeComplete(ctx, this.response);
                            ClientConnection.this.channel.pipeline().remove(this);
                            while ((m = this.buffered.poll()) != null) {
                                ctx.fireChannelRead(m);
                            }
                        }
                        catch (WebSocketHandshakeException e) {
                            ClientConnection.this.close();
                            this.handleException(e);
                        }
                    }
                }
            } else {
                this.buffered.add(msg);
            }
        }

        private void handleException(WebSocketHandshakeException e) {
            this.handshaking = false;
            this.buffered.clear();
            if (ClientConnection.this.exceptionHandler != null) {
                this.context.executeFromIO(() -> ClientConnection.this.exceptionHandler.handle(e));
            } else {
                log.error("Error in websocket handshake", e);
            }
        }

        private void handshakeComplete(ChannelHandlerContext ctx, FullHttpResponse response) {
            this.handshaking = false;
            HttpContentDecompressor handler = ctx.pipeline().get(HttpContentDecompressor.class);
            if (handler != null) {
                ctx.pipeline().remove(handler);
            }
            ContextImpl.setContext(this.context);
            WebSocketImpl webSocket = new WebSocketImpl(ClientConnection.this.vertx, ClientConnection.this, this.supportsContinuation, ClientConnection.this.client.getOptions().getMaxWebsocketFrameSize());
            ClientConnection.this.ws = webSocket;
            ClientConnection.this.handshaker.finishHandshake(ClientConnection.this.channel, response);
            this.context.executeFromIO(() -> {
                log.debug("WebSocket handshake complete");
                webSocket.setMetric(ClientConnection.this.metrics().connected(ClientConnection.this.metric(), webSocket));
                this.wsConnect.handle(webSocket);
            });
        }
    }
}

