/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.handler.ssl.SslHandler;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.impl.KeyStoreHelper;
import java.io.ByteArrayInputStream;
import java.security.SecureRandom;
import java.security.cert.CRL;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SSLHelper {
    private static final Logger log = LoggerFactory.getLogger(SSLHelper.class);
    private static final String[] ENABLED_PROTOCOLS = new String[]{"SSLv2Hello", "TLSv1", "TLSv1.1", "TLSv1.2"};
    private boolean ssl;
    private KeyStoreHelper keyStoreHelper;
    private KeyStoreHelper trustStoreHelper;
    private boolean trustAll;
    private ArrayList<String> crlPaths;
    private ArrayList<Buffer> crlValues;
    private ClientAuth clientAuth = ClientAuth.NONE;
    private Set<String> enabledCipherSuites;
    private boolean verifyHost;
    private SSLContext sslContext;

    public SSLHelper(HttpClientOptions options, KeyStoreHelper keyStoreHelper, KeyStoreHelper trustStoreHelper) {
        this.ssl = options.isSsl();
        this.keyStoreHelper = keyStoreHelper;
        this.trustStoreHelper = trustStoreHelper;
        this.trustAll = options.isTrustAll();
        this.crlPaths = new ArrayList<String>(options.getCrlPaths());
        this.crlValues = new ArrayList<Buffer>(options.getCrlValues());
        this.enabledCipherSuites = options.getEnabledCipherSuites();
        this.verifyHost = options.isVerifyHost();
    }

    public SSLHelper(HttpServerOptions options, KeyStoreHelper keyStoreHelper, KeyStoreHelper trustStoreHelper) {
        this.ssl = options.isSsl();
        this.keyStoreHelper = keyStoreHelper;
        this.trustStoreHelper = trustStoreHelper;
        this.clientAuth = options.isClientAuthRequired() ? ClientAuth.REQUIRED : ClientAuth.NONE;
        this.crlPaths = options.getCrlPaths() != null ? new ArrayList<String>(options.getCrlPaths()) : null;
        this.crlValues = options.getCrlValues() != null ? new ArrayList<Buffer>(options.getCrlValues()) : null;
        this.enabledCipherSuites = options.getEnabledCipherSuites();
    }

    public SSLHelper(NetClientOptions options, KeyStoreHelper keyStoreHelper, KeyStoreHelper trustStoreHelper) {
        this.ssl = options.isSsl();
        this.keyStoreHelper = keyStoreHelper;
        this.trustStoreHelper = trustStoreHelper;
        this.trustAll = options.isTrustAll();
        this.crlPaths = new ArrayList<String>(options.getCrlPaths());
        this.crlValues = new ArrayList<Buffer>(options.getCrlValues());
        this.enabledCipherSuites = options.getEnabledCipherSuites();
    }

    public SSLHelper(NetServerOptions options, KeyStoreHelper keyStoreHelper, KeyStoreHelper trustStoreHelper) {
        this.ssl = options.isSsl();
        this.keyStoreHelper = keyStoreHelper;
        this.trustStoreHelper = trustStoreHelper;
        this.clientAuth = options.isClientAuthRequired() ? ClientAuth.REQUIRED : ClientAuth.NONE;
        this.crlPaths = options.getCrlPaths() != null ? new ArrayList<String>(options.getCrlPaths()) : null;
        this.crlValues = options.getCrlValues() != null ? new ArrayList<Buffer>(options.getCrlValues()) : null;
        this.enabledCipherSuites = options.getEnabledCipherSuites();
    }

    public boolean isSSL() {
        return this.ssl;
    }

    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    private SSLContext createContext(VertxInternal vertx) {
        try {
            TrustManager[] trustMgrs;
            KeyManager[] keyMgrs;
            SSLContext context;
            block8: {
                block9: {
                    context = SSLContext.getInstance("TLS");
                    KeyManager[] keyManagerArray = keyMgrs = this.keyStoreHelper == null ? null : this.keyStoreHelper.getKeyMgrs(vertx);
                    if (this.trustAll) {
                        trustMgrs = new TrustManager[]{SSLHelper.createTrustAllTrustManager()};
                    } else {
                        TrustManager[] trustManagerArray = trustMgrs = this.trustStoreHelper == null ? null : this.trustStoreHelper.getTrustMgrs(vertx);
                    }
                    if (trustMgrs == null || this.crlPaths == null || this.crlValues == null) break block8;
                    if (this.crlPaths.size() > 0) break block9;
                    if (this.crlValues.size() <= 0) break block8;
                }
                Stream<Buffer> tmp = this.crlPaths.stream().map(path -> vertx.resolveFile((String)path).getAbsolutePath()).map(vertx.fileSystem()::readFileBlocking);
                tmp = Stream.concat(tmp, this.crlValues.stream());
                CertificateFactory certificatefactory = CertificateFactory.getInstance("X.509");
                ArrayList<CRL> crls = new ArrayList<CRL>();
                for (Buffer crlValue : tmp.collect(Collectors.toList())) {
                    crls.addAll(certificatefactory.generateCRLs(new ByteArrayInputStream(crlValue.getBytes())));
                }
                trustMgrs = SSLHelper.createUntrustRevokedCertTrustManager(trustMgrs, crls);
            }
            context.init(keyMgrs, trustMgrs, new SecureRandom());
            return context;
        }
        catch (Exception e) {
            throw new VertxException(e);
        }
    }

    private static TrustManager[] createUntrustRevokedCertTrustManager(TrustManager[] trustMgrs, final ArrayList<CRL> crls) {
        trustMgrs = (TrustManager[])trustMgrs.clone();
        for (int i = 0; i < trustMgrs.length; ++i) {
            TrustManager trustMgr = trustMgrs[i];
            if (!(trustMgr instanceof X509TrustManager)) continue;
            final X509TrustManager x509TrustManager = (X509TrustManager)trustMgr;
            trustMgrs[i] = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    this.checkRevocaked(x509Certificates);
                    x509TrustManager.checkClientTrusted(x509Certificates, s);
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    this.checkRevocaked(x509Certificates);
                    x509TrustManager.checkServerTrusted(x509Certificates, s);
                }

                private void checkRevocaked(X509Certificate[] x509Certificates) throws CertificateException {
                    for (X509Certificate cert : x509Certificates) {
                        for (CRL crl : crls) {
                            if (!crl.isRevoked(cert)) continue;
                            throw new CertificateException("Certificate revoked");
                        }
                    }
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return x509TrustManager.getAcceptedIssuers();
                }
            };
        }
        return trustMgrs;
    }

    private static TrustManager createTrustAllTrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    private SslHandler createHandler(SSLEngine engine, boolean client) {
        if (this.enabledCipherSuites != null && !this.enabledCipherSuites.isEmpty()) {
            String[] toUse = this.enabledCipherSuites.toArray(new String[this.enabledCipherSuites.size()]);
            engine.setEnabledCipherSuites(toUse);
        }
        engine.setUseClientMode(client);
        HashSet<String> enabledProtocols = new HashSet<String>(Arrays.asList(ENABLED_PROTOCOLS));
        enabledProtocols.retainAll(Arrays.asList(engine.getEnabledProtocols()));
        engine.setEnabledProtocols(enabledProtocols.toArray(new String[0]));
        if (!client) {
            switch (this.getClientAuth()) {
                case REQUEST: {
                    engine.setWantClientAuth(true);
                    break;
                }
                case REQUIRED: {
                    engine.setNeedClientAuth(true);
                    break;
                }
                case NONE: {
                    engine.setNeedClientAuth(false);
                }
            }
        } else if (this.verifyHost) {
            SSLParameters sslParameters = engine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            engine.setSSLParameters(sslParameters);
        }
        return new SslHandler(engine);
    }

    private SSLContext getContext(VertxInternal vertx) {
        if (this.sslContext == null) {
            this.sslContext = this.createContext(vertx);
        }
        return this.sslContext;
    }

    public synchronized void validate(VertxInternal vertx) {
        if (this.ssl) {
            this.getContext(vertx);
        }
    }

    public SslHandler createSslHandler(VertxInternal vertx, boolean client, String host, int port) {
        SSLEngine engine = this.getContext(vertx).createSSLEngine(host, port);
        return this.createHandler(engine, client);
    }

    public SslHandler createSslHandler(VertxInternal vertx, boolean client) {
        SSLEngine engine = this.getContext(vertx).createSSLEngine();
        return this.createHandler(engine, client);
    }

    public static enum ClientAuth {
        NONE,
        REQUEST,
        REQUIRED;

    }
}

