/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.netty.handler.codec.http.CookieDecoder;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.Cookie;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.CookieHandler;
import io.vertx.ext.web.impl.CookieImpl;
import java.util.Set;

public class CookieHandlerImpl
implements CookieHandler {
    @Override
    public void handle(RoutingContext context) {
        String cookieHeader = context.request().headers().get(HttpHeaders.COOKIE);
        if (cookieHeader != null) {
            Set<io.netty.handler.codec.http.Cookie> nettyCookies = CookieDecoder.decode(cookieHeader);
            for (io.netty.handler.codec.http.Cookie cookie : nettyCookies) {
                CookieImpl ourCookie = new CookieImpl(cookie);
                context.addCookie(ourCookie);
            }
        }
        context.addHeadersEndHandler(fut -> {
            Set<Cookie> cookies = context.cookies();
            for (Cookie cookie : cookies) {
                if (!cookie.isChanged()) continue;
                context.response().headers().add(HttpHeaders.SET_COOKIE, (CharSequence)cookie.encode());
            }
            fut.complete();
        });
        context.next();
    }
}

