/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.ErrorHandler;
import io.vertx.ext.web.impl.Utils;
import java.util.List;
import java.util.Objects;

public class ErrorHandlerImpl
implements ErrorHandler {
    private final boolean displayExceptionDetails;
    private final String errorTemplate;

    public ErrorHandlerImpl(String errorTemplateName, boolean displayExceptionDetails) {
        Objects.requireNonNull(errorTemplateName);
        this.displayExceptionDetails = displayExceptionDetails;
        this.errorTemplate = Utils.readResourceToBuffer(errorTemplateName).toString();
    }

    @Override
    public void handle(RoutingContext context) {
        int errorCode;
        HttpServerRequest request = context.request();
        HttpServerResponse response = context.response();
        if (context.statusCode() != -1) {
            response.setStatusCode(context.statusCode());
        } else {
            response.setStatusCode(500);
        }
        String mime = response.headers().get(HttpHeaders.CONTENT_TYPE);
        String errorMessage = null;
        if (context.statusCode() != -1) {
            errorCode = context.statusCode();
            errorMessage = context.response().getStatusMessage();
        } else {
            errorCode = 500;
            if (this.displayExceptionDetails) {
                errorMessage = context.failure().getMessage();
            }
            if (errorMessage == null) {
                errorMessage = "Internal Server Error";
            }
            response.setStatusMessage(errorMessage);
        }
        if (mime != null && this.sendError(context, mime, errorCode, errorMessage)) {
            return;
        }
        List<String> acceptedMimes = Utils.getSortedAcceptableMimeTypes(request.headers().get(HttpHeaders.ACCEPT));
        for (String accept : acceptedMimes) {
            if (!this.sendError(context, accept, errorCode, errorMessage)) continue;
            return;
        }
        this.sendError(context, "text/plain", errorCode, errorMessage);
    }

    private boolean sendError(RoutingContext context, String mime, int errorCode, String errorMessage) {
        String title = "Matron!";
        HttpServerResponse response = context.response();
        if (mime.startsWith("text/html")) {
            StringBuilder stack = new StringBuilder();
            if (context.failure() != null && this.displayExceptionDetails) {
                for (StackTraceElement elem : context.failure().getStackTrace()) {
                    stack.append("<li>").append(elem).append("</li>");
                }
            }
            response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html");
            response.end(this.errorTemplate.replace("{title}", "Matron!").replace("{errorCode}", Integer.toString(errorCode)).replace("{errorMessage}", errorMessage).replace("{stackTrace}", stack.toString()));
            return true;
        }
        if (mime.startsWith("application/json")) {
            JsonObject jsonError = new JsonObject();
            jsonError.put("error", new JsonObject().put("code", errorCode).put("message", errorMessage));
            if (context.failure() != null && this.displayExceptionDetails) {
                JsonArray stack = new JsonArray();
                for (StackTraceElement elem : context.failure().getStackTrace()) {
                    stack.add(elem.toString());
                }
                jsonError.put("stack", stack);
            }
            response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json");
            response.end(jsonError.encode());
            return true;
        }
        if (mime.startsWith("text/plain")) {
            response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/plain");
            StringBuilder sb = new StringBuilder();
            sb.append("Error ");
            sb.append(errorCode);
            sb.append(": ");
            sb.append(errorMessage);
            if (context.failure() != null && this.displayExceptionDetails) {
                for (StackTraceElement elem : context.failure().getStackTrace()) {
                    sb.append("\tat ").append(elem).append("\n");
                }
            }
            response.end(sb.toString());
            return true;
        }
        return false;
    }
}

