/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.Cookie;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.sstore.SessionStore;

public class SessionHandlerImpl
implements SessionHandler {
    private static final Logger log = LoggerFactory.getLogger(SessionHandlerImpl.class);
    private final SessionStore sessionStore;
    private String sessionCookieName;
    private long sessionTimeout;
    private boolean nagHttps;

    public SessionHandlerImpl(String sessionCookieName, long sessionTimeout, boolean nagHttps, SessionStore sessionStore) {
        this.sessionCookieName = sessionCookieName;
        this.sessionTimeout = sessionTimeout;
        this.nagHttps = nagHttps;
        this.sessionStore = sessionStore;
    }

    @Override
    public SessionHandler setSessionTimeout(long timeout) {
        this.sessionTimeout = timeout;
        return this;
    }

    @Override
    public SessionHandler setNagHttps(boolean nag) {
        this.nagHttps = nag;
        return this;
    }

    @Override
    public SessionHandler setSessionCookieName(String sessionCookieName) {
        this.sessionCookieName = sessionCookieName;
        return this;
    }

    @Override
    public void handle(RoutingContext context) {
        Cookie cookie;
        String uri;
        context.response().ended();
        if (this.nagHttps && !(uri = context.request().absoluteURI()).startsWith("https:")) {
            log.warn("Using session cookies without https could make you susceptible to session hijacking: " + uri);
        }
        if ((cookie = context.getCookie(this.sessionCookieName)) != null) {
            String sessionID = cookie.getValue();
            this.sessionStore.get(sessionID, res -> {
                if (res.succeeded()) {
                    Session session = (Session)res.result();
                    if (session != null) {
                        context.setSession(session);
                        session.setAccessed();
                        this.addStoreSessionHandler(context);
                    } else {
                        this.createNewSession(context);
                    }
                } else {
                    context.fail(res.cause());
                }
                context.next();
            });
        } else {
            this.createNewSession(context);
            context.next();
        }
    }

    private void addStoreSessionHandler(RoutingContext context) {
        context.addHeadersEndHandler(fut -> {
            Session session = context.session();
            if (!session.isDestroyed()) {
                session.setAccessed();
                this.sessionStore.put(session, res -> {
                    if (res.succeeded()) {
                        fut.complete();
                    } else {
                        context.fail(res.cause());
                    }
                });
            } else {
                this.sessionStore.delete(session.id(), res -> {
                    if (res.succeeded()) {
                        fut.complete();
                    } else {
                        context.fail(res.cause());
                    }
                });
            }
        });
    }

    private void createNewSession(RoutingContext context) {
        Session session = this.sessionStore.createSession(this.sessionTimeout);
        context.setSession(session);
        Cookie cookie = Cookie.cookie(this.sessionCookieName, session.id());
        cookie.setPath("/");
        context.addCookie(cookie);
        this.addStoreSessionHandler(context);
    }
}

