/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs.impl;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VoidHandler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.sockjs.BridgeEvent;
import io.vertx.ext.web.handler.sockjs.BridgeOptions;
import io.vertx.ext.web.handler.sockjs.SockJSHandler;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import io.vertx.ext.web.handler.sockjs.Transport;
import io.vertx.ext.web.handler.sockjs.impl.BaseTransport;
import io.vertx.ext.web.handler.sockjs.impl.EventBusBridgeImpl;
import io.vertx.ext.web.handler.sockjs.impl.EventSourceTransport;
import io.vertx.ext.web.handler.sockjs.impl.HtmlFileTransport;
import io.vertx.ext.web.handler.sockjs.impl.JsonPTransport;
import io.vertx.ext.web.handler.sockjs.impl.RawWebSocketTransport;
import io.vertx.ext.web.handler.sockjs.impl.SockJSSession;
import io.vertx.ext.web.handler.sockjs.impl.WebSocketTransport;
import io.vertx.ext.web.handler.sockjs.impl.XhrTransport;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SockJSHandlerImpl
implements SockJSHandler,
Handler<RoutingContext> {
    private static final Logger log = LoggerFactory.getLogger(SockJSHandlerImpl.class);
    private Vertx vertx;
    private Router router;
    private LocalMap<String, SockJSSession> sessions;
    private SockJSHandlerOptions options;
    private static String IFRAME_TEMPLATE = "<!DOCTYPE html>\n<html>\n<head>\n  <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\" />\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n  <script>\n    document.domain = document.domain;\n    _sockjs_onload = function(){SockJS.bootstrap_iframe();};\n  </script>\n  <script src=\"{{ sockjs_url }}\"></script>\n</head>\n<body>\n  <h2>Don't panic!</h2>\n  <p>This is a SockJS hidden iframe. It's used for cross domain magic.</p>\n</body>\n</html>";

    public SockJSHandlerImpl(Vertx vertx, SockJSHandlerOptions options) {
        this.vertx = vertx;
        this.sessions = vertx.sharedData().getLocalMap("_vertx.sockjssessions");
        this.router = Router.router(vertx);
        this.options = options;
    }

    @Override
    public void handle(RoutingContext context) {
        if (log.isTraceEnabled()) {
            log.trace("Got request in sockjs server: " + context.request().uri());
        }
        this.router.handleContext(context);
    }

    @Override
    public SockJSHandler bridge(BridgeOptions bridgeOptions) {
        return this.bridge(bridgeOptions, null);
    }

    @Override
    public SockJSHandler bridge(BridgeOptions bridgeOptions, Handler<BridgeEvent> bridgeEventHandler) {
        this.socketHandler(new EventBusBridgeImpl(this.vertx, bridgeOptions, bridgeEventHandler));
        return this;
    }

    @Override
    public SockJSHandler socketHandler(Handler<SockJSSocket> sockHandler) {
        this.router.route("/").useNormalisedPath(false).handler(rc -> {
            if (log.isTraceEnabled()) {
                log.trace("Returning welcome response");
            }
            rc.response().putHeader("Content-Type", "text/plain; charset=UTF-8").end("Welcome to SockJS!\n");
        });
        String iframeHTML = IFRAME_TEMPLATE.replace("{{ sockjs_url }}", this.options.getLibraryURL());
        Handler<RoutingContext> iframeHandler = this.createIFrameHandler(iframeHTML);
        this.router.get("/iframe.html").handler(iframeHandler);
        this.router.getWithRegex("\\/iframe-[^\\/]*\\.html").handler(iframeHandler);
        this.router.post("/chunking_test").handler(this.createChunkingTestHandler());
        this.router.options("/chunking_test").handler(BaseTransport.createCORSOptionsHandler(this.options, "OPTIONS, POST"));
        this.router.get("/info").handler(BaseTransport.createInfoHandler(this.options));
        this.router.options("/info").handler(BaseTransport.createCORSOptionsHandler(this.options, "OPTIONS, GET"));
        HashSet<String> enabledTransports = new HashSet<String>();
        enabledTransports.add(Transport.EVENT_SOURCE.toString());
        enabledTransports.add(Transport.HTML_FILE.toString());
        enabledTransports.add(Transport.JSON_P.toString());
        enabledTransports.add(Transport.WEBSOCKET.toString());
        enabledTransports.add(Transport.XHR.toString());
        Set<String> disabledTransports = this.options.getDisabledTransports();
        if (disabledTransports == null) {
            disabledTransports = new HashSet<String>();
        }
        enabledTransports.removeAll(disabledTransports);
        if (enabledTransports.contains(Transport.XHR.toString())) {
            new XhrTransport(this.vertx, this.router, this.sessions, this.options, sockHandler);
        }
        if (enabledTransports.contains(Transport.EVENT_SOURCE.toString())) {
            new EventSourceTransport(this.vertx, this.router, this.sessions, this.options, sockHandler);
        }
        if (enabledTransports.contains(Transport.HTML_FILE.toString())) {
            new HtmlFileTransport(this.vertx, this.router, this.sessions, this.options, sockHandler);
        }
        if (enabledTransports.contains(Transport.JSON_P.toString())) {
            new JsonPTransport(this.vertx, this.router, this.sessions, this.options, sockHandler);
        }
        if (enabledTransports.contains(Transport.WEBSOCKET.toString())) {
            new WebSocketTransport(this.vertx, this.router, this.sessions, this.options, sockHandler);
            new RawWebSocketTransport(this.vertx, this.router, sockHandler);
        }
        return this;
    }

    private Handler<RoutingContext> createChunkingTestHandler() {
        return new Handler<RoutingContext>(){

            private void setTimeout(List<TimeoutInfo> timeouts, long delay, Buffer buff) {
                timeouts.add(new TimeoutInfo(delay, buff));
            }

            private void runTimeouts(List<TimeoutInfo> timeouts, HttpServerResponse response) {
                Iterator<TimeoutInfo> iter = timeouts.iterator();
                this.nextTimeout(timeouts, iter, response);
            }

            private void nextTimeout(List<TimeoutInfo> timeouts, Iterator<TimeoutInfo> iter, HttpServerResponse response) {
                if (iter.hasNext()) {
                    TimeoutInfo timeout = iter.next();
                    SockJSHandlerImpl.this.vertx.setTimer(timeout.timeout, id -> {
                        response.write(timeoutInfo.buff);
                        this.nextTimeout(timeouts, iter, response);
                    });
                } else {
                    timeouts.clear();
                }
            }

            @Override
            public void handle(RoutingContext rc) {
                rc.response().headers().set("Content-Type", "application/javascript; charset=UTF-8");
                BaseTransport.setCORS(rc);
                rc.response().setChunked(true);
                Buffer h = Buffer.buffer(2);
                h.appendString("h\n");
                Buffer hs = Buffer.buffer(2050);
                for (int i = 0; i < 2048; ++i) {
                    hs.appendByte((byte)32);
                }
                hs.appendString("h\n");
                ArrayList<TimeoutInfo> timeouts = new ArrayList<TimeoutInfo>();
                this.setTimeout(timeouts, 0L, h);
                this.setTimeout(timeouts, 1L, hs);
                this.setTimeout(timeouts, 5L, h);
                this.setTimeout(timeouts, 25L, h);
                this.setTimeout(timeouts, 125L, h);
                this.setTimeout(timeouts, 625L, h);
                this.setTimeout(timeouts, 3125L, h);
                this.runTimeouts(timeouts, rc.response());
            }

            class TimeoutInfo {
                long timeout;
                Buffer buff;

                TimeoutInfo(long timeout, Buffer buff) {
                    this.timeout = timeout;
                    this.buff = buff;
                }
            }
        };
    }

    private Handler<RoutingContext> createIFrameHandler(String iframeHTML) {
        String etag = SockJSHandlerImpl.getMD5String(iframeHTML);
        return rc -> {
            try {
                if (log.isTraceEnabled()) {
                    log.trace("In Iframe handler");
                }
                if (etag != null && etag.equals(rc.request().getHeader("if-none-match"))) {
                    rc.response().setStatusCode(304);
                    rc.response().end();
                } else {
                    long oneYear = 31536000000L;
                    String expires = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz").format(new Date(System.currentTimeMillis() + oneYear));
                    rc.response().putHeader("Content-Type", "text/html; charset=UTF-8").putHeader("Cache-Control", "public,max-age=31536000").putHeader("Expires", expires).putHeader("ETag", etag).end(iframeHTML);
                }
            }
            catch (Exception e) {
                log.error("Failed to server iframe", e);
            }
        };
    }

    private static String getMD5String(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = md.digest(str.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder();
            for (byte b : bytes) {
                sb.append(Integer.toHexString(b + 127));
            }
            return sb.toString();
        }
        catch (Exception e) {
            log.error("Failed to generate MD5 for iframe, If-None-Match headers will be ignored");
            return null;
        }
    }

    public static void installTestApplications(Router router, final Vertx vertx) {
        router.route("/echo/*").handler(SockJSHandler.create(vertx, new SockJSHandlerOptions().setMaxBytesStreaming(4096)).socketHandler(sock -> sock.handler(sock::write)));
        router.route("/close/*").handler(SockJSHandler.create(vertx, new SockJSHandlerOptions().setMaxBytesStreaming(4096)).socketHandler(sock -> sock.close()));
        router.route("/disabled_websocket_echo/*").handler(SockJSHandler.create(vertx, new SockJSHandlerOptions().setMaxBytesStreaming(4096).addDisabledTransport("WEBSOCKET")).socketHandler(sock -> sock.handler(sock::write)));
        router.route("/ticker/*").handler(SockJSHandler.create(vertx, new SockJSHandlerOptions().setMaxBytesStreaming(4096)).socketHandler(sock -> {
            long timerID = vertx.setPeriodic(1000L, tid -> sock.write(Buffer.buffer("tick!")));
            sock.endHandler(v -> vertx.cancelTimer(timerID));
        }));
        router.route("/amplify/*").handler(SockJSHandler.create(vertx, new SockJSHandlerOptions().setMaxBytesStreaming(4096)).socketHandler(sock -> sock.handler(data -> {
            String str = data.toString();
            int n = Integer.valueOf(str);
            if (n < 0 || n > 19) {
                n = 1;
            }
            int num = (int)Math.pow(2.0, n);
            Buffer buff = Buffer.buffer(num);
            for (int i = 0; i < num; ++i) {
                buff.appendByte((byte)120);
            }
            sock.write(buff);
        })));
        router.route("/broadcast/*").handler(SockJSHandler.create(vertx, new SockJSHandlerOptions().setMaxBytesStreaming(4096)).socketHandler(new Handler<SockJSSocket>(){
            Set<String> connections = new HashSet<String>();

            @Override
            public void handle(final SockJSSocket sock) {
                this.connections.add(sock.writeHandlerID());
                sock.handler(buffer -> {
                    for (String actorID : this.connections) {
                        vertx.eventBus().publish(actorID, buffer);
                    }
                });
                sock.endHandler((Handler)new VoidHandler(){

                    @Override
                    public void handle() {
                        connections.remove(sock.writeHandlerID());
                    }
                });
            }
        }));
        router.route("/cookie_needed_echo/*").handler(SockJSHandler.create(vertx, new SockJSHandlerOptions().setMaxBytesStreaming(4096).setInsertJSESSIONID(true)).socketHandler(sock -> sock.handler(sock::write)));
    }

    public static void main(String[] args) throws Exception {
        Vertx vertx = Vertx.vertx();
        HttpServer server = vertx.createHttpServer();
        Router router = Router.router(vertx);
        SockJSHandlerImpl.installTestApplications(router, vertx);
        server.requestHandler(req -> router.accept((HttpServerRequest)req)).listen(8081);
    }
}

