/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs.impl;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.Shareable;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import io.vertx.ext.web.handler.sockjs.impl.BaseTransport;
import io.vertx.ext.web.handler.sockjs.impl.JsonCodec;
import io.vertx.ext.web.handler.sockjs.impl.SockJSSocketBase;
import io.vertx.ext.web.handler.sockjs.impl.TransportListener;
import java.util.LinkedList;
import java.util.Queue;

class SockJSSession
extends SockJSSocketBase
implements Shareable {
    private static final Logger log = LoggerFactory.getLogger(SockJSSession.class);
    private final LocalMap<String, SockJSSession> sessions;
    private final Queue<String> pendingWrites = new LinkedList<String>();
    private final Queue<String> pendingReads = new LinkedList<String>();
    private TransportListener listener;
    private Handler<Buffer> dataHandler;
    private boolean closed;
    private boolean openWritten;
    private final String id;
    private final long timeout;
    private final Handler<SockJSSocket> sockHandler;
    private long heartbeatID = -1L;
    private long timeoutTimerID = -1L;
    private boolean paused;
    private int maxQueueSize = 65536;
    private int messagesSize;
    private Handler<Void> drainHandler;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;
    private boolean handleCalled;
    private SocketAddress localAddress;
    private SocketAddress remoteAddress;
    private String uri;
    private MultiMap headers;

    SockJSSession(Vertx vertx, LocalMap<String, SockJSSession> sessions, RoutingContext rc, long heartbeatInterval, Handler<SockJSSocket> sockHandler) {
        this(vertx, sessions, rc, null, -1L, heartbeatInterval, sockHandler);
    }

    SockJSSession(Vertx vertx, LocalMap<String, SockJSSession> sessions, RoutingContext rc, String id, long timeout, long heartbeatInterval, Handler<SockJSSocket> sockHandler) {
        super(vertx, rc.session(), rc.user());
        this.sessions = sessions;
        this.id = id;
        this.timeout = timeout;
        this.sockHandler = sockHandler;
        this.heartbeatID = vertx.setPeriodic(heartbeatInterval, tid -> {
            if (this.listener != null) {
                this.listener.sendFrame("h");
            }
        });
    }

    @Override
    public synchronized SockJSSocket write(Buffer buffer) {
        String msgStr = buffer.toString();
        this.pendingWrites.add(msgStr);
        this.messagesSize += msgStr.length();
        if (this.listener != null) {
            this.writePendingMessages();
        }
        return this;
    }

    @Override
    public synchronized SockJSSession handler(Handler<Buffer> handler) {
        this.dataHandler = handler;
        return this;
    }

    @Override
    public synchronized SockJSSession pause() {
        this.paused = true;
        return this;
    }

    @Override
    public synchronized SockJSSession resume() {
        this.paused = false;
        if (this.dataHandler != null) {
            for (String msg : this.pendingReads) {
                this.dataHandler.handle(Buffer.buffer(msg));
            }
        }
        return this;
    }

    @Override
    public synchronized SockJSSession setWriteQueueMaxSize(int maxQueueSize) {
        if (maxQueueSize < 1) {
            throw new IllegalArgumentException("maxQueueSize must be >= 1");
        }
        this.maxQueueSize = maxQueueSize;
        return this;
    }

    @Override
    public synchronized boolean writeQueueFull() {
        return this.messagesSize >= this.maxQueueSize;
    }

    @Override
    public synchronized SockJSSession drainHandler(Handler<Void> handler) {
        this.drainHandler = handler;
        return this;
    }

    @Override
    public synchronized SockJSSession exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public synchronized SockJSSession endHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
        return this;
    }

    public synchronized void shutdown() {
        this.doClose();
    }

    @Override
    public synchronized void close() {
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
        this.closed = true;
        if (this.listener != null && this.handleCalled) {
            this.listener.sessionClosed();
        }
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public SocketAddress localAddress() {
        return this.localAddress;
    }

    @Override
    public MultiMap headers() {
        return this.headers;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    synchronized boolean isClosed() {
        return this.closed;
    }

    synchronized void resetListener() {
        this.listener = null;
        this.setTimer();
    }

    private void cancelTimer() {
        if (this.timeoutTimerID != -1L) {
            this.vertx.cancelTimer(this.timeoutTimerID);
        }
    }

    private void setTimer() {
        if (this.timeout != -1L) {
            this.cancelTimer();
            this.timeoutTimerID = this.vertx.setTimer(this.timeout, new Handler<Long>(){

                @Override
                public void handle(Long id) {
                    SockJSSession.this.vertx.cancelTimer(SockJSSession.this.heartbeatID);
                    if (SockJSSession.this.listener == null) {
                        SockJSSession.this.shutdown();
                    }
                    if (SockJSSession.this.listener != null) {
                        SockJSSession.this.listener.close();
                    }
                }
            });
        }
    }

    synchronized void writePendingMessages() {
        String json = JsonCodec.encode(this.pendingWrites.toArray());
        this.listener.sendFrame("a" + json);
        this.pendingWrites.clear();
        this.messagesSize = 0;
        if (this.drainHandler != null && this.messagesSize <= this.maxQueueSize / 2) {
            Handler<Void> dh = this.drainHandler;
            this.drainHandler = null;
            dh.handle(null);
        }
    }

    synchronized void register(TransportListener lst) {
        if (this.closed) {
            this.writeClosed(lst);
            lst.close();
        } else if (this.listener != null) {
            this.writeClosed(lst, 2010, "Another connection still open");
            lst.close();
        } else {
            this.cancelTimer();
            this.listener = lst;
            if (!this.openWritten) {
                this.writeOpen(lst);
                this.sockHandler.handle(this);
                this.handleCalled = true;
            }
            if (this.listener != null) {
                if (this.closed) {
                    this.writeClosed(lst);
                    this.listener = null;
                    lst.close();
                } else if (!this.pendingWrites.isEmpty()) {
                    this.writePendingMessages();
                }
            }
        }
    }

    private void doClose() {
        super.close();
        if (this.heartbeatID != -1L) {
            this.vertx.cancelTimer(this.heartbeatID);
        }
        if (this.timeoutTimerID != -1L) {
            this.vertx.cancelTimer(this.timeoutTimerID);
        }
        if (this.id != null) {
            this.sessions.remove(this.id);
        }
        if (!this.closed) {
            this.closed = true;
            if (this.endHandler != null) {
                this.endHandler.handle(null);
            }
        }
    }

    private String[] parseMessageString(String msgs) {
        try {
            String[] parts;
            if (msgs.startsWith("[")) {
                parts = (String[])JsonCodec.decodeValue(msgs, String[].class);
            } else {
                String str = (String)JsonCodec.decodeValue(msgs, String.class);
                parts = new String[]{str};
            }
            return parts;
        }
        catch (DecodeException e) {
            return null;
        }
    }

    boolean handleMessages(String messages) {
        String[] msgArr = this.parseMessageString(messages);
        if (msgArr == null) {
            return false;
        }
        if (this.dataHandler != null) {
            for (String msg : msgArr) {
                if (!this.paused) {
                    try {
                        this.dataHandler.handle(Buffer.buffer(msg));
                    }
                    catch (Throwable t) {
                        log.error("Unhandle exception", t);
                    }
                    continue;
                }
                this.pendingReads.add(msg);
            }
        }
        return true;
    }

    void handleException(Throwable t) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(t);
        } else {
            log.error("Unhandled exception", t);
        }
    }

    public void writeClosed(TransportListener lst) {
        this.writeClosed(lst, 3000, "Go away!");
    }

    private void writeClosed(TransportListener lst, int code, String msg) {
        StringBuilder sb = new StringBuilder("c[");
        sb.append(String.valueOf(code)).append(",\"");
        sb.append(msg).append("\"]");
        lst.sendFrame(sb.toString());
    }

    private void writeOpen(TransportListener lst) {
        StringBuilder sb = new StringBuilder("o");
        lst.sendFrame(sb.toString());
        this.openWritten = true;
    }

    void setInfo(SocketAddress localAddress, SocketAddress remoteAddress, String uri, MultiMap headers) {
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.uri = uri;
        this.headers = BaseTransport.removeCookieHeaders(headers);
    }
}

