/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.vertx.ext.web.Cookie;

public class CookieImpl
implements Cookie {
    private final io.netty.handler.codec.http.cookie.Cookie nettyCookie;
    private boolean changed;

    public CookieImpl(String name, String value) {
        this.nettyCookie = new DefaultCookie(name, value);
        this.changed = true;
    }

    public CookieImpl(io.netty.handler.codec.http.cookie.Cookie nettyCookie) {
        this.nettyCookie = nettyCookie;
    }

    @Override
    public String getValue() {
        return this.nettyCookie.value();
    }

    @Override
    public Cookie setValue(String value) {
        this.nettyCookie.setValue(value);
        this.changed = true;
        return this;
    }

    @Override
    public String getName() {
        return this.nettyCookie.name();
    }

    @Override
    public Cookie setDomain(String domain) {
        this.nettyCookie.setDomain(domain);
        this.changed = true;
        return this;
    }

    @Override
    public String getDomain() {
        return this.nettyCookie.domain();
    }

    @Override
    public Cookie setPath(String path) {
        this.nettyCookie.setPath(path);
        this.changed = true;
        return this;
    }

    @Override
    public String getPath() {
        return this.nettyCookie.path();
    }

    @Override
    public Cookie setMaxAge(long maxAge) {
        this.nettyCookie.setMaxAge(maxAge);
        this.changed = true;
        return this;
    }

    @Override
    public Cookie setSecure(boolean secure) {
        this.nettyCookie.setSecure(secure);
        this.changed = true;
        return this;
    }

    @Override
    public Cookie setHttpOnly(boolean httpOnly) {
        this.nettyCookie.setHttpOnly(httpOnly);
        this.changed = true;
        return this;
    }

    @Override
    public String encode() {
        return ServerCookieEncoder.STRICT.encode(this.nettyCookie);
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setChanged(boolean changed) {
        this.changed = changed;
    }
}

