/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.impl;

import de.neuland.jade4j.JadeConfiguration;
import de.neuland.jade4j.template.JadeTemplate;
import de.neuland.jade4j.template.TemplateLoader;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.Utils;
import io.vertx.ext.web.templ.JadeTemplateEngine;
import io.vertx.ext.web.templ.impl.CachingTemplateEngine;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;

public class JadeTemplateEngineImpl
extends CachingTemplateEngine<JadeTemplate>
implements JadeTemplateEngine {
    private final JadeConfiguration config = new JadeConfiguration();
    private final JadeTemplateLoader loader = new JadeTemplateLoader();

    public JadeTemplateEngineImpl() {
        super("jade", 10000);
        this.config.setTemplateLoader((TemplateLoader)this.loader);
    }

    @Override
    public JadeTemplateEngine setExtension(String extension) {
        this.doSetExtension(extension);
        return this;
    }

    @Override
    public JadeTemplateEngine setMaxCacheSize(int maxCacheSize) {
        this.cache.setMaxSize(maxCacheSize);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(RoutingContext context, String templateFileName, Handler<AsyncResult<Buffer>> handler) {
        try {
            JadeTemplate template = (JadeTemplate)this.cache.get(templateFileName);
            if (template == null) {
                JadeTemplateEngineImpl jadeTemplateEngineImpl = this;
                synchronized (jadeTemplateEngineImpl) {
                    this.loader.setVertx(context.vertx());
                    template = this.config.getTemplate(templateFileName);
                }
                this.cache.put(templateFileName, template);
            }
            HashMap<String, RoutingContext> variables = new HashMap<String, RoutingContext>(1);
            variables.put("context", context);
            handler.handle(Future.succeededFuture(Buffer.buffer(this.config.renderTemplate(template, variables))));
        }
        catch (Exception ex) {
            handler.handle(Future.failedFuture(ex));
        }
    }

    @Override
    public JadeConfiguration getJadeConfiguration() {
        return this.config;
    }

    private class JadeTemplateLoader
    implements TemplateLoader {
        private Vertx vertx;
        private long lastMod = System.currentTimeMillis();

        private JadeTemplateLoader() {
        }

        void setVertx(Vertx vertx) {
            this.vertx = vertx;
        }

        public long getLastModified(String name) throws IOException {
            return this.lastMod;
        }

        public Reader getReader(String name) throws IOException {
            String templ = Utils.readFileToString(this.vertx, name = JadeTemplateEngineImpl.this.adjustLocation(name));
            if (templ == null) {
                throw new IllegalArgumentException("Cannot find resource " + name);
            }
            return new StringReader(templ);
        }
    }
}

