/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vertx;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.StaticHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.vertx.AtmosphereCoordinator;
import org.atmosphere.websocket.WebSocketProtocol;
import org.atmosphere.websocket.protocol.SimpleHttpProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxAtmosphere {
    private static final Logger logger = LoggerFactory.getLogger(VertxAtmosphere.class);
    private final AtmosphereCoordinator coordinator = new AtmosphereCoordinator();

    private VertxAtmosphere(Builder b) {
        Router router = Router.router((Vertx)b.vertx);
        router.route().handler((Handler)StaticHandler.create((String)b.webroot));
        router.get(b.url).handler(this.handleHttp());
        router.post(b.url).handler(this.handleHttp());
        b.httpServer.requestHandler(arg_0 -> ((Router)router).accept(arg_0));
        b.httpServer.websocketHandler(this.handleWebSocket());
        if (b.resource != null) {
            this.coordinator.configure(b);
        }
        this.coordinator.ready();
    }

    public AtmosphereCoordinator coordinator() {
        return this.coordinator;
    }

    public boolean matchPath(String path) {
        return this.coordinator.matchPath(path);
    }

    private Handler<RoutingContext> handleHttp() {
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext req) {
                logger.trace("HTTP received");
                VertxAtmosphere.this.coordinator.route(req.request());
            }
        };
    }

    private Handler<ServerWebSocket> handleWebSocket() {
        return new Handler<ServerWebSocket>(){

            public void handle(ServerWebSocket webSocket) {
                logger.trace("WebSocket received {}", (Object)webSocket);
                VertxAtmosphere.this.coordinator.route(webSocket);
            }
        };
    }

    public static final class Builder {
        protected String url;
        protected HttpServer httpServer;
        protected Class<?> resource;
        protected final Map<String, String> initParams = new HashMap<String, String>();
        protected Class<? extends WebSocketProtocol> webSocketProtocol = SimpleHttpProtocol.class;
        protected Vertx vertx;
        protected Class<Broadcaster> broadcasterClass;
        protected BroadcasterFactory broadcasterFactory;
        protected Class<? extends BroadcasterCache> broadcasterCache;
        protected final List<AtmosphereInterceptor> interceptors = new ArrayList<AtmosphereInterceptor>();
        protected String webroot;

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder webroot(String webroot) {
            this.webroot = webroot;
            return this;
        }

        public Builder httpServer(HttpServer httpServer) {
            this.httpServer = httpServer;
            return this;
        }

        public VertxAtmosphere build() {
            return new VertxAtmosphere(this);
        }

        public Builder resource(Class<?> resource) {
            this.resource = resource;
            return this;
        }

        public Builder initParam(String name, String value) {
            this.initParams.put(name, value);
            return this;
        }

        public Builder broadcaster(Class<Broadcaster> broadcasterClass) {
            this.broadcasterClass = broadcasterClass;
            return this;
        }

        public Builder broadcasterFactory(BroadcasterFactory broadcasterFactory) {
            this.broadcasterFactory = broadcasterFactory;
            return this;
        }

        public Builder broadcasterCache(Class<? extends BroadcasterCache> broadcasterCache) {
            this.broadcasterCache = broadcasterCache;
            return this;
        }

        public Builder webSocketProtocol(Class<? extends WebSocketProtocol> webSocketProtocol) {
            this.webSocketProtocol = webSocketProtocol;
            return this;
        }

        public Builder interceptor(AtmosphereInterceptor interceptor) {
            this.interceptors.add(interceptor);
            return this;
        }

        public Builder vertx(Vertx vertx) {
            this.vertx = vertx;
            return this;
        }
    }
}

