/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.datagram.impl;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextImpl;

final class DatagramChannelFutureListener<T>
implements ChannelFutureListener {
    private final Handler<AsyncResult<T>> handler;
    private final T result;
    private final ContextImpl context;

    DatagramChannelFutureListener(T result, Handler<AsyncResult<T>> handler, ContextImpl context) {
        this.handler = handler;
        this.result = result;
        this.context = context;
    }

    @Override
    public void operationComplete(ChannelFuture future) throws Exception {
        this.context.executeFromIO(() -> this.notifyHandler(future));
    }

    private void notifyHandler(ChannelFuture future) {
        if (future.isSuccess()) {
            this.handler.handle(Future.succeededFuture(this.result));
        } else {
            this.handler.handle(Future.failedFuture(future.cause()));
        }
    }
}

