/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebsocketRejectedException;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.http.impl.AssembledFullHttpRequest;
import io.vertx.core.http.impl.AssembledHttpRequest;
import io.vertx.core.http.impl.HeadersAdaptor;
import io.vertx.core.http.impl.Http1xConnectionBase;
import io.vertx.core.http.impl.Http1xPool;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientRequestBase;
import io.vertx.core.http.impl.HttpClientRequestImpl;
import io.vertx.core.http.impl.HttpClientResponseImpl;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.WebSocketImpl;
import io.vertx.core.http.impl.ws.WebSocketFrameInternal;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.NetSocketImpl;
import io.vertx.core.net.impl.VertxNetHandler;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;

class ClientConnection
extends Http1xConnectionBase
implements HttpClientConnection,
HttpClientStream {
    private static final Logger log = LoggerFactory.getLogger(ClientConnection.class);
    private final HttpClientImpl client;
    private final boolean ssl;
    private final String host;
    private final int port;
    private final Http1xPool pool;
    private final Object endpointMetric;
    private final Deque<HttpClientRequestImpl> requests = new ArrayDeque<HttpClientRequestImpl>();
    private final HttpClientMetrics metrics;
    private final HttpVersion version;
    private WebSocketClientHandshaker handshaker;
    private HttpClientRequestImpl currentRequest;
    private HttpClientResponseImpl currentResponse;
    private HttpClientRequestImpl requestForResponse;
    private WebSocketImpl ws;
    private boolean reset;
    private boolean paused;
    private Buffer pausedChunk;

    ClientConnection(HttpVersion version, HttpClientImpl client, Object endpointMetric, ChannelHandlerContext channel, boolean ssl, String host, int port, ContextImpl context, Http1xPool pool, HttpClientMetrics metrics) {
        super(client.getVertx(), channel, context);
        this.client = client;
        this.ssl = ssl;
        this.host = host;
        this.port = port;
        this.pool = pool;
        this.metrics = metrics;
        this.version = version;
        this.endpointMetric = endpointMetric;
    }

    @Override
    public HttpClientMetrics metrics() {
        return this.metrics;
    }

    synchronized HttpClientRequestImpl getCurrentRequest() {
        return this.currentRequest;
    }

    synchronized void toWebSocket(String requestURI, MultiMap headers, WebsocketVersion vers, String subProtocols, int maxWebSocketFrameSize, Handler<WebSocket> wsConnect) {
        if (this.ws != null) {
            throw new IllegalStateException("Already websocket");
        }
        try {
            DefaultHttpHeaders nettyHeaders;
            URI wsuri = new URI(requestURI);
            if (!wsuri.isAbsolute()) {
                wsuri = new URI((this.ssl ? "https:" : "http:") + "//" + this.host + ":" + this.port + requestURI);
            }
            WebSocketVersion version = WebSocketVersion.valueOf((vers == null ? WebSocketVersion.V13 : vers).toString());
            if (headers != null) {
                nettyHeaders = new DefaultHttpHeaders();
                for (Map.Entry entry : headers) {
                    ((io.netty.handler.codec.http.HttpHeaders)nettyHeaders).add((String)entry.getKey(), entry.getValue());
                }
            } else {
                nettyHeaders = null;
            }
            this.handshaker = WebSocketClientHandshakerFactory.newHandshaker(wsuri, version, subProtocols, false, nettyHeaders, maxWebSocketFrameSize, !this.client.getOptions().isSendUnmaskedFrames(), false);
            ChannelPipeline p = this.chctx.pipeline();
            p.addBefore("handler", "handshakeCompleter", new HandshakeInboundHandler(wsConnect, version != WebSocketVersion.V00));
            this.handshaker.handshake(this.chctx.channel()).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                Handler<Throwable> handler = this.exceptionHandler();
                if (!future.isSuccess() && handler != null) {
                    handler.handle(future.cause());
                }
            }));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public boolean isValid() {
        return !this.reset && this.chctx.channel().isOpen();
    }

    int getOutstandingRequestCount() {
        return this.requests.size();
    }

    @Override
    public void checkDrained() {
        this.handleInterestedOpsChanged();
    }

    @Override
    public synchronized void handleInterestedOpsChanged() {
        if (!this.isNotWritable()) {
            if (this.currentRequest != null) {
                this.currentRequest.handleDrained();
            } else if (this.ws != null) {
                this.ws.writable();
            }
        }
    }

    void handleResponse(HttpResponse resp) {
        HttpClientResponseImpl nResp;
        this.requestForResponse = resp.status().code() == 100 ? this.requests.peek() : this.requests.poll();
        if (this.requestForResponse == null) {
            throw new IllegalStateException("No response handler");
        }
        io.netty.handler.codec.http.HttpVersion nettyVersion = resp.protocolVersion();
        HttpVersion vertxVersion = nettyVersion == io.netty.handler.codec.http.HttpVersion.HTTP_1_0 ? HttpVersion.HTTP_1_0 : (nettyVersion == io.netty.handler.codec.http.HttpVersion.HTTP_1_1 ? HttpVersion.HTTP_1_1 : null);
        this.currentResponse = nResp = new HttpClientResponseImpl(this.requestForResponse, vertxVersion, this, resp.status().code(), resp.status().reasonPhrase(), new HeadersAdaptor(resp.headers()));
        if (this.metrics != null) {
            this.metrics.responseBegin(this.requestForResponse.metric(), nResp);
        }
        if (vertxVersion != null) {
            this.requestForResponse.handleResponse(nResp);
        } else {
            this.requestForResponse.handleException(new IllegalStateException("Unsupported HTTP version: " + nettyVersion));
        }
    }

    @Override
    public void doPause() {
        super.doPause();
        this.paused = true;
    }

    @Override
    public void doResume() {
        super.doResume();
        this.paused = false;
        if (this.pausedChunk != null) {
            this.vertx.runOnContext(v -> {
                if (this.pausedChunk != null) {
                    Buffer chunk = this.pausedChunk;
                    this.pausedChunk = null;
                    this.currentResponse.handleChunk(chunk);
                }
            });
        }
    }

    void handleResponseChunk(Buffer buff) {
        if (this.paused) {
            if (this.pausedChunk == null) {
                this.pausedChunk = buff.copy();
            } else {
                this.pausedChunk.appendBuffer(buff);
            }
        } else {
            if (this.pausedChunk != null) {
                buff = this.pausedChunk.appendBuffer(buff);
                this.pausedChunk = null;
            }
            this.currentResponse.handleChunk(buff);
        }
    }

    void handleResponseEnd(LastHttpContent trailer) {
        if (this.metrics != null) {
            HttpClientRequestBase req = this.currentResponse.request();
            Object reqMetric = req.metric();
            if (req.exceptionOccurred != null) {
                this.metrics.requestReset(reqMetric);
            } else {
                this.metrics.responseEnd(reqMetric, this.currentResponse);
            }
        }
        Buffer last = this.pausedChunk;
        this.pausedChunk = null;
        this.currentResponse.handleEnd(last, new HeadersAdaptor(trailer.trailingHeaders()));
        if (this.currentResponse.statusCode() != 100 && this.requestForResponse.method() != HttpMethod.CONNECT) {
            boolean close = false;
            String responseConnectionHeader = this.currentResponse.getHeader("Connection");
            HttpVersion protocolVersion = this.client.getOptions().getProtocolVersion();
            String requestConnectionHeader = this.requestForResponse.headers().get("Connection");
            if ("close".equalsIgnoreCase(responseConnectionHeader) || "close".equalsIgnoreCase(requestConnectionHeader)) {
                close = true;
            } else if (protocolVersion == HttpVersion.HTTP_1_0 && !"keep-alive".equalsIgnoreCase(responseConnectionHeader)) {
                close = true;
            }
            if (close) {
                this.pool.responseEnded(this, true);
            } else if (this.reset) {
                if (this.requests.isEmpty()) {
                    this.pool.responseEnded(this, true);
                }
            } else {
                this.pool.responseEnded(this, false);
            }
        }
        this.requestForResponse = null;
        this.currentResponse = null;
    }

    synchronized void handleWsFrame(WebSocketFrameInternal frame) {
        if (this.ws != null) {
            this.ws.handleFrame(frame);
        }
    }

    @Override
    protected synchronized void handleClosed() {
        super.handleClosed();
        if (this.ws != null) {
            this.ws.handleClosed();
        }
        VertxException e = new VertxException("Connection was closed");
        if (this.metrics != null) {
            for (HttpClientRequestImpl req : this.requests) {
                this.metrics.requestReset(req.metric());
            }
            if (this.currentResponse != null) {
                this.metrics.requestReset(this.currentResponse.request().metric());
            }
        }
        for (HttpClientRequestImpl req : this.requests) {
            if (req == this.currentRequest) continue;
            req.handleException(e);
        }
        if (this.currentRequest != null) {
            this.currentRequest.handleException(e);
        } else if (this.currentResponse != null) {
            this.currentResponse.handleException(e);
        }
    }

    @Override
    public ContextImpl getContext() {
        return super.getContext();
    }

    @Override
    public void reset(long code) {
        if (!this.reset) {
            this.reset = true;
            if (this.currentRequest != null) {
                this.requests.removeLast();
            }
            if (this.requests.size() == 0) {
                this.pool.responseEnded(this, true);
            }
        }
    }

    private HttpRequest createRequest(HttpVersion version, HttpMethod method, String rawMethod, String uri, MultiMap headers) {
        DefaultHttpRequest request = new DefaultHttpRequest(HttpUtils.toNettyHttpVersion(version), HttpUtils.toNettyHttpMethod(method, rawMethod), uri, false);
        if (headers != null) {
            for (Map.Entry header : headers) {
                request.headers().add((String)header.getKey(), header.getValue());
            }
        }
        return request;
    }

    private void prepareHeaders(HttpRequest request, String hostHeader, boolean chunked) {
        io.netty.handler.codec.http.HttpHeaders headers = request.headers();
        headers.remove(HttpHeaders.TRANSFER_ENCODING);
        if (!headers.contains(HttpHeaders.HOST)) {
            request.headers().set(HttpHeaders.HOST, (Object)hostHeader);
        }
        if (chunked) {
            io.netty.handler.codec.http.HttpHeaders.setTransferEncodingChunked(request);
        }
        if (this.client.getOptions().isTryUseCompression() && request.headers().get(HttpHeaders.ACCEPT_ENCODING) == null) {
            request.headers().set(HttpHeaders.ACCEPT_ENCODING, (Object)HttpHeaders.DEFLATE_GZIP);
        }
        if (!this.client.getOptions().isKeepAlive() && this.client.getOptions().getProtocolVersion() == HttpVersion.HTTP_1_1) {
            request.headers().set(HttpHeaders.CONNECTION, (Object)HttpHeaders.CLOSE);
        } else if (this.client.getOptions().isKeepAlive() && this.client.getOptions().getProtocolVersion() == HttpVersion.HTTP_1_0) {
            request.headers().set(HttpHeaders.CONNECTION, (Object)HttpHeaders.KEEP_ALIVE);
        }
    }

    @Override
    public void writeHead(HttpMethod method, String rawMethod, String uri, MultiMap headers, String hostHeader, boolean chunked) {
        HttpRequest request = this.createRequest(this.version, method, rawMethod, uri, headers);
        this.prepareHeaders(request, hostHeader, chunked);
        this.writeToChannel(request);
    }

    @Override
    public void writeHeadWithContent(HttpMethod method, String rawMethod, String uri, MultiMap headers, String hostHeader, boolean chunked, ByteBuf buf, boolean end) {
        HttpRequest request = this.createRequest(this.version, method, rawMethod, uri, headers);
        this.prepareHeaders(request, hostHeader, chunked);
        if (end) {
            if (buf != null) {
                this.writeToChannel(new AssembledFullHttpRequest(request, buf));
            } else {
                this.writeToChannel(new AssembledFullHttpRequest(request));
            }
        } else {
            this.writeToChannel(new AssembledHttpRequest(request, buf));
        }
    }

    @Override
    public void writeBuffer(ByteBuf buff, boolean end) {
        if (end) {
            if (buff != null && buff.isReadable()) {
                this.writeToChannel(new DefaultLastHttpContent(buff, false));
            } else {
                this.writeToChannel(LastHttpContent.EMPTY_LAST_CONTENT);
            }
        } else if (buff != null) {
            this.writeToChannel(new DefaultHttpContent(buff));
        }
    }

    @Override
    public void writeFrame(int type, int flags, ByteBuf payload) {
        throw new IllegalStateException("Cannot write an HTTP/2 frame over an HTTP/1.x connection");
    }

    @Override
    protected synchronized void handleException(Throwable e) {
        super.handleException(e);
        if (this.currentRequest != null) {
            this.currentRequest.handleException(e);
        } else {
            HttpClientRequestImpl req = this.requests.poll();
            if (req != null) {
                req.handleException(e);
            } else if (this.currentResponse != null) {
                this.currentResponse.handleException(e);
            }
        }
    }

    @Override
    public synchronized void beginRequest(HttpClientRequestImpl req) {
        if (this.currentRequest != null) {
            throw new IllegalStateException("Connection is already writing a request");
        }
        if (this.metrics != null) {
            Object reqMetric = this.metrics.requestBegin(this.endpointMetric, this.metric(), this.localAddress(), this.remoteAddress(), req);
            req.metric(reqMetric);
        }
        this.currentRequest = req;
        this.requests.add(req);
    }

    @Override
    public synchronized void endRequest() {
        if (this.currentRequest == null) {
            throw new IllegalStateException("No write in progress");
        }
        if (this.metrics != null) {
            this.metrics.requestEnd(this.currentRequest.metric());
        }
        this.currentRequest = null;
        this.pool.requestEnded(this);
    }

    @Override
    public synchronized void close() {
        if (this.handshaker == null) {
            super.close();
        } else {
            this.endReadAndFlush();
            this.handshaker.close(this.chctx.channel(), new CloseWebSocketFrame(1000, null));
        }
    }

    @Override
    public NetSocket createNetSocket() {
        NetSocketImpl socket = new NetSocketImpl(this.vertx, this.chctx, this.context, this.client.getSslHelper(), this.metrics);
        socket.metric(this.metric());
        HashMap<Channel, NetSocketImpl> connectionMap = new HashMap<Channel, NetSocketImpl>(1);
        connectionMap.put(this.chctx.channel(), socket);
        this.endReadAndFlush();
        ChannelPipeline pipeline = this.chctx.pipeline();
        HttpContentDecompressor inflater = pipeline.get(HttpContentDecompressor.class);
        if (inflater != null) {
            pipeline.remove(inflater);
        }
        pipeline.remove("codec");
        pipeline.replace("handler", "handler", new VertxNetHandler(socket){

            @Override
            public void channelRead(ChannelHandlerContext chctx, Object msg) throws Exception {
                if (msg instanceof HttpContent) {
                    if (msg instanceof LastHttpContent) {
                        ClientConnection.this.handleResponseEnd((LastHttpContent)msg);
                    }
                    ReferenceCountUtil.release(msg);
                    return;
                }
                super.channelRead(chctx, msg);
            }

            @Override
            protected void handleMessage(NetSocketImpl connection, ContextImpl context, ChannelHandlerContext chctx, Object msg) throws Exception {
                ByteBuf buf = (ByteBuf)msg;
                connection.handleMessageReceived(buf);
            }
        }.removeHandler(sock -> this.pool.removeChannel(this.chctx.channel())));
        return socket;
    }

    @Override
    public HttpClientConnection connection() {
        return this;
    }

    @Override
    public HttpVersion version() {
        return null;
    }

    @Override
    public int id() {
        return -1;
    }

    private final class HandshakeInboundHandler
    extends ChannelInboundHandlerAdapter {
        private final boolean supportsContinuation;
        private final Handler<WebSocket> wsConnect;
        private final ContextImpl context;
        private final Queue<Object> buffered = new ArrayDeque<Object>();
        private FullHttpResponse response;
        private boolean handshaking = true;

        public HandshakeInboundHandler(Handler<WebSocket> wsConnect, boolean supportsContinuation) {
            this.supportsContinuation = supportsContinuation;
            this.wsConnect = wsConnect;
            this.context = ClientConnection.this.vertx.getContext();
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            super.channelInactive(ctx);
            if (this.handshaking) {
                this.handleException(new WebSocketHandshakeException("Connection closed while handshake in process"));
            }
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (ClientConnection.this.handshaker != null && this.handshaking) {
                if (msg instanceof HttpResponse) {
                    HttpResponse resp = (HttpResponse)msg;
                    HttpResponseStatus status = resp.status();
                    if (status.code() != 101) {
                        ClientConnection.this.handshaker = null;
                        ClientConnection.this.close();
                        this.handleException(new WebsocketRejectedException(status.code()));
                        return;
                    }
                    this.response = new DefaultFullHttpResponse(resp.protocolVersion(), status);
                    this.response.headers().add(resp.headers());
                }
                if (msg instanceof HttpContent && this.response != null) {
                    this.response.content().writeBytes(((HttpContent)msg).content());
                    if (msg instanceof LastHttpContent) {
                        this.response.trailingHeaders().add(((LastHttpContent)msg).trailingHeaders());
                        try {
                            Object m;
                            this.handshakeComplete(ctx, this.response);
                            ClientConnection.this.chctx.pipeline().remove(this);
                            while ((m = this.buffered.poll()) != null) {
                                ctx.fireChannelRead(m);
                            }
                        }
                        catch (WebSocketHandshakeException e) {
                            ClientConnection.this.close();
                            this.handleException(e);
                        }
                    }
                }
            } else {
                this.buffered.add(msg);
            }
        }

        private void handleException(Exception e) {
            this.handshaking = false;
            this.buffered.clear();
            Handler handler = ClientConnection.this.exceptionHandler();
            if (handler != null) {
                this.context.executeFromIO(() -> handler.handle(e));
            } else {
                log.error((Object)"Error in websocket handshake", e);
            }
        }

        private void handshakeComplete(ChannelHandlerContext ctx, FullHttpResponse response) {
            this.handshaking = false;
            HttpContentDecompressor handler = ctx.pipeline().get(HttpContentDecompressor.class);
            if (handler != null) {
                ctx.pipeline().remove(handler);
            }
            ContextImpl.setContext(this.context);
            WebSocketImpl webSocket = new WebSocketImpl(ClientConnection.this.vertx, ClientConnection.this, this.supportsContinuation, ClientConnection.this.client.getOptions().getMaxWebsocketFrameSize(), ClientConnection.this.client.getOptions().getMaxWebsocketMessageSize());
            ClientConnection.this.ws = webSocket;
            ClientConnection.this.handshaker.finishHandshake(ClientConnection.this.chctx.channel(), response);
            ClientConnection.this.ws.subProtocol(ClientConnection.this.handshaker.actualSubprotocol());
            this.context.executeFromIO(() -> {
                log.debug("WebSocket handshake complete");
                if (ClientConnection.this.metrics != null) {
                    webSocket.setMetric(ClientConnection.this.metrics.connected(ClientConnection.this.endpointMetric, ClientConnection.this.metric(), webSocket));
                }
                this.wsConnect.handle(webSocket);
            });
        }
    }
}

