/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http2.Http2Headers;
import io.vertx.core.MultiMap;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Http2HeadersAdaptor
implements MultiMap {
    private final Http2Headers headers;
    private Set<String> names;

    static CharSequence toLowerCase(CharSequence s) {
        StringBuilder buffer = null;
        int len = s.length();
        for (int index = 0; index < len; ++index) {
            char c = s.charAt(index);
            if (c < 'A' || c > 'Z') continue;
            if (buffer == null) {
                buffer = new StringBuilder(s);
            }
            buffer.setCharAt(index, (char)(c + 32));
        }
        if (buffer != null) {
            return buffer.toString();
        }
        return s;
    }

    public Http2HeadersAdaptor(Http2Headers headers) {
        List cookies = headers.getAll(HttpHeaderNames.COOKIE);
        if (cookies != null && cookies.size() > 1) {
            String value = cookies.stream().collect(Collectors.joining("; "));
            headers.set(HttpHeaderNames.COOKIE, value);
        }
        this.headers = headers;
    }

    @Override
    public String get(String name) {
        CharSequence val = (CharSequence)this.headers.get(Http2HeadersAdaptor.toLowerCase(name));
        return val != null ? val.toString() : null;
    }

    @Override
    public List<String> getAll(String name) {
        final List all = this.headers.getAll(Http2HeadersAdaptor.toLowerCase(name));
        if (all != null) {
            return new AbstractList<String>(){

                @Override
                public String get(int index) {
                    return ((CharSequence)all.get(index)).toString();
                }

                @Override
                public int size() {
                    return all.size();
                }
            };
        }
        return null;
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        return this.headers.names().stream().map(name -> new AbstractMap.SimpleEntry<String, String>(name.toString(), ((CharSequence)this.headers.get(name)).toString())).collect(Collectors.toList());
    }

    @Override
    public boolean contains(String name) {
        return this.headers.contains(Http2HeadersAdaptor.toLowerCase(name));
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public Set<String> names() {
        if (this.names == null) {
            this.names = new AbstractSet<String>(){

                @Override
                public Iterator<String> iterator() {
                    final Iterator it = Http2HeadersAdaptor.this.headers.names().iterator();
                    return new Iterator<String>(){

                        @Override
                        public boolean hasNext() {
                            return it.hasNext();
                        }

                        @Override
                        public String next() {
                            return ((CharSequence)it.next()).toString();
                        }
                    };
                }

                @Override
                public int size() {
                    return Http2HeadersAdaptor.this.headers.size();
                }
            };
        }
        return this.names;
    }

    @Override
    public MultiMap add(String name, String value) {
        this.headers.add(Http2HeadersAdaptor.toLowerCase(name), value);
        return this;
    }

    @Override
    public MultiMap add(String name, Iterable<String> values) {
        this.headers.add(Http2HeadersAdaptor.toLowerCase(name), values);
        return this;
    }

    @Override
    public MultiMap addAll(MultiMap headers) {
        for (Map.Entry<String, String> entry : headers.entries()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public MultiMap addAll(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public MultiMap set(String name, String value) {
        this.headers.set(Http2HeadersAdaptor.toLowerCase(name), value);
        return this;
    }

    @Override
    public MultiMap set(String name, Iterable<String> values) {
        this.headers.set(Http2HeadersAdaptor.toLowerCase(name), values);
        return this;
    }

    @Override
    public MultiMap setAll(MultiMap httpHeaders) {
        this.clear();
        for (Map.Entry entry : httpHeaders) {
            this.add((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    @Override
    public MultiMap remove(String name) {
        this.headers.remove(Http2HeadersAdaptor.toLowerCase(name));
        return this;
    }

    @Override
    public MultiMap clear() {
        this.headers.clear();
        return this;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.entries().iterator();
    }

    @Override
    public int size() {
        return this.names().size();
    }

    @Override
    public MultiMap setAll(Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public String get(CharSequence name) {
        CharSequence val = (CharSequence)this.headers.get(Http2HeadersAdaptor.toLowerCase(name));
        return val != null ? val.toString() : null;
    }

    @Override
    public List<String> getAll(CharSequence name) {
        List all = this.headers.getAll(Http2HeadersAdaptor.toLowerCase(name));
        return all != null ? all.stream().map(CharSequence::toString).collect(Collectors.toList()) : null;
    }

    @Override
    public boolean contains(CharSequence name) {
        return this.headers.contains(Http2HeadersAdaptor.toLowerCase(name));
    }

    @Override
    public MultiMap add(CharSequence name, CharSequence value) {
        this.headers.add(Http2HeadersAdaptor.toLowerCase(name), value);
        return this;
    }

    @Override
    public MultiMap add(CharSequence name, Iterable<CharSequence> values) {
        this.headers.add(Http2HeadersAdaptor.toLowerCase(name), values);
        return this;
    }

    @Override
    public MultiMap set(CharSequence name, CharSequence value) {
        this.headers.set(Http2HeadersAdaptor.toLowerCase(name), value);
        return this;
    }

    @Override
    public MultiMap set(CharSequence name, Iterable<CharSequence> values) {
        this.headers.set(Http2HeadersAdaptor.toLowerCase(name), values);
        return this;
    }

    @Override
    public MultiMap remove(CharSequence name) {
        this.headers.remove(Http2HeadersAdaptor.toLowerCase(name));
        return this;
    }
}

