/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.FaviconHandler;
import io.vertx.ext.web.impl.Utils;

public class FaviconHandlerImpl
implements FaviconHandler {
    private Icon icon;
    private final String path;
    private final long maxAgeSeconds;

    public FaviconHandlerImpl(String path, long maxAgeSeconds) {
        this.path = path;
        this.maxAgeSeconds = maxAgeSeconds;
        if (maxAgeSeconds < 0L) {
            throw new IllegalArgumentException("maxAgeSeconds must be > 0");
        }
    }

    public FaviconHandlerImpl(long maxAgeSeconds) {
        this(null, maxAgeSeconds);
    }

    public FaviconHandlerImpl(String path) {
        this(path, 86400L);
    }

    public FaviconHandlerImpl() {
        this(null);
    }

    private void init(Vertx vertx) {
        try {
            this.icon = this.path == null ? new Icon(Utils.readResourceToBuffer("favicon.ico")) : new Icon(vertx.fileSystem().readFileBlocking(this.path));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handle(RoutingContext ctx) {
        if (this.icon == null) {
            this.init(ctx.vertx());
        }
        if ("/favicon.ico".equals(ctx.request().path())) {
            ctx.response().headers().addAll(this.icon.headers);
            ctx.response().end(this.icon.body);
        } else {
            ctx.next();
        }
    }

    private class Icon {
        private final MultiMap headers = new CaseInsensitiveHeaders();
        private final Buffer body;

        private Icon(Buffer buffer) {
            this.body = buffer;
            this.headers.add(HttpHeaders.CONTENT_TYPE, (CharSequence)"image/x-icon");
            this.headers.add(HttpHeaders.CONTENT_LENGTH, (CharSequence)Integer.toString(buffer.length()));
            this.headers.add(HttpHeaders.CACHE_CONTROL, (CharSequence)("public, max-age=" + FaviconHandlerImpl.this.maxAgeSeconds));
        }
    }
}

