/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.TemplateHandler;
import io.vertx.ext.web.impl.Utils;
import io.vertx.ext.web.templ.TemplateEngine;

public class TemplateHandlerImpl
implements TemplateHandler {
    private final TemplateEngine engine;
    private final String templateDirectory;
    private final String contentType;
    private String indexTemplate;

    public TemplateHandlerImpl(TemplateEngine engine, String templateDirectory, String contentType) {
        this.engine = engine;
        this.templateDirectory = templateDirectory == null || templateDirectory.isEmpty() ? "." : templateDirectory;
        this.contentType = contentType;
        this.indexTemplate = "index";
    }

    @Override
    public void handle(RoutingContext context) {
        String file = Utils.pathOffset(context.normalisedPath(), context);
        if (file.endsWith("/") && null != this.indexTemplate) {
            file = file + this.indexTemplate;
        }
        this.engine.render(context, this.templateDirectory, file, res -> {
            if (res.succeeded()) {
                context.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)this.contentType).end((Buffer)res.result());
            } else {
                context.fail(res.cause());
            }
        });
    }

    @Override
    public TemplateHandler setIndexTemplate(String indexTemplate) {
        this.indexTemplate = indexTemplate;
        return this;
    }
}

