/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore.impl;

import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.shareddata.Shareable;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import io.vertx.ext.auth.PRNG;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.impl.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SessionImpl
implements Session,
ClusterSerializable,
Shareable {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final char[] HEX = "0123456789abcdef".toCharArray();
    private static final byte TYPE_LONG = 1;
    private static final byte TYPE_INT = 2;
    private static final byte TYPE_SHORT = 3;
    private static final byte TYPE_BYTE = 4;
    private static final byte TYPE_DOUBLE = 5;
    private static final byte TYPE_FLOAT = 6;
    private static final byte TYPE_CHAR = 7;
    private static final byte TYPE_BOOLEAN = 8;
    private static final byte TYPE_STRING = 9;
    private static final byte TYPE_BUFFER = 10;
    private static final byte TYPE_BYTES = 11;
    private static final byte TYPE_SERIALIZABLE = 12;
    private static final byte TYPE_CLUSTER_SERIALIZABLE = 13;
    private PRNG prng;
    private String id;
    private long timeout;
    private volatile Map<String, Object> data;
    private long lastAccessed;
    private int version;
    private boolean destroyed;
    private boolean renewed;
    private String oldId;
    private int crc;
    private Buffer buffer;
    private static final int[] CRC16_TABLE = new int[]{0, 49345, 49537, 320, 49921, 960, 640, 49729, 50689, 1728, 1920, 51009, 1280, 50625, 50305, 1088, 52225, 3264, 3456, 52545, 3840, 53185, 52865, 3648, 2560, 51905, 52097, 2880, 51457, 2496, 2176, 51265, 55297, 6336, 6528, 55617, 6912, 56257, 55937, 6720, 7680, 57025, 57217, 8000, 56577, 7616, 7296, 56385, 5120, 54465, 54657, 5440, 55041, 6080, 5760, 54849, 53761, 4800, 4992, 54081, 4352, 53697, 53377, 4160, 61441, 12480, 12672, 61761, 13056, 62401, 62081, 12864, 13824, 63169, 63361, 14144, 62721, 13760, 13440, 62529, 15360, 64705, 64897, 15680, 65281, 16320, 16000, 65089, 64001, 15040, 15232, 64321, 14592, 63937, 63617, 14400, 10240, 59585, 59777, 10560, 60161, 11200, 10880, 59969, 60929, 11968, 12160, 61249, 11520, 60865, 60545, 11328, 58369, 9408, 9600, 58689, 9984, 59329, 59009, 9792, 8704, 58049, 58241, 9024, 57601, 8640, 8320, 57409, 40961, 24768, 24960, 41281, 25344, 41921, 41601, 25152, 26112, 42689, 42881, 26432, 42241, 26048, 25728, 42049, 27648, 44225, 44417, 27968, 44801, 28608, 28288, 44609, 43521, 27328, 27520, 43841, 26880, 43457, 43137, 26688, 30720, 47297, 47489, 31040, 47873, 31680, 31360, 47681, 48641, 32448, 32640, 48961, 32000, 48577, 48257, 31808, 46081, 29888, 30080, 46401, 30464, 47041, 46721, 30272, 29184, 45761, 45953, 29504, 45313, 29120, 28800, 45121, 20480, 37057, 37249, 20800, 37633, 21440, 21120, 37441, 38401, 22208, 22400, 38721, 21760, 38337, 38017, 21568, 39937, 23744, 23936, 40257, 24320, 40897, 40577, 24128, 23040, 39617, 39809, 23360, 39169, 22976, 22656, 38977, 34817, 18624, 18816, 35137, 19200, 35777, 35457, 19008, 19968, 36545, 36737, 20288, 36097, 19904, 19584, 35905, 17408, 33985, 34177, 17728, 34561, 18368, 18048, 34369, 33281, 17088, 17280, 33601, 16640, 33217, 32897, 16448};

    public SessionImpl() {
    }

    public SessionImpl(PRNG random) {
        this.prng = random;
    }

    public SessionImpl(PRNG random, long timeout, int length) {
        this.prng = random;
        this.id = SessionImpl.generateId(this.prng, length);
        this.timeout = timeout;
        this.lastAccessed = System.currentTimeMillis();
    }

    void setPRNG(PRNG prng) {
        this.prng = prng;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Session regenerateId() {
        if (this.oldId == null) {
            this.oldId = this.id;
        }
        this.id = SessionImpl.generateId(this.prng, this.oldId.length() / 2);
        this.renewed = true;
        return this;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    @Override
    public <T> T get(String key) {
        if (this.data == null) {
            return null;
        }
        Object obj = this.getData().get(key);
        return (T)obj;
    }

    @Override
    public Session put(String key, Object obj) {
        Map<String, Object> data = this.getData();
        if (obj == null) {
            data.remove(key);
        } else {
            data.put(key, obj);
        }
        return this;
    }

    @Override
    public <T> T remove(String key) {
        if (this.data == null) {
            return null;
        }
        Object obj = this.getData().remove(key);
        return (T)obj;
    }

    @Override
    public Map<String, Object> data() {
        return this.getData();
    }

    @Override
    public long lastAccessed() {
        return this.lastAccessed;
    }

    @Override
    public void setAccessed() {
        this.lastAccessed = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        SessionImpl sessionImpl = this;
        synchronized (sessionImpl) {
            this.destroyed = true;
            this.data = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public boolean isRegenerated() {
        return this.renewed;
    }

    @Override
    public String oldId() {
        return this.oldId;
    }

    public int version() {
        return this.version;
    }

    public void incrementVersion() {
        this.buffer = this.writeDataToBuffer();
        int crc = SessionImpl.crc16(this.buffer, 0, this.buffer.length());
        if (this.crc != crc) {
            ++this.version;
        }
        this.crc = crc;
    }

    @Override
    public void writeToBuffer(Buffer buff) {
        byte[] bytes = this.id.getBytes(UTF8);
        buff.appendInt(bytes.length).appendBytes(bytes);
        buff.appendLong(this.timeout);
        buff.appendLong(this.lastAccessed);
        buff.appendInt(this.version);
        Buffer dataBuf = this.buffer != null ? this.buffer : this.writeDataToBuffer();
        buff.appendBuffer(dataBuf);
    }

    @Override
    public int readFromBuffer(int pos, Buffer buffer) {
        int len = buffer.getInt(pos);
        byte[] bytes = buffer.getBytes(pos += 4, pos + len);
        this.id = new String(bytes, UTF8);
        this.timeout = buffer.getLong(pos += len);
        this.lastAccessed = buffer.getLong(pos += 8);
        this.version = buffer.getInt(pos += 8);
        int start = pos += 4;
        int end = pos = this.readDataFromBuffer(pos, buffer);
        this.crc = SessionImpl.crc16(buffer, start, end);
        return pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getData() {
        if (this.data == null) {
            SessionImpl sessionImpl = this;
            synchronized (sessionImpl) {
                if (this.data == null) {
                    this.data = new ConcurrentHashMap<String, Object>();
                    if (this.destroyed) {
                        this.regenerateId();
                        this.destroyed = false;
                    }
                }
            }
        }
        return this.data;
    }

    private Buffer writeDataToBuffer() {
        try {
            Buffer buffer = Buffer.buffer();
            if (this.data == null || this.data.size() == 0) {
                buffer.appendInt(0);
            } else {
                buffer.appendInt(this.data.size());
                for (Map.Entry<String, Object> entry : this.data.entrySet()) {
                    byte[] bytes;
                    String key = entry.getKey();
                    byte[] keyBytes = key.getBytes(UTF8);
                    buffer.appendInt(keyBytes.length).appendBytes(keyBytes);
                    Object val = entry.getValue();
                    if (val instanceof Long) {
                        buffer.appendByte((byte)1).appendLong((Long)val);
                        continue;
                    }
                    if (val instanceof Integer) {
                        buffer.appendByte((byte)2).appendInt((Integer)val);
                        continue;
                    }
                    if (val instanceof Short) {
                        buffer.appendByte((byte)3).appendShort((Short)val);
                        continue;
                    }
                    if (val instanceof Byte) {
                        buffer.appendByte((byte)4).appendByte((Byte)val);
                        continue;
                    }
                    if (val instanceof Double) {
                        buffer.appendByte((byte)5).appendDouble((Double)val);
                        continue;
                    }
                    if (val instanceof Float) {
                        buffer.appendByte((byte)6).appendFloat(((Float)val).floatValue());
                        continue;
                    }
                    if (val instanceof Character) {
                        buffer.appendByte((byte)7).appendShort((short)((Character)val).charValue());
                        continue;
                    }
                    if (val instanceof Boolean) {
                        buffer.appendByte((byte)8).appendByte((byte)((Boolean)val != false ? 1 : 0));
                        continue;
                    }
                    if (val instanceof String) {
                        bytes = ((String)val).getBytes(UTF8);
                        buffer.appendByte((byte)9).appendInt(bytes.length).appendBytes(bytes);
                        continue;
                    }
                    if (val instanceof Buffer) {
                        Buffer buff = (Buffer)val;
                        buffer.appendByte((byte)10).appendInt(buff.length()).appendBuffer(buff);
                        continue;
                    }
                    if (val instanceof byte[]) {
                        bytes = (byte[])val;
                        buffer.appendByte((byte)11).appendInt(bytes.length).appendBytes(bytes);
                        continue;
                    }
                    if (val instanceof Serializable) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(baos));
                        oos.writeObject(val);
                        oos.flush();
                        byte[] bytes2 = baos.toByteArray();
                        buffer.appendByte((byte)12).appendInt(bytes2.length).appendBytes(bytes2);
                        continue;
                    }
                    if (val instanceof ClusterSerializable) {
                        buffer.appendByte((byte)13);
                        String className = val.getClass().getName();
                        byte[] classNameBytes = className.getBytes(UTF8);
                        buffer.appendInt(classNameBytes.length).appendBytes(classNameBytes);
                        ((ClusterSerializable)val).writeToBuffer(buffer);
                        continue;
                    }
                    if (val == null) continue;
                    throw new IllegalStateException("Invalid type for data in session: " + val.getClass());
                }
            }
            return buffer;
        }
        catch (IOException e) {
            throw new VertxException(e);
        }
    }

    private int readDataFromBuffer(int pos, Buffer buffer) {
        try {
            int entries = buffer.getInt(pos);
            pos += 4;
            if (entries != 0) {
                this.data = new ConcurrentHashMap<String, Object>(entries);
                for (int i = 0; i < entries; ++i) {
                    Object val;
                    int keylen = buffer.getInt(pos);
                    byte[] keyBytes = buffer.getBytes(pos += 4, pos + keylen);
                    pos += keylen;
                    String key = new String(keyBytes, UTF8);
                    byte type = buffer.getByte(pos++);
                    switch (type) {
                        case 1: {
                            val = buffer.getLong(pos);
                            pos += 8;
                            break;
                        }
                        case 2: {
                            val = buffer.getInt(pos);
                            pos += 4;
                            break;
                        }
                        case 3: {
                            val = buffer.getShort(pos);
                            pos += 2;
                            break;
                        }
                        case 4: {
                            val = buffer.getByte(pos);
                            ++pos;
                            break;
                        }
                        case 6: {
                            val = Float.valueOf(buffer.getFloat(pos));
                            pos += 4;
                            break;
                        }
                        case 5: {
                            val = buffer.getDouble(pos);
                            pos += 8;
                            break;
                        }
                        case 7: {
                            short s = buffer.getShort(pos);
                            pos += 2;
                            val = Character.valueOf((char)s);
                            break;
                        }
                        case 8: {
                            byte b = buffer.getByte(pos);
                            ++pos;
                            val = b == 1;
                            break;
                        }
                        case 9: {
                            int len = buffer.getInt(pos);
                            byte[] bytes = buffer.getBytes(pos += 4, pos + len);
                            val = new String(bytes, UTF8);
                            pos += len;
                            break;
                        }
                        case 10: {
                            int len = buffer.getInt(pos);
                            byte[] bytes = buffer.getBytes(pos += 4, pos + len);
                            val = Buffer.buffer(bytes);
                            pos += len;
                            break;
                        }
                        case 11: {
                            int len = buffer.getInt(pos);
                            val = buffer.getBytes(pos += 4, pos + len);
                            pos += len;
                            break;
                        }
                        case 12: {
                            int len = buffer.getInt(pos);
                            byte[] bytes = buffer.getBytes(pos += 4, pos + len);
                            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(bais));
                            val = ois.readObject();
                            pos += len;
                            break;
                        }
                        case 13: {
                            int classNameLen = buffer.getInt(pos);
                            byte[] classNameBytes = buffer.getBytes(pos += 4, pos + classNameLen);
                            pos += classNameLen;
                            String className = new String(classNameBytes, UTF8);
                            Class<?> clazz = Utils.getClassLoader().loadClass(className);
                            ClusterSerializable obj = (ClusterSerializable)clazz.newInstance();
                            pos = obj.readFromBuffer(pos, buffer);
                            val = obj;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Invalid serialized type: " + type);
                        }
                    }
                    this.data.put(key, val);
                }
            }
            return pos;
        }
        catch (Exception e) {
            throw new VertxException(e);
        }
    }

    private static String generateId(PRNG rng, int length) {
        byte[] bytes = new byte[length];
        rng.nextBytes(bytes);
        char[] hex = new char[length * 2];
        for (int j = 0; j < length; ++j) {
            int v = bytes[j] & 0xFF;
            hex[j * 2] = HEX[v >>> 4];
            hex[j * 2 + 1] = HEX[v & 0xF];
        }
        return new String(hex);
    }

    private static int crc16(Buffer data, int start, int end) {
        int crc = 0;
        for (int i = start; i < end; ++i) {
            crc = crc >>> 8 ^ CRC16_TABLE[(crc ^ data.getByte(i)) & 0xFF];
        }
        return crc;
    }
}

