/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container.version;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import javax.websocket.Session;
import org.atmosphere.cache.BroadcastMessage;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSR356WebSocket
extends WebSocket {
    private final Logger logger = LoggerFactory.getLogger(JSR356WebSocket.class);
    private final Session session;
    private final Semaphore semaphore = new Semaphore(1, true);
    private final int writeTimeout;
    private final AtomicBoolean closed = new AtomicBoolean();

    public JSR356WebSocket(Session session, AtmosphereConfig config) {
        super(config);
        this.session = session;
        this.writeTimeout = config.getInitParameter("org.atmosphere.websocket.writeTimeout", 60000);
        session.getAsyncRemote().setSendTimeout((long)this.writeTimeout);
    }

    @Override
    public boolean isOpen() {
        return this.session.isOpen() && !this.closed.get();
    }

    @Override
    public WebSocket write(String s) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Socket closed {}");
        }
        boolean acquired = false;
        try {
            acquired = this.semaphore.tryAcquire(this.writeTimeout, TimeUnit.MILLISECONDS);
            if (!acquired) {
                throw new IOException("Socket closed");
            }
            this.session.getAsyncRemote().sendText(s, (SendHandler)new WriteResult(this.resource(), s));
        }
        catch (Throwable e) {
            if (IOException.class.isAssignableFrom(e.getClass())) {
                throw (IOException)IOException.class.cast(e);
            }
            this.handleError(e, acquired);
        }
        return this;
    }

    @Override
    public WebSocket write(byte[] data, int offset, int length) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Socket closed {}");
        }
        boolean acquired = false;
        try {
            acquired = this.semaphore.tryAcquire(this.writeTimeout, TimeUnit.MILLISECONDS);
            if (!acquired) {
                throw new IOException("Socket closed");
            }
            ByteBuffer b = ByteBuffer.wrap(data, offset, length);
            this.session.getAsyncRemote().sendBinary(b, (SendHandler)new WriteResult(this.resource(), b.array()));
        }
        catch (Throwable e) {
            if (IOException.class.isAssignableFrom(e.getClass())) {
                throw (IOException)IOException.class.cast(e);
            }
            this.handleError(e, acquired);
        }
        return this;
    }

    private void handleError(Throwable e, boolean acquired) throws IOException {
        if (acquired) {
            this.semaphore.release();
        }
        if (e instanceof NullPointerException) {
            this.patchGlassFish((NullPointerException)e);
            return;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException("Unexpected error while writing to socket", e);
    }

    void patchGlassFish(NullPointerException e) {
        this.logger.trace("", e);
        WebSocketProcessorFactory.getDefault().getWebSocketProcessor(this.config().framework()).close(this, 1002);
    }

    @Override
    public void close() {
        if (!this.session.isOpen() || this.closed.getAndSet(true)) {
            return;
        }
        this.logger.trace("WebSocket.close() for AtmosphereResource {}", (Object)(this.resource() != null ? this.resource().uuid() : "null"));
        try {
            this.session.close();
        }
        catch (Exception e) {
            this.logger.trace("", e);
        }
    }

    private final class WriteResult
    implements SendHandler {
        private final AtmosphereResource r;
        private final Object message;

        private WriteResult(AtmosphereResource r, Object message) {
            this.r = r;
            this.message = message;
        }

        public void onResult(SendResult result) {
            JSR356WebSocket.this.semaphore.release();
            if (!result.isOK() || result.getException() != null) {
                JSR356WebSocket.this.logger.trace("WebSocket {} failed to write {}", this.r, this.message);
                if (this.r != null) {
                    Broadcaster b = this.r.getBroadcaster();
                    b.getBroadcasterConfig().getBroadcasterCache().addToCache(b.getID(), this.r.uuid(), new BroadcastMessage(this.message));
                }
            }
        }
    }
}

