/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.annotation.HandlesTypes;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.container.GlassFishServ30WebSocketSupport;
import org.atmosphere.container.JSR356AsyncSupport;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereFrameworkInitializer;
import org.atmosphere.cpr.DefaultAsyncSupportResolver;
import org.atmosphere.cpr.SessionSupport;
import org.atmosphere.util.IOUtils;
import org.atmosphere.util.Utils;

@HandlesTypes(value={})
public class ContainerInitializer
implements ServletContainerInitializer {
    @Override
    public void onStartup(Set<Class<?>> classes, ServletContext c) throws ServletException {
        c.log("Initializing AtmosphereFramework");
        for (Map.Entry<String, ? extends ServletRegistration> reg : c.getServletRegistrations().entrySet()) {
            String disableSwitchValue = reg.getValue().getInitParameter("org.atmosphere.cpr.AtmosphereInitializer.disabled");
            if (Boolean.parseBoolean(disableSwitchValue)) {
                c.log("Container managed initialization disabled for servlet: " + reg.getValue().getName());
                continue;
            }
            if (c.getAttribute(reg.getKey()) != null || !IOUtils.isAtmosphere(reg.getValue().getClassName())) continue;
            final AtmosphereFramework framework = AtmosphereFrameworkInitializer.newAtmosphereFramework(c, false, true);
            DefaultAsyncSupportResolver resolver = new DefaultAsyncSupportResolver(framework.getAtmosphereConfig());
            List<Class<? extends AsyncSupport>> l = resolver.detectWebSocketPresent(false, true);
            int size = c.getServerInfo().toLowerCase().contains("weblogic") ? 1 : 0;
            String s = reg.getValue().getInitParameter("org.atmosphere.cpr.asyncSupport");
            boolean force = c.getServerInfo().toLowerCase().contains("glassfish");
            if (s != null && s.equals(JSR356AsyncSupport.class.getName())) {
                force = true;
            } else if (s != null) {
                force = false;
            }
            if (force || l.size() == size && resolver.testClassExists("javax.websocket.Endpoint")) {
                try {
                    framework.setAsyncSupport(new JSR356AsyncSupport(framework.getAtmosphereConfig(), c));
                }
                catch (IllegalStateException ex) {
                    if (c.getServerInfo().toLowerCase().contains("glassfish")) {
                        framework.setAsyncSupport(new GlassFishServ30WebSocketSupport(framework.getAtmosphereConfig(), c));
                        framework.initializationError(null);
                    }
                    framework.initializationError(ex);
                }
            }
            try {
                c.addListener(new ServletRequestListener(){

                    @Override
                    public void requestDestroyed(ServletRequestEvent sre) {
                    }

                    @Override
                    public void requestInitialized(ServletRequestEvent sre) {
                        HttpServletRequest r = (HttpServletRequest)HttpServletRequest.class.cast(sre.getServletRequest());
                        AtmosphereConfig config = framework.getAtmosphereConfig();
                        if (config.isSupportSession() && Utils.webSocketEnabled(r)) {
                            r.getSession(config.getInitParameter("org.atmosphere.cpr.sessionCreate", true));
                        }
                    }
                });
            }
            catch (Throwable t) {
                c.log("AtmosphereFramework : Unable to install WebSocket Session Creator", t);
            }
            try {
                boolean sessionSupport;
                s = c.getInitParameter("org.atmosphere.cpr.sessionSupport");
                if (s != null && (sessionSupport = Boolean.valueOf(s).booleanValue()) && c.getMajorVersion() > 2) {
                    c.addListener(SessionSupport.class);
                    c.log("AtmosphereFramework : Installed " + SessionSupport.class);
                }
            }
            catch (Throwable t) {
                c.log("AtmosphereFramework : SessionSupport error. Make sure you also define {} as a listener in web.xml, see https://github.com/Atmosphere/atmosphere/wiki/Enabling-HttpSession-Support", t);
            }
            c.setAttribute(reg.getKey(), framework);
        }
    }
}

