/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vertx;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketFrame;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxWebSocket
extends WebSocket {
    private static final Logger logger = LoggerFactory.getLogger(VertxWebSocket.class);
    private final AtomicBoolean isOpen = new AtomicBoolean(true);
    private final ServerWebSocket webSocket;

    public VertxWebSocket(AtmosphereConfig config, ServerWebSocket webSocket) {
        super(config);
        this.webSocket = webSocket;
    }

    @Override
    public WebSocket write(String data) throws IOException {
        logger.trace("WebSocket.write()");
        this.webSocket.writeFrame(WebSocketFrame.textFrame(data, true));
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    @Override
    public WebSocket write(byte[] data, int offset, int length) throws IOException {
        Buffer buf = Buffer.buffer().appendBytes(data, offset, length);
        this.webSocket.writeFrame(WebSocketFrame.binaryFrame(buf, true));
        return this;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen.get();
    }

    @Override
    public void close() {
        if (!this.isOpen()) {
            this.isOpen.set(false);
            this.webSocket.close();
        }
    }
}

