/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.impl.management;

import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.vertx.java.core.impl.management.EventBusMXBeanImpl;
import org.vertx.java.core.impl.management.ThreadPoolMXBeanImpl;
import org.vertx.java.core.impl.management.VertxManagementException;
import org.vertx.java.core.net.impl.ServerID;

public class ManagementRegistry {
    private static final boolean MANAGEMENT_ENABLED = Boolean.getBoolean("vertx.management.jmx");
    private static final String DOMAIN = "org.vertx";
    private static final MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();

    public static void registerEventBus(ServerID serverID) {
        if (!MANAGEMENT_ENABLED) {
            return;
        }
        try {
            ObjectName eventBusName = ObjectName.getInstance(DOMAIN, "Name", "EventBus");
            if (!platformMBeanServer.isRegistered(eventBusName)) {
                EventBusMXBeanImpl eventBusMXBean = new EventBusMXBeanImpl(serverID.host, serverID.port);
                platformMBeanServer.registerMBean(eventBusMXBean, eventBusName);
            }
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            throw new VertxManagementException(e);
        }
    }

    public static void registerThreadPool(String name, ExecutorService service) {
        if (!MANAGEMENT_ENABLED) {
            return;
        }
        try {
            ThreadPoolExecutor exec = (ThreadPoolExecutor)service;
            Hashtable<String, String> table = new Hashtable<String, String>();
            table.put("type", "ThreadPool");
            table.put("name", name);
            ObjectName poolName = ObjectName.getInstance(DOMAIN, table);
            if (!platformMBeanServer.isRegistered(poolName)) {
                ThreadPoolMXBeanImpl eventBusMXBean = new ThreadPoolMXBeanImpl(exec);
                platformMBeanServer.registerMBean(eventBusMXBean, poolName);
            }
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            throw new VertxManagementException(e);
        }
    }
}

