/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.platform.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Queue;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.AsyncResultHandler;
import org.vertx.java.core.Future;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.file.impl.ClasspathPathResolver;
import org.vertx.java.core.file.impl.ModuleFileSystemPathResolver;
import org.vertx.java.core.file.impl.PathResolver;
import org.vertx.java.core.impl.CountingCompletionHandler;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.impl.DefaultVertx;
import org.vertx.java.core.impl.DeploymentHandle;
import org.vertx.java.core.impl.OrderedExecutorFactory;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.json.DecodeException;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.spi.cluster.ClusterManager;
import org.vertx.java.platform.PlatformManagerException;
import org.vertx.java.platform.Verticle;
import org.vertx.java.platform.VerticleFactory;
import org.vertx.java.platform.impl.DefaultContainer;
import org.vertx.java.platform.impl.Deployment;
import org.vertx.java.platform.impl.FatJarStarter;
import org.vertx.java.platform.impl.HAManager;
import org.vertx.java.platform.impl.ModuleClassLoader;
import org.vertx.java.platform.impl.ModuleFields;
import org.vertx.java.platform.impl.ModuleIdentifier;
import org.vertx.java.platform.impl.ModuleReference;
import org.vertx.java.platform.impl.ModuleReloader;
import org.vertx.java.platform.impl.PlatformManagerInternal;
import org.vertx.java.platform.impl.Redeployer;
import org.vertx.java.platform.impl.VerticleHolder;
import org.vertx.java.platform.impl.WrappedVertx;
import org.vertx.java.platform.impl.resolver.BintrayRepoResolver;
import org.vertx.java.platform.impl.resolver.MavenLocalRepoResolver;
import org.vertx.java.platform.impl.resolver.MavenRepoResolver;
import org.vertx.java.platform.impl.resolver.OldRepoResolver;
import org.vertx.java.platform.impl.resolver.RepoResolver;

public class DefaultPlatformManager
implements PlatformManagerInternal,
ModuleReloader {
    private static final Logger log = LoggerFactory.getLogger(DefaultPlatformManager.class);
    private static final int BUFFER_SIZE = 4096;
    private static final String MODS_DIR_PROP_NAME = "vertx.mods";
    private static final char COLON = ':';
    private static final String LANG_IMPLS_SYS_PROP_ROOT = "vertx.langs.";
    private static final String LANG_PROPS_FILE_NAME = "langs.properties";
    private static final String DEFAULT_LANG_PROPS_FILE_NAME = "default-langs.properties";
    private static final String REPOS_FILE_NAME = "repos.txt";
    private static final String DEFAULT_REPOS_FILE_NAME = "default-repos.txt";
    private static final String LOCAL_MODS_DIR = "mods";
    private static final String SYS_MODS_DIR = "sys-mods";
    private static final String VERTX_HOME_SYS_PROP = "vertx.home";
    private static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final String MODULE_NAME_SYS_PROP = System.getProperty("vertx.modulename");
    private static final String CLASSPATH_FILE = "vertx_classpath.txt";
    private static final String SERIALISE_BLOCKING_PROP_NAME = "vertx.serialiseBlockingActions";
    private static final String MODULE_LINK_FILE = "module.link";
    private static final String MOD_JSON_FILE = "mod.json";
    private final VertxInternal vertx;
    protected final Map<String, Deployment> deployments = new ConcurrentHashMap<String, Deployment>();
    private File modRoot;
    private File systemModRoot;
    private String vertxHomeDir;
    private final ConcurrentMap<String, ModuleReference> moduleRefs = new ConcurrentHashMap<String, ModuleReference>();
    private Redeployer redeployer;
    private final Map<String, LanguageImplInfo> languageImpls = new ConcurrentHashMap<String, LanguageImplInfo>();
    private final Map<String, String> extensionMappings = new ConcurrentHashMap<String, String>();
    private String defaultLanguageImplName;
    private final List<RepoResolver> repos = new ArrayList<RepoResolver>();
    private Handler<Void> exitHandler;
    private ClassLoader platformClassLoader;
    private boolean disableMavenLocal;
    protected final ClusterManager clusterManager;
    protected HAManager haManager;
    private boolean stopped;
    private final Queue<String> tempDeployments = new ConcurrentLinkedQueue<String>();
    private Executor backgroundExec;

    protected DefaultPlatformManager() {
        DefaultVertx v = new DefaultVertx();
        this.vertx = new WrappedVertx((VertxInternal)v);
        this.clusterManager = v.clusterManager();
        this.init();
    }

    protected DefaultPlatformManager(String hostname) {
        DefaultVertx v = new DefaultVertx(hostname);
        this.vertx = new WrappedVertx((VertxInternal)v);
        this.clusterManager = v.clusterManager();
        this.init();
    }

    protected DefaultPlatformManager(int port, String hostname) {
        this.vertx = this.createVertxSynchronously(port, hostname);
        this.clusterManager = this.vertx.clusterManager();
        this.init();
    }

    protected DefaultPlatformManager(int port, String hostname, int quorumSize, String haGroup) {
        this.vertx = this.createVertxSynchronously(port, hostname);
        this.clusterManager = this.vertx.clusterManager();
        this.init();
        this.haManager = new HAManager(this.vertx, this, this.clusterManager, quorumSize, haGroup);
    }

    private DefaultPlatformManager(DefaultVertx vertx) {
        this.vertx = new WrappedVertx((VertxInternal)vertx);
        this.clusterManager = vertx.clusterManager();
        this.init();
    }

    private VertxInternal createVertxSynchronously(int port, String hostname) {
        final AtomicReference resultReference = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultVertx v = new DefaultVertx(port, hostname, (Handler)new Handler<AsyncResult<Vertx>>(){

            public void handle(AsyncResult<Vertx> result) {
                resultReference.set(result);
                latch.countDown();
            }
        });
        try {
            if (!latch.await(10L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Unable to start Vertx within 10 seconds");
            }
            AsyncResult result = (AsyncResult)resultReference.get();
            if (result.failed()) {
                throw new IllegalStateException("Unable to start Vertx", result.cause());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        return new WrappedVertx((VertxInternal)v);
    }

    private void init() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        this.platformClassLoader = tccl != null ? tccl : this.getClass().getClassLoader();
        this.backgroundExec = System.getProperty(SERIALISE_BLOCKING_PROP_NAME, "false").equalsIgnoreCase("true") ? new OrderedExecutorFactory((Executor)this.vertx.getBackgroundPool()).getExecutor() : this.vertx.getBackgroundPool();
        String modDir = System.getProperty(MODS_DIR_PROP_NAME);
        this.modRoot = modDir != null && !modDir.trim().equals("") ? new File(modDir) : new File(LOCAL_MODS_DIR);
        this.vertxHomeDir = System.getProperty(VERTX_HOME_SYS_PROP);
        this.systemModRoot = this.vertxHomeDir == null || modDir != null ? this.modRoot : new File(this.vertxHomeDir, SYS_MODS_DIR);
        this.redeployer = new Redeployer(this.vertx, this);
        this.disableMavenLocal = System.getenv("VERTX_DISABLE_MAVENLOCAL") != null;
        this.loadLanguageMappings();
        this.loadRepos();
    }

    @Override
    public void registerExitHandler(Handler<Void> handler) {
        this.exitHandler = handler;
    }

    @Override
    public void deployVerticle(String main, JsonObject config, URL[] classpath, int instances, String includes, Handler<AsyncResult<String>> doneHandler) {
        this.deployVerticle(false, false, main, config, classpath, instances, includes, doneHandler);
    }

    @Override
    public void deployWorkerVerticle(boolean multiThreaded, String main, JsonObject config, URL[] classpath, int instances, String includes, Handler<AsyncResult<String>> doneHandler) {
        this.deployVerticle(true, multiThreaded, main, config, classpath, instances, includes, doneHandler);
    }

    @Override
    public void deployModule(String moduleName, JsonObject config, int instances, Handler<AsyncResult<String>> doneHandler) {
        this.deployModuleInternal(moduleName, config, instances, false, doneHandler);
    }

    @Override
    public synchronized void deployModule(String moduleName, JsonObject config, int instances, boolean ha, Handler<AsyncResult<String>> doneHandler) {
        if (ha && this.haManager != null) {
            File currentModDir = this.getDeploymentModDir();
            if (currentModDir != null) {
                throw new IllegalStateException("Only top-level modules can be deployed with HA");
            }
            this.haManager.deployModule(moduleName, config, instances, doneHandler);
        } else {
            this.deployModule(moduleName, config, instances, doneHandler);
        }
    }

    @Override
    public void deployModuleFromClasspath(final String moduleName, final JsonObject config, final int instances, final URL[] classpath, Handler<AsyncResult<String>> doneHandler) {
        final Handler<AsyncResult<String>> wrapped = this.wrapDoneHandler(doneHandler);
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                ModuleIdentifier modID = new ModuleIdentifier(moduleName);
                DefaultPlatformManager.this.deployModuleFromCP(null, modID, config, instances, classpath, (Handler<AsyncResult<String>>)wrapped);
            }
        }, wrapped);
    }

    @Override
    public synchronized void undeploy(final String deploymentID, final Handler<AsyncResult<Void>> doneHandler) {
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                if (deploymentID == null) {
                    throw new NullPointerException("deploymentID cannot be null");
                }
                Deployment dep = DefaultPlatformManager.this.deployments.get(deploymentID);
                if (dep == null) {
                    throw new PlatformManagerException("There is no deployment with id " + deploymentID);
                }
                DefaultPlatformManager.this.doUndeploy(dep, (Handler<AsyncResult<Void>>)doneHandler);
            }
        }, this.wrapDoneHandler(doneHandler));
    }

    @Override
    public synchronized void undeployAll(Handler<AsyncResult<Void>> doneHandler) {
        ArrayList<String> parents = new ArrayList<String>();
        for (Map.Entry<String, Deployment> entry : this.deployments.entrySet()) {
            if (entry.getValue().parentDeploymentName != null) continue;
            parents.add(entry.getKey());
        }
        final CountingCompletionHandler count = new CountingCompletionHandler(this.vertx, parents.size());
        count.setHandler(doneHandler);
        for (String name : parents) {
            this.undeploy(name, new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> res) {
                    if (res.failed()) {
                        count.failed(res.cause());
                    } else {
                        count.complete();
                    }
                }
            });
        }
    }

    @Override
    public Map<String, Integer> listInstances() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Map.Entry<String, Deployment> entry : this.deployments.entrySet()) {
            map.put(entry.getKey(), entry.getValue().verticles.size());
        }
        return map;
    }

    @Override
    public void installModule(final String moduleName, final Handler<AsyncResult<Void>> doneHandler) {
        Handler<AsyncResult<Void>> wrapped = this.wrapDoneHandler(doneHandler);
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                ModuleIdentifier modID = new ModuleIdentifier(moduleName);
                DefaultPlatformManager.this.doInstallMod(modID);
                doneHandler.handle((Object)new DefaultFutureResult((Object)null));
            }
        }, wrapped);
    }

    @Override
    public void uninstallModule(final String moduleName, final Handler<AsyncResult<Void>> doneHandler) {
        Handler<AsyncResult<Void>> wrapped = this.wrapDoneHandler(doneHandler);
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                ModuleIdentifier modID = new ModuleIdentifier(moduleName);
                File modDir = new File(DefaultPlatformManager.this.modRoot, modID.toString());
                if (!modDir.exists()) {
                    throw new PlatformManagerException("Cannot find module to uninstall: " + moduleName);
                }
                DefaultPlatformManager.this.vertx.fileSystem().deleteSync(modDir.getAbsolutePath(), true);
                doneHandler.handle((Object)new DefaultFutureResult((Object)null));
            }
        }, wrapped);
    }

    @Override
    public void pullInDependencies(final String moduleName, final Handler<AsyncResult<Void>> doneHandler) {
        Handler<AsyncResult<Void>> wrapped = this.wrapDoneHandler(doneHandler);
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                ModuleIdentifier modID = new ModuleIdentifier(moduleName);
                DefaultPlatformManager.this.doPullInDependencies(DefaultPlatformManager.this.modRoot, modID);
                doneHandler.handle((Object)new DefaultFutureResult((Object)null));
            }
        }, wrapped);
    }

    @Override
    public void makeFatJar(final String moduleName, final String directory, final Handler<AsyncResult<Void>> doneHandler) {
        Handler<AsyncResult<Void>> wrapped = this.wrapDoneHandler(doneHandler);
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                ModuleIdentifier modID = new ModuleIdentifier(moduleName);
                DefaultPlatformManager.this.doMakeFatJar(DefaultPlatformManager.this.modRoot, modID, directory);
                doneHandler.handle((Object)new DefaultFutureResult((Object)null));
            }
        }, wrapped);
    }

    @Override
    public void createModuleLink(final String moduleName, final Handler<AsyncResult<Void>> doneHandler) {
        Handler<AsyncResult<Void>> wrapped = this.wrapDoneHandler(doneHandler);
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                ModuleIdentifier modID = new ModuleIdentifier(moduleName);
                DefaultPlatformManager.this.doCreateModuleLink(DefaultPlatformManager.this.modRoot, modID);
                doneHandler.handle((Object)new DefaultFutureResult((Object)null));
            }
        }, wrapped);
    }

    @Override
    public void reloadModules(Set<Deployment> deps) {
        final HashSet<Deployment> parents = new HashSet<Deployment>();
        for (Deployment dep : deps) {
            parents.add(this.getTopMostDeployment(dep));
        }
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                for (final Deployment deployment : parents) {
                    if (DefaultPlatformManager.this.deployments.containsKey(deployment.name)) {
                        DefaultPlatformManager.this.doUndeploy(deployment, (Handler<AsyncResult<Void>>)((Handler)new Handler<AsyncResult<Void>>(){

                            public void handle(AsyncResult<Void> res) {
                                if (res.succeeded()) {
                                    DefaultPlatformManager.this.doRedeploy(deployment);
                                } else {
                                    log.error((Object)"Failed to undeploy", res.cause());
                                }
                            }
                        }));
                        continue;
                    }
                    DefaultPlatformManager.this.doRedeploy(deployment);
                }
            }
        }, null);
    }

    @Override
    public Vertx vertx() {
        return this.vertx;
    }

    @Override
    public void deployModuleFromZip(final String zipFileName, final JsonObject config, final int instances, Handler<AsyncResult<String>> doneHandler) {
        final Handler<AsyncResult<String>> wrapped = this.wrapDoneHandler(doneHandler);
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                if (zipFileName == null) {
                    throw new NullPointerException("zipFileName cannot be null");
                }
                ModuleZipInfo info = new ModuleZipInfo(false, zipFileName);
                ModuleIdentifier modID = new ModuleIdentifier("__vertx~" + UUID.randomUUID().toString() + "~__vertx");
                File modRoot = new File(TEMP_DIR + FILE_SEP + "vertx-zip-mods");
                File tempDir = new File(modRoot, modID.toString());
                tempDir.mkdirs();
                DefaultPlatformManager.unzipModuleData(tempDir, info, false);
                DefaultPlatformManager.this.deployModuleFromFileSystem(modRoot, null, modID, config, instances, null, false, (Handler<AsyncResult<String>>)wrapped);
                DefaultPlatformManager.this.addTmpDeployment(tempDir.getAbsolutePath());
            }
        }, wrapped);
    }

    @Override
    public void exit() {
        ClusterManager mgr = this.vertx.clusterManager();
        if (mgr != null) {
            this.vertx.clusterManager().leave();
        }
        if (this.exitHandler != null) {
            this.exitHandler.handle(null);
        }
    }

    @Override
    public JsonObject config() {
        VerticleHolder holder = this.getVerticleHolder();
        return holder == null ? null : holder.config;
    }

    @Override
    public Logger logger() {
        VerticleHolder holder = this.getVerticleHolder();
        return holder == null ? null : holder.logger;
    }

    @Override
    public Map<String, Deployment> deployments() {
        return new HashMap<String, Deployment>(this.deployments);
    }

    @Override
    public void deployModuleInternal(final String moduleName, final JsonObject config, final int instances, final boolean ha, Handler<AsyncResult<String>> doneHandler) {
        final File currentModDir = this.getDeploymentModDir();
        final Handler<AsyncResult<String>> wrapped = this.wrapDoneHandler(doneHandler);
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                ModuleIdentifier modID = new ModuleIdentifier(moduleName);
                DefaultPlatformManager.this.deployModuleFromFileSystem(DefaultPlatformManager.this.modRoot, null, modID, config, instances, currentModDir, ha, (Handler<AsyncResult<String>>)wrapped);
            }
        }, wrapped);
    }

    private void doRedeploy(final Deployment deployment) {
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                if (deployment.modDir != null) {
                    DefaultPlatformManager.this.deployModuleFromFileSystem(deployment.modDir.getParentFile(), deployment.name, deployment.modID, deployment.config, deployment.instances, null, deployment.ha, (Handler<AsyncResult<String>>)null);
                } else {
                    DefaultPlatformManager.this.deployModuleFromCP(deployment.name, deployment.modID, deployment.config, deployment.instances, deployment.classpath, (Handler<AsyncResult<String>>)null);
                }
            }
        }, null);
    }

    private <T> void runInBackground(final Runnable runnable, final Handler<AsyncResult<T>> doneHandler) {
        final DefaultContext context = this.vertx.getOrCreateContext();
        this.backgroundExec.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    DefaultPlatformManager.this.vertx.setContext(context);
                    runnable.run();
                }
                catch (Throwable t) {
                    if (doneHandler != null) {
                        doneHandler.handle((Object)new DefaultFutureResult(t));
                    } else {
                        log.error((Object)"Failed to run task", t);
                    }
                }
                finally {
                    DefaultPlatformManager.this.vertx.setContext(null);
                }
            }
        });
    }

    private void deployVerticle(final boolean worker, final boolean multiThreaded, final String main, final JsonObject config, URL[] classpath, final int instances, final String includes, Handler<AsyncResult<String>> doneHandler) {
        URL[] cp;
        final File currentModDir = this.getDeploymentModDir();
        if (classpath == null) {
            cp = this.getClasspath();
            if (cp == null) {
                throw new IllegalStateException("Cannot find parent classpath. Perhaps you are deploying the verticle from a non Vert.x thread?");
            }
        } else {
            cp = classpath;
        }
        final Handler<AsyncResult<String>> wrapped = this.wrapDoneHandler(doneHandler);
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                DefaultPlatformManager.this.doDeployVerticle(worker, multiThreaded, main, config, cp, instances, currentModDir, includes, (Handler<AsyncResult<String>>)wrapped);
            }
        }, wrapped);
    }

    private String getDeploymentName() {
        VerticleHolder holder = this.getVerticleHolder();
        return holder == null ? null : holder.deployment.name;
    }

    private URL[] getClasspath() {
        VerticleHolder holder = this.getVerticleHolder();
        return holder == null ? null : holder.deployment.classpath;
    }

    private File getDeploymentModDir() {
        VerticleHolder holder = this.getVerticleHolder();
        return holder == null ? null : holder.deployment.modDir;
    }

    private void doPullInDependencies(File modRoot, ModuleIdentifier modID) {
        String deploys;
        File modDir = new File(modRoot, modID.toString());
        if (!modDir.exists()) {
            throw new PlatformManagerException("Cannot find module");
        }
        JsonObject conf = this.loadModuleConfig(this.createModJSONFile(modDir), modID);
        if (conf == null) {
            throw new PlatformManagerException("Module " + modID + " does not contain a mod.json");
        }
        ModuleFields fields = new ModuleFields(conf);
        ArrayList<String> mods = new ArrayList<String>();
        String includes = fields.getIncludes();
        if (includes != null) {
            mods.addAll(Arrays.asList(DefaultPlatformManager.parseIncludeString(includes)));
        }
        if ((deploys = fields.getDeploys()) != null) {
            mods.addAll(Arrays.asList(DefaultPlatformManager.parseIncludeString(deploys)));
        }
        if (!mods.isEmpty()) {
            File internalModsDir = new File(modDir, LOCAL_MODS_DIR);
            if (!internalModsDir.exists() && !internalModsDir.mkdir()) {
                throw new PlatformManagerException("Failed to create directory " + internalModsDir);
            }
            for (String modName : mods) {
                File internalModDir = new File(internalModsDir, modName);
                if (internalModDir.exists()) continue;
                ModuleIdentifier theModID = new ModuleIdentifier(modName);
                ModuleZipInfo zipInfo = this.getModule(theModID);
                if (zipInfo.filename == null) continue;
                if (!internalModDir.mkdir()) {
                    throw new PlatformManagerException("Failed to create directory " + internalModDir);
                }
                DefaultPlatformManager.unzipModuleData(internalModDir, zipInfo, true);
                log.info((Object)("Module " + modName + " successfully installed in mods dir of " + modName));
                this.doPullInDependencies(internalModsDir, theModID);
            }
        }
    }

    private String locateJar(String name, ClassLoader cl) {
        if (cl instanceof URLClassLoader) {
            URLClassLoader urlc = (URLClassLoader)cl;
            for (URL url : urlc.getURLs()) {
                String correctedFileName;
                String surl = url.toString();
                if (!surl.contains("/" + name)) continue;
                String filename = url.getFile();
                if (filename == null || "".equals(filename)) {
                    throw new IllegalStateException("Vert.x jars not available as file urls");
                }
                try {
                    correctedFileName = new File(URLDecoder.decode(filename, "UTF-8")).getPath();
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
                return correctedFileName;
            }
        }
        if (cl.getParent() != null) {
            return this.locateJar(name, cl.getParent());
        }
        return null;
    }

    private String[] locateJars(ClassLoader cl, String ... names) {
        ArrayList<String> ljars = new ArrayList<String>();
        for (int i = 0; i < names.length; ++i) {
            String jar = this.locateJar(names[i], cl);
            if (jar == null) continue;
            ljars.add(jar);
        }
        return ljars.toArray(new String[ljars.size()]);
    }

    private void doMakeFatJar(File modRoot, ModuleIdentifier modID, String directory) {
        File modDir = new File(modRoot, modID.toString());
        if (!modDir.exists()) {
            throw new PlatformManagerException("Cannot find module");
        }
        String[] jars = this.locateJars(this.platformClassLoader, "vertx-core", "vertx-platform", "vertx-hazelcast", "netty-all", "jackson-core", "jackson-annotations", "jackson-databind", "hazelcast");
        if (directory == null) {
            directory = ".";
        }
        String tdir = DefaultPlatformManager.generateTmpFileName();
        File vertxHome = new File(tdir);
        File libDir = new File(vertxHome, "lib");
        this.vertx.fileSystem().mkdirSync(libDir.getAbsolutePath(), true);
        File modHome = new File(vertxHome, LOCAL_MODS_DIR);
        File modDest = new File(modHome, modID.toString());
        this.vertx.fileSystem().mkdirSync(modDest.getAbsolutePath(), true);
        this.vertx.fileSystem().copySync(modDir.getAbsolutePath(), modDest.getAbsolutePath(), true);
        for (String jar : jars) {
            Path path = Paths.get(jar, new String[0]);
            String jarName = path.getFileName().toString();
            this.vertx.fileSystem().copySync(jar, new File(libDir, jarName).getAbsolutePath());
            if (!jarName.startsWith("vertx-platform")) continue;
            File fatClassDir = new File(vertxHome, "org/vertx/java/platform/impl");
            this.vertx.fileSystem().mkdirSync(fatClassDir.getAbsolutePath(), true);
            try {
                ZipEntry ze;
                FileInputStream fin = new FileInputStream(jar);
                BufferedInputStream bin = new BufferedInputStream(fin);
                ZipInputStream zin = new ZipInputStream(bin);
                while ((ze = zin.getNextEntry()) != null) {
                    int len;
                    String entryName = ze.getName();
                    if (!entryName.contains("FatJarStarter")) continue;
                    entryName = entryName.substring(entryName.lastIndexOf(47) + 1);
                    File fatClassFile = new File(fatClassDir, entryName);
                    FileOutputStream out = new FileOutputStream(fatClassFile);
                    byte[] buffer = new byte[4096];
                    while ((len = zin.read(buffer)) != -1) {
                        ((OutputStream)out).write(buffer, 0, len);
                    }
                    ((OutputStream)out).close();
                }
            }
            catch (Exception e) {
                throw new PlatformManagerException(e);
            }
        }
        String manifest = "Manifest-Version: 1.0\nMain-Class: " + FatJarStarter.class.getName() + "\n" + "Vertx-Module-ID: " + modID.toString() + "\n";
        this.vertx.fileSystem().mkdirSync(new File(vertxHome, "META-INF").getAbsolutePath());
        this.vertx.fileSystem().writeFileSync(new File(vertxHome, "META-INF/MANIFEST.MF").getAbsolutePath(), new Buffer(manifest));
        File jarName = new File(directory, modID.getName() + "-" + modID.getVersion() + "-fat.jar");
        this.zipDir(jarName.getPath(), vertxHome.getAbsolutePath());
        this.vertx.fileSystem().deleteSync(vertxHome.getAbsolutePath(), true);
    }

    private void doCreateModuleLink(File modRoot, ModuleIdentifier modID) {
        File cpFile = new File(CLASSPATH_FILE);
        if (!cpFile.exists()) {
            throw new PlatformManagerException("Must create a vertx_classpath.txt file first before creating a module link");
        }
        File modDir = new File(modRoot, modID.toString());
        if (modDir.exists()) {
            throw new PlatformManagerException("Module directory " + modDir + " already exists.");
        }
        if (!modDir.mkdirs()) {
            throw new PlatformManagerException("Failed to make directory " + modDir);
        }
        try {
            File currentDir = new File(".").getCanonicalFile();
            this.vertx.fileSystem().writeFileSync(modDir.getPath() + "/" + MODULE_LINK_FILE, new Buffer(currentDir.getCanonicalPath() + "\n"));
        }
        catch (IOException e) {
            throw new PlatformManagerException(e);
        }
    }

    private void zipDir(String zipFile, String dirToZip) {
        File dir = new File(dirToZip);
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));){
            this.addDirToZip(dir, dir, out);
        }
        catch (Exception e) {
            throw new PlatformManagerException("Failed to unzip module", e);
        }
    }

    void addDirToZip(File topDir, File dir, ZipOutputStream out) throws Exception {
        Path top = Paths.get(topDir.getAbsolutePath(), new String[0]);
        File[] files = dir.listFiles();
        byte[] buffer = new byte[4096];
        for (int i = 0; i < files.length; ++i) {
            Path entry = Paths.get(files[i].getAbsolutePath(), new String[0]);
            Path rel = top.relativize(entry);
            String entryName = rel.toString();
            if (files[i].isDirectory()) {
                entryName = entryName + FILE_SEP;
            }
            if (!files[i].isDirectory()) {
                out.putNextEntry(new ZipEntry(entryName.replace('\\', '/')));
                try (FileInputStream in = new FileInputStream(files[i]);){
                    int bytesRead;
                    while ((bytesRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, bytesRead);
                    }
                }
                out.closeEntry();
            }
            if (!files[i].isDirectory()) continue;
            this.addDirToZip(topDir, files[i], out);
        }
    }

    private <T> Handler<AsyncResult<T>> wrapDoneHandler(final Handler<AsyncResult<T>> doneHandler) {
        if (doneHandler == null) {
            return new AsyncResultHandler<T>(){

                public void handle(AsyncResult<T> res) {
                    if (res.failed()) {
                        DefaultPlatformManager.this.vertx.reportException(res.cause());
                    }
                }
            };
        }
        final DefaultContext context = this.vertx.getContext();
        return new AsyncResultHandler<T>(){

            public void handle(final AsyncResult<T> res) {
                if (context == null) {
                    doneHandler.handle(res);
                } else {
                    context.execute(new Runnable(){

                        @Override
                        public void run() {
                            doneHandler.handle((Object)res);
                        }
                    });
                }
            }
        };
    }

    private ModuleIdentifier getEnclosingModID() {
        Deployment dep;
        VerticleHolder holder = this.getVerticleHolder();
        Deployment deployment = dep = holder == null ? null : holder.deployment;
        while (dep != null) {
            if (dep.modID != null) {
                return dep.modID;
            }
            String parentDepName = dep.parentDeploymentName;
            if (parentDepName != null) {
                dep = this.deployments.get(parentDepName);
                continue;
            }
            return ModuleIdentifier.createInternalModIDForVerticle(dep.name);
        }
        return null;
    }

    private Deployment getTopMostDeployment(Deployment dep) {
        String parentDep;
        Deployment topMostMod = dep;
        while ((parentDep = dep.parentDeploymentName) != null) {
            dep = this.deployments.get(parentDep);
            if (dep == null) {
                throw new IllegalStateException("Cannot find deployment " + parentDep);
            }
            if (dep.modID == null) continue;
            topMostMod = dep;
        }
        return topMostMod;
    }

    private ModuleReference getModuleReference(String moduleKey, URL[] urls, boolean loadFromModuleFirst) {
        ModuleReference prev;
        ModuleReference mr = (ModuleReference)this.moduleRefs.get(moduleKey);
        if (mr == null && (prev = this.moduleRefs.putIfAbsent(moduleKey, mr = new ModuleReference(this, moduleKey, new ModuleClassLoader(moduleKey, this.platformClassLoader, urls, loadFromModuleFirst), false))) != null) {
            mr = prev;
        }
        return mr;
    }

    private void doDeployVerticle(boolean worker, boolean multiThreaded, String main, JsonObject config, URL[] urls, int instances, File currentModDir, String includes, Handler<AsyncResult<String>> doneHandler) {
        ModuleReference parentRef;
        boolean loadFromModuleFirst;
        String moduleKey;
        DefaultPlatformManager.checkWorkerContext();
        if (main == null) {
            throw new NullPointerException("main cannot be null");
        }
        if (urls == null) {
            throw new IllegalStateException("deployment classpath for deploy is null");
        }
        String depName = DefaultPlatformManager.genDepName();
        ModuleIdentifier enclosingModName = this.getEnclosingModID();
        if (enclosingModName == null) {
            moduleKey = ModuleIdentifier.createInternalModIDForVerticle(depName).toString();
            loadFromModuleFirst = false;
        } else {
            moduleKey = enclosingModName.toString() + "#" + main;
            VerticleHolder holder = this.getVerticleHolder();
            Deployment dep = holder.deployment;
            loadFromModuleFirst = dep.loadFromModuleFirst;
        }
        ModuleReference mr = this.getModuleReference(moduleKey, urls, loadFromModuleFirst);
        if (enclosingModName != null && mr.mcl.addReference(parentRef = (ModuleReference)this.moduleRefs.get(enclosingModName.toString()))) {
            parentRef.incRef();
        }
        if (includes != null) {
            this.loadIncludedModules(this.modRoot, currentModDir, mr, includes);
        }
        this.doDeploy(depName, false, worker, multiThreaded, null, main, null, config, urls, null, instances, currentModDir, mr, this.modRoot, false, loadFromModuleFirst, doneHandler);
    }

    private static void checkWorkerContext() {
        Thread t = Thread.currentThread();
        if (!t.getName().startsWith("vert.x-worker-thread")) {
            throw new IllegalStateException("Not a worker thread");
        }
    }

    private InputStream findLangsFile() {
        InputStream is = this.platformClassLoader.getResourceAsStream(LANG_PROPS_FILE_NAME);
        if (is == null) {
            is = this.platformClassLoader.getResourceAsStream(DEFAULT_LANG_PROPS_FILE_NAME);
        }
        return is;
    }

    private void loadLanguageMappings() {
        this.languageImpls.put("java", new LanguageImplInfo(null, "org.vertx.java.platform.impl.java.JavaVerticleFactory"));
        this.extensionMappings.put("java", "java");
        this.extensionMappings.put("class", "java");
        this.defaultLanguageImplName = "java";
        try (InputStream is = this.findLangsFile();){
            if (is != null) {
                Properties props = new Properties();
                props.load(new BufferedInputStream(is));
                this.loadLanguageMappings(props);
            }
        }
        catch (IOException e) {
            throw new PlatformManagerException(e);
        }
        Properties sysProps = new Properties();
        Set<String> propertyNames = System.getProperties().stringPropertyNames();
        for (String propertyName : propertyNames) {
            if (!propertyName.startsWith(LANG_IMPLS_SYS_PROP_ROOT)) continue;
            String lang = propertyName.substring(LANG_IMPLS_SYS_PROP_ROOT.length());
            String value = System.getProperty(propertyName);
            sysProps.put(lang, value);
        }
        this.loadLanguageMappings(sysProps);
    }

    private void loadLanguageMappings(Properties props) {
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            String propName = (String)en.nextElement();
            String propVal = props.getProperty(propName);
            if (propName.startsWith(".")) {
                if (propName.equals(".")) {
                    this.defaultLanguageImplName = propVal;
                    continue;
                }
                propName = propName.substring(1);
                this.extensionMappings.put(propName, propVal);
                continue;
            }
            LanguageImplInfo langImpl = this.parseLangImplInfo(propVal);
            this.languageImpls.put(propName, langImpl);
            this.extensionMappings.put(propName, propName);
        }
    }

    private LanguageImplInfo parseLangImplInfo(String line) {
        int colonIndex = line.lastIndexOf(58);
        if (colonIndex == -1) {
            throw new PlatformManagerException("Language mapping: " + line + " does not specify an implementing module");
        }
        String moduleName = line.substring(0, colonIndex);
        String factoryName = line.substring(colonIndex + 1);
        return new LanguageImplInfo(moduleName, factoryName);
    }

    private File locateModule(File modRoot, File currentModDir, ModuleIdentifier modID) {
        File modDir;
        if (currentModDir != null && (modDir = new File(new File(currentModDir, LOCAL_MODS_DIR), modID.toString())).exists()) {
            return modDir;
        }
        modDir = new File(modRoot, modID.toString());
        if (modDir.exists()) {
            return modDir;
        }
        modDir = new File(this.modRoot, modID.toString());
        if (modDir.exists()) {
            return modDir;
        }
        if (!this.systemModRoot.equals(modRoot) && (modDir = new File(this.systemModRoot, modID.toString())).exists()) {
            return modDir;
        }
        return null;
    }

    private void deployModuleFromModJson(JsonObject modJSON, String depName, ModuleIdentifier modID, JsonObject config, int instances, File modDir, File currentModDir, List<URL> moduleClasspath, File modRoot, boolean ha, final Handler<AsyncResult<String>> doneHandler) {
        List<URL> includedCPList;
        ModuleReference parentRef;
        ModuleIdentifier enclosingModID;
        ModuleFields fields = new ModuleFields(modJSON);
        String main = fields.getMain();
        if (main == null) {
            throw new PlatformManagerException("Runnable module " + modID + " mod.json must contain a \"main\" field");
        }
        boolean worker = fields.isWorker();
        boolean multiThreaded = fields.isMultiThreaded();
        if (multiThreaded && !worker) {
            throw new PlatformManagerException("Multi-threaded modules must be workers");
        }
        boolean preserveCwd = fields.isPreserveCurrentWorkingDirectory();
        File modDirToUse = preserveCwd ? currentModDir : modDir;
        ModuleReference mr = (ModuleReference)this.moduleRefs.get(modID.toString());
        if (mr == null) {
            boolean res = fields.isResident();
            mr = new ModuleReference(this, modID.toString(), new ModuleClassLoader(modID.toString(), this.platformClassLoader, moduleClasspath.toArray(new URL[moduleClasspath.size()]), fields.isLoadFromModuleFirst()), res);
            ModuleReference prev = this.moduleRefs.putIfAbsent(modID.toString(), mr);
            if (prev != null) {
                mr = prev;
            }
        }
        if ((enclosingModID = this.getEnclosingModID()) != null && mr.mcl.addReference(parentRef = (ModuleReference)this.moduleRefs.get(enclosingModID.toString()))) {
            parentRef.incRef();
        }
        String includes = fields.getIncludes();
        URL[] includedCP = null;
        if (includes != null && !(includedCPList = this.loadIncludedModules(modRoot, modDir, mr, includes)).isEmpty()) {
            includedCP = includedCPList.toArray(new URL[includedCPList.size()]);
        }
        final boolean autoRedeploy = fields.isAutoRedeploy();
        this.doDeploy(depName, autoRedeploy, worker, multiThreaded, fields.getLangMod(), main, modID, config, moduleClasspath.toArray(new URL[moduleClasspath.size()]), includedCP, instances, modDirToUse, mr, modRoot, ha, fields.isLoadFromModuleFirst(), new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> res) {
                String deploymentID;
                if (res.succeeded() && (deploymentID = (String)res.result()) != null && autoRedeploy) {
                    DefaultPlatformManager.this.redeployer.moduleDeployed(DefaultPlatformManager.this.deployments.get(deploymentID));
                }
                if (doneHandler != null) {
                    doneHandler.handle(res);
                } else if (res.failed()) {
                    log.error((Object)"Failed to deploy", res.cause());
                }
            }
        });
    }

    private JsonObject loadModJSONFromClasspath(ModuleIdentifier modID, ClassLoader cl) {
        URL url = cl.getResource(MOD_JSON_FILE);
        if (url == null) {
            return null;
        }
        return this.loadModJSONFromURL(modID, url);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject loadModJSONFromURL(ModuleIdentifier modID, URL url) {
        try {
            try (Scanner scanner = new Scanner(url.openStream(), "UTF-8").useDelimiter("\\A");){
                String conf = scanner.next();
                JsonObject jsonObject = new JsonObject(conf);
                return jsonObject;
            }
            catch (NoSuchElementException e) {
                throw new PlatformManagerException("Module " + modID + " contains an empty mod.json file");
            }
            catch (DecodeException e) {
                throw new PlatformManagerException("Module " + modID + " mod.json contains invalid json");
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    private void deployModuleFromCP(String depName, ModuleIdentifier modID, JsonObject config, int instances, URL[] classpath, Handler<AsyncResult<String>> doneHandler) {
        DefaultPlatformManager.checkWorkerContext();
        JsonObject modJSON = this.loadModJSONFromClasspath(modID, new URLClassLoader(classpath, this.platformClassLoader));
        if (modJSON == null) {
            throw new PlatformManagerException("Failed to find mod.json on classpath");
        }
        ArrayList<URL> cpList = new ArrayList<URL>(Arrays.asList(classpath));
        this.deployModuleFromModJson(modJSON, depName, modID, config, instances, null, null, cpList, this.modRoot, false, doneHandler);
    }

    private ModuleInfo loadModuleInfo(File modDir, ModuleIdentifier modID) {
        File modJSONFile;
        File targetModDir;
        JsonObject modJSON;
        ArrayList<URL> cpList;
        block37: {
            cpList = new ArrayList<URL>();
            modJSON = null;
            targetModDir = modDir;
            File linkFile = new File(modDir, MODULE_LINK_FILE);
            if (linkFile.exists()) {
                try (Scanner scanner = new Scanner(linkFile, "UTF-8").useDelimiter("\\A");){
                    String path = scanner.next().trim();
                    File cpFile = new File(path, CLASSPATH_FILE);
                    if (!cpFile.exists()) {
                        throw new PlatformManagerException("Module link file: " + linkFile + " points to path without vertx_classpath.txt");
                    }
                    cpList = new ArrayList();
                    try (Scanner scanner2 = new Scanner(cpFile, "UTF-8");){
                        while (scanner2.hasNextLine()) {
                            File[] files;
                            String entry = scanner2.nextLine().trim();
                            if (entry.startsWith("#") || entry.equals("")) continue;
                            File fentry = new File(entry);
                            if (!fentry.isAbsolute()) {
                                fentry = new File(path, entry);
                            }
                            URL url = fentry.toURI().toURL();
                            cpList.add(url);
                            if (!fentry.exists() || !fentry.isDirectory()) continue;
                            for (File file : files = fentry.listFiles()) {
                                String fPath = file.getCanonicalPath();
                                if (!fPath.endsWith(".jar") && !fPath.endsWith(".zip")) continue;
                                cpList.add(file.getCanonicalFile().toURI().toURL());
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new PlatformManagerException(e);
                    }
                    ModJSONClassLoader cl = new ModJSONClassLoader(cpList.toArray(new URL[cpList.size()]), this.platformClassLoader);
                    URL url = ((ClassLoader)cl).getResource(MOD_JSON_FILE);
                    if (url != null) {
                        Path p = ClasspathPathResolver.urlToPath((URL)url);
                        Path parent = p.getParent();
                        modDir = parent.toFile();
                        modJSON = this.loadModJSONFromURL(modID, url);
                        break block37;
                    }
                    throw new PlatformManagerException("Cannot find mod.json");
                }
                catch (Exception e) {
                    throw new PlatformManagerException(e);
                }
            }
        }
        if (modJSON == null && (modJSONFile = this.createModJSONFile(targetModDir)).exists()) {
            modJSON = this.loadModuleConfig(modJSONFile, modID);
        }
        cpList.addAll(this.getModuleLibClasspath(targetModDir));
        if (modJSON == null) {
            throw new PlatformManagerException("Module directory " + modDir + " contains no mod.json nor module.link file");
        }
        cpList.addAll(this.getModuleLibClasspath(modDir));
        return new ModuleInfo(modJSON, cpList, modDir);
    }

    private void deployModuleFromFileSystem(File modRoot, String depName, ModuleIdentifier modID, JsonObject config, int instances, File currentModDir, boolean ha, Handler<AsyncResult<String>> doneHandler) {
        DefaultPlatformManager.checkWorkerContext();
        File modDir = this.locateModule(modRoot, currentModDir, modID);
        if (modDir != null) {
            ModuleInfo info = this.loadModuleInfo(modDir, modID);
            this.deployModuleFromModJson(info.modJSON, depName, modID, config, instances, info.modDir, currentModDir, info.cp, modRoot, ha, doneHandler);
        } else {
            JsonObject modJSON = modID.toString().equals(MODULE_NAME_SYS_PROP) ? this.loadModJSONFromClasspath(modID, this.platformClassLoader) : null;
            if (modJSON != null) {
                this.deployModuleFromModJson(modJSON, depName, modID, config, instances, modDir, currentModDir, new ArrayList<URL>(), modRoot, ha, doneHandler);
            } else {
                this.doInstallMod(modID);
                this.deployModuleFromFileSystem(modRoot, depName, modID, config, instances, currentModDir, ha, doneHandler);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject loadModuleConfig(File modJSON, ModuleIdentifier modID) {
        try (Scanner scanner = new Scanner(modJSON, "UTF-8").useDelimiter("\\A");){
            String conf = scanner.next();
            JsonObject jsonObject = new JsonObject(conf);
            return jsonObject;
        }
        catch (FileNotFoundException e) {
            throw new PlatformManagerException("Module " + modID + " does not contain a mod.json file");
        }
        catch (NoSuchElementException e) {
            throw new PlatformManagerException("Module " + modID + " contains an empty mod.json file");
        }
        catch (DecodeException e) {
            throw new PlatformManagerException("Module " + modID + " mod.json contains invalid json");
        }
    }

    private List<URL> loadIncludedModules(File modRoot, File currentModuleDir, ModuleReference mr, String includesString) {
        HashSet<String> included = new HashSet<String>();
        ArrayList<URL> includedCP = new ArrayList<URL>();
        included.add(mr.moduleKey);
        this.doLoadIncludedModules(modRoot, currentModuleDir, mr, includesString, included, includedCP);
        return includedCP;
    }

    private void doLoadIncludedModules(File modRoot, File currentModuleDir, ModuleReference mr, String includesString, Set<String> included, List<URL> includedCP) {
        DefaultPlatformManager.checkWorkerContext();
        for (String moduleName : DefaultPlatformManager.parseIncludeString(includesString)) {
            ModuleIdentifier modID = new ModuleIdentifier(moduleName);
            if (included.contains(modID.toString())) {
                log.warn((Object)("Module " + modID + " is included more than once in chain of includes"));
                continue;
            }
            included.add(modID.toString());
            ModuleReference includedMr = (ModuleReference)this.moduleRefs.get(moduleName);
            if (includedMr == null) {
                String includes;
                File modDir = this.locateModule(modRoot, currentModuleDir, modID);
                if (modDir == null) {
                    this.doInstallMod(modID);
                }
                modDir = this.locateModule(modRoot, currentModuleDir, modID);
                ModuleInfo info = this.loadModuleInfo(modDir, modID);
                ModuleFields fields = new ModuleFields(info.modJSON);
                includedCP.addAll(info.cp);
                boolean res = fields.isResident();
                includedMr = new ModuleReference(this, moduleName, new ModuleClassLoader(modID.toString(), this.platformClassLoader, info.cp.toArray(new URL[info.cp.size()]), fields.isLoadFromModuleFirst()), res);
                ModuleReference prev = this.moduleRefs.putIfAbsent(moduleName, includedMr);
                if (prev != null) {
                    includedMr = prev;
                }
                if ((includes = fields.getIncludes()) != null) {
                    this.doLoadIncludedModules(modRoot, modDir, includedMr, includes, included, includedCP);
                }
            }
            if (!mr.mcl.addReference(includedMr)) continue;
            includedMr.incRef();
        }
    }

    private List<URL> getModuleLibClasspath(File modDir) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            if (modDir.exists()) {
                urls.add(modDir.toURI().toURL());
                File libDir = new File(modDir, "lib");
                if (libDir.exists()) {
                    File[] jars;
                    for (File jar : jars = libDir.listFiles()) {
                        URL jarURL = jar.toURI().toURL();
                        urls.add(jarURL);
                    }
                }
            }
            return urls;
        }
        catch (MalformedURLException e) {
            throw new PlatformManagerException(e);
        }
    }

    private static String[] parseIncludeString(String sincludes) {
        if ("".equals(sincludes = sincludes.trim())) {
            log.error((Object)"Empty include string");
            return null;
        }
        String[] arr = sincludes.split(",");
        if (arr != null) {
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = arr[i].trim();
            }
        }
        return arr;
    }

    private InputStream findReposFile() {
        InputStream is = this.platformClassLoader.getResourceAsStream(REPOS_FILE_NAME);
        if (is == null) {
            is = this.platformClassLoader.getResourceAsStream(DEFAULT_REPOS_FILE_NAME);
        }
        return is;
    }

    private void loadRepos() {
        try (InputStream is = this.findReposFile();){
            if (is != null) {
                String line;
                BufferedReader rdr = new BufferedReader(new InputStreamReader(is));
                block23: while ((line = rdr.readLine()) != null) {
                    RepoResolver resolver;
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    int colonPos = line.indexOf(58);
                    if (colonPos == -1 || colonPos == line.length() - 1) {
                        throw new IllegalArgumentException("Invalid repo: " + line);
                    }
                    String type = line.substring(0, colonPos);
                    String repoID = line.substring(colonPos + 1);
                    switch (type) {
                        case "mavenLocal": {
                            if (this.disableMavenLocal) continue block23;
                            resolver = new MavenLocalRepoResolver(repoID);
                            break;
                        }
                        case "maven": {
                            resolver = new MavenRepoResolver((Vertx)this.vertx, repoID);
                            break;
                        }
                        case "bintray": {
                            resolver = new BintrayRepoResolver((Vertx)this.vertx, repoID);
                            break;
                        }
                        case "old": {
                            resolver = new OldRepoResolver((Vertx)this.vertx, repoID);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown repo type: " + type);
                        }
                    }
                    this.repos.add(resolver);
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"Failed to load repos file ", (Throwable)e);
        }
    }

    private void doInstallMod(ModuleIdentifier modID) {
        DefaultPlatformManager.checkWorkerContext();
        if (this.repos.isEmpty()) {
            throw new PlatformManagerException("No repositories configured!");
        }
        if (this.locateModule(this.modRoot, null, modID) != null) {
            throw new PlatformManagerException("Module is already installed");
        }
        ModuleZipInfo info = this.getModule(modID);
        this.unzipModule(modID, info, true);
    }

    private ModuleZipInfo getModule(ModuleIdentifier modID) {
        String fileName = DefaultPlatformManager.generateTmpFileName() + ".zip";
        for (RepoResolver resolver : this.repos) {
            if (!resolver.getModule(fileName, modID)) continue;
            return new ModuleZipInfo(resolver.isOldStyle(), fileName);
        }
        throw new PlatformManagerException("Module " + modID + " not found in any repositories");
    }

    private static String generateTmpFileName() {
        return TEMP_DIR + FILE_SEP + "vertx-" + UUID.randomUUID().toString();
    }

    static File unzipIntoTmpDir(ModuleZipInfo zipInfo, boolean deleteZip) {
        String tdir = DefaultPlatformManager.generateTmpFileName();
        File tdest = new File(tdir);
        if (!tdest.mkdir()) {
            throw new PlatformManagerException("Failed to create directory " + tdest);
        }
        DefaultPlatformManager.unzipModuleData(tdest, zipInfo, deleteZip);
        return tdest;
    }

    private void checkCreateModDirs() {
        this.checkCreateRoot(this.modRoot);
        this.checkCreateRoot(this.systemModRoot);
    }

    private void checkCreateRoot(File modRoot) {
        if (!modRoot.exists()) {
            String smodRoot;
            try {
                smodRoot = modRoot.getCanonicalPath();
            }
            catch (IOException e) {
                throw new PlatformManagerException(e);
            }
            this.vertx.fileSystem().mkdirSync(smodRoot, true);
        }
    }

    private File createModJSONFile(File modDir) {
        return new File(modDir, MOD_JSON_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzipModule(ModuleIdentifier modID, ModuleZipInfo zipInfo, boolean deleteZip) {
        String modName = modID.toString();
        String string = modName.intern();
        synchronized (string) {
            this.checkCreateModDirs();
            File fdest = new File(this.modRoot, modName);
            File sdest = new File(this.systemModRoot, modName);
            if (fdest.exists() || sdest.exists()) {
                log.warn((Object)("Module " + modID + " is already installed"));
                return;
            }
            File tdest = DefaultPlatformManager.unzipIntoTmpDir(zipInfo, deleteZip);
            JsonObject conf = this.loadModuleConfig(this.createModJSONFile(tdest), modID);
            ModuleFields fields = new ModuleFields(conf);
            boolean system = fields.isSystem();
            String moveFrom = tdest.getAbsolutePath();
            this.safeMove(moveFrom, system ? sdest.getAbsolutePath() : fdest.getAbsolutePath());
            log.info((Object)("Module " + modID + " successfully installed"));
        }
    }

    private void safeMove(String source, String dest) {
        try {
            this.vertx.fileSystem().moveSync(source, dest);
        }
        catch (Exception e) {
            try {
                this.vertx.fileSystem().copySync(source, dest, true);
                this.vertx.fileSystem().deleteSync(source, true);
            }
            catch (Exception e2) {
                throw new PlatformManagerException("Failed to copy module", e2);
            }
        }
    }

    private static String removeTopDir(String entry) {
        int pos = entry.indexOf(FILE_SEP);
        if (pos != -1) {
            entry = entry.substring(pos + 1);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void unzipModuleData(File directory, ModuleZipInfo zipinfo, boolean deleteZip) {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(zipinfo.filename));
             ZipInputStream zis = new ZipInputStream(new BufferedInputStream(is));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                String entryName = zipinfo.oldStyle ? DefaultPlatformManager.removeTopDir(entry.getName()) : entry.getName();
                if (entryName.isEmpty()) continue;
                if (entry.isDirectory()) {
                    if (new File(directory, entryName).mkdir()) continue;
                    throw new PlatformManagerException("Failed to create directory");
                }
                byte[] buff = new byte[4096];
                FilterOutputStream dest = null;
                try {
                    int count;
                    FileOutputStream fos = new FileOutputStream(new File(directory, entryName));
                    dest = new BufferedOutputStream(fos, 4096);
                    while ((count = zis.read(buff, 0, 4096)) != -1) {
                        ((BufferedOutputStream)dest).write(buff, 0, count);
                    }
                    ((BufferedOutputStream)dest).flush();
                }
                finally {
                    if (dest == null) continue;
                    dest.close();
                }
            }
            return;
        }
        catch (Exception e) {
            throw new PlatformManagerException("Failed to unzip module", e);
        }
        finally {
            if (deleteZip && !new File(zipinfo.filename).delete()) {
                log.error((Object)"Failed to delete zip");
            }
        }
    }

    private void setPathResolver(File modDir) {
        DefaultContext context = this.vertx.getContext();
        if (modDir != null) {
            Path pmodDir = Paths.get(modDir.getAbsolutePath(), new String[0]);
            context.setPathResolver((PathResolver)new ModuleFileSystemPathResolver(pmodDir));
        } else {
            context.setPathResolver((PathResolver)new ClasspathPathResolver());
        }
    }

    private static String genDepName() {
        return "deployment-" + UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDeploy(String depID, boolean autoRedeploy, boolean worker, boolean multiThreaded, String langMod, String theMain, final ModuleIdentifier modID, JsonObject config, URL[] urls, URL[] includedURLs, int instances, final File modDir, ModuleReference mr, File modRoot, boolean ha, boolean loadFromModuleFirst, Handler<AsyncResult<String>> dHandler) {
        VerticleFactory verticleFactory;
        String parentDeploymentName;
        String extension;
        String langImplName;
        int extensionMarker;
        String main;
        int prefixMarker;
        DefaultPlatformManager.checkWorkerContext();
        if (dHandler == null) {
            dHandler = new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> ar) {
                    if (ar.failed()) {
                        log.error((Object)"Failed to deploy", ar.cause());
                    }
                }
            };
        }
        Handler<AsyncResult<String>> doneHandler = dHandler;
        String deploymentID = depID != null ? depID : DefaultPlatformManager.genDepName();
        log.debug((Object)("Deploying name : " + deploymentID + " main: " + theMain + " instances: " + instances));
        LanguageImplInfo langImplInfo = null;
        if (langMod != null) {
            langImplInfo = this.parseLangImplInfo(langMod);
        }
        if ((prefixMarker = theMain.indexOf(58)) != -1) {
            String prefix = theMain.substring(0, prefixMarker);
            if (langImplInfo == null && (langImplInfo = this.languageImpls.get(prefix)) == null) {
                throw new IllegalStateException("No language implementation known for prefix " + prefix);
            }
            main = theMain.substring(prefixMarker + 1);
        } else {
            main = theMain;
        }
        if (langImplInfo == null && (extensionMarker = main.lastIndexOf(46)) != -1 && (langImplName = this.extensionMappings.get(extension = main.substring(extensionMarker + 1))) != null && (langImplInfo = this.languageImpls.get(langImplName)) == null) {
            throw new IllegalStateException("Extension mapping for " + extension + " specified as " + langImplName + ", but no language implementation known for that name");
        }
        if (langImplInfo == null && (langImplInfo = this.languageImpls.get(this.defaultLanguageImplName)) == null) {
            throw new IllegalStateException("Default language implementation is " + this.defaultLanguageImplName + " but no language implementation known for that name");
        }
        if (langImplInfo.moduleName != null && !langImplInfo.moduleName.isEmpty()) {
            this.loadIncludedModules(modRoot, modDir, mr, langImplInfo.moduleName);
        }
        if ((parentDeploymentName = this.getDeploymentName()) != null) {
            Deployment parentDeployment = this.deployments.get(parentDeploymentName);
            if (parentDeployment == null) {
                throw new PlatformManagerException("Parent has already been undeployed!");
            }
            parentDeployment.childDeployments.add(deploymentID);
        }
        ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(mr.mcl);
        try {
            verticleFactory = mr.getVerticleFactory(langImplInfo.factoryName, (Vertx)this.vertx, new DefaultContainer(this));
        }
        catch (Throwable t) {
            throw new PlatformManagerException("Failed to instantiate verticle factory", t);
        }
        final CountingCompletionHandler aggHandler = new CountingCompletionHandler(this.vertx, instances);
        aggHandler.setHandler((Handler)new Handler<AsyncResult<Void>>((Handler)doneHandler, deploymentID){
            final /* synthetic */ Handler val$doneHandler;
            final /* synthetic */ String val$deploymentID;
            {
                this.val$doneHandler = handler;
                this.val$deploymentID = string;
            }

            public void handle(AsyncResult<Void> res) {
                if (res.failed()) {
                    this.val$doneHandler.handle((Object)new DefaultFutureResult(res.cause()));
                } else {
                    this.val$doneHandler.handle((Object)new DefaultFutureResult((Object)this.val$deploymentID));
                }
            }
        });
        final Deployment deployment = new Deployment(deploymentID, main, modID, instances, config == null ? new JsonObject() : config.copy(), urls, includedURLs, modDir, parentDeploymentName, mr, autoRedeploy, ha, loadFromModuleFirst);
        mr.incRef();
        this.deployments.put(deploymentID, deployment);
        try {
            for (int i = 0; i < instances; ++i) {
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        Verticle verticle;
                        try {
                            verticle = verticleFactory.createVerticle(main);
                        }
                        catch (Throwable t) {
                            DefaultPlatformManager.this.handleDeployFailure(t, deployment, (CountingCompletionHandler<Void>)aggHandler);
                            return;
                        }
                        try {
                            DefaultPlatformManager.this.addVerticle(deployment, verticle, verticleFactory, modID, main);
                            DefaultPlatformManager.this.setPathResolver(modDir);
                            DefaultFutureResult vr = new DefaultFutureResult();
                            verticle.start((Future<Void>)vr);
                            vr.setHandler((Handler)new Handler<AsyncResult<Void>>(){

                                public void handle(AsyncResult<Void> ar) {
                                    if (ar.succeeded()) {
                                        aggHandler.complete();
                                    } else {
                                        DefaultPlatformManager.this.handleDeployFailure(ar.cause(), deployment, (CountingCompletionHandler<Void>)aggHandler);
                                    }
                                }
                            });
                        }
                        catch (Throwable t) {
                            DefaultPlatformManager.this.handleDeployFailure(t, deployment, (CountingCompletionHandler<Void>)aggHandler);
                        }
                    }
                };
                if (worker) {
                    this.vertx.startInBackground(runner, multiThreaded);
                    continue;
                }
                this.vertx.startOnEventLoop(runner);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTCCL);
        }
    }

    private void handleDeployFailure(final Throwable t, Deployment dep, final CountingCompletionHandler<Void> handler) {
        this.doUndeploy(dep, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> res) {
                if (res.failed()) {
                    DefaultPlatformManager.this.vertx.reportException(res.cause());
                }
                handler.failed(t);
            }
        });
    }

    private void addVerticle(Deployment deployment, Verticle verticle, VerticleFactory factory, ModuleIdentifier modID, String main) {
        String loggerName = modID + "-" + main + "-" + System.identityHashCode(verticle);
        Logger logger = LoggerFactory.getLogger((String)loggerName);
        DefaultContext context = this.vertx.getContext();
        VerticleHolder holder = new VerticleHolder(deployment, context, verticle, loggerName, logger, deployment.config, factory);
        deployment.verticles.add(holder);
        context.setDeploymentHandle((DeploymentHandle)holder);
    }

    private VerticleHolder getVerticleHolder() {
        DefaultContext context = this.vertx.getContext();
        if (context != null) {
            return (VerticleHolder)context.getDeploymentHandle();
        }
        return null;
    }

    private void doUndeploy(Deployment dep, Handler<AsyncResult<Void>> doneHandler) {
        CountingCompletionHandler count = new CountingCompletionHandler(this.vertx);
        this.doUndeploy(dep.name, (CountingCompletionHandler<Void>)count);
        count.setHandler(doneHandler);
    }

    private void doUndeploy(String name, final CountingCompletionHandler<Void> parentCount) {
        Deployment parent;
        if (name == null) {
            throw new NullPointerException("deployment id is null");
        }
        final Deployment deployment = this.deployments.remove(name);
        if (deployment == null) {
            parentCount.incRequired();
            parentCount.complete();
            return;
        }
        final CountingCompletionHandler count = new CountingCompletionHandler(this.vertx);
        parentCount.incRequired();
        for (String childDeployment : deployment.childDeployments) {
            this.doUndeploy(childDeployment, (CountingCompletionHandler<Void>)count);
        }
        if (!deployment.verticles.isEmpty()) {
            for (final VerticleHolder holder : deployment.verticles) {
                count.incRequired();
                holder.context.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            holder.verticle.stop();
                        }
                        catch (Throwable t) {
                            System.err.println("Failure in stop()");
                            t.printStackTrace();
                        }
                        LoggerFactory.removeLogger((String)holder.loggerName);
                        holder.context.runCloseHooks((Handler)new AsyncResultHandler<Void>(){

                            public void handle(AsyncResult<Void> asyncResult) {
                                holder.context.close();
                                DefaultPlatformManager.this.runInBackground(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (deployment.modID != null && deployment.autoRedeploy) {
                                            DefaultPlatformManager.this.redeployer.moduleUndeployed(deployment);
                                        }
                                        if (deployment.ha && DefaultPlatformManager.this.haManager != null) {
                                            DefaultPlatformManager.this.haManager.removeFromHA(deployment.name);
                                        }
                                        count.complete();
                                    }
                                }, (Handler)new Handler<AsyncResult<Void>>(){

                                    public void handle(AsyncResult<Void> res) {
                                        if (res.failed()) {
                                            count.failed(res.cause());
                                        } else {
                                            count.complete();
                                        }
                                    }
                                });
                            }
                        });
                    }
                });
            }
        }
        if (deployment.parentDeploymentName != null && (parent = this.deployments.get(deployment.parentDeploymentName)) != null) {
            parent.childDeployments.remove(name);
        }
        count.setHandler((Handler)new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> res) {
                deployment.moduleReference.decRef();
                if (res.failed()) {
                    parentCount.failed(res.cause());
                } else {
                    parentCount.complete();
                }
            }
        });
    }

    private void addTmpDeployment(String tmp) {
        this.tempDeployments.add(tmp);
    }

    private void deleteTmpDeployments() {
        String tmp;
        while ((tmp = this.tempDeployments.poll()) != null) {
            try {
                this.vertx.fileSystem().deleteSync(tmp, true);
            }
            catch (Throwable t) {
                log.error((Object)"Failed to delete temp deployment", t);
            }
        }
    }

    @Override
    public void stop() {
        if (this.stopped) {
            return;
        }
        if (this.haManager != null) {
            this.haManager.stop();
        }
        this.redeployer.close();
        this.deleteTmpDeployments();
        this.vertx.stop();
        this.stopped = true;
    }

    @Override
    public int checkNoModules() {
        int count = 0;
        for (Map.Entry entry : this.moduleRefs.entrySet()) {
            if (((ModuleReference)entry.getValue()).resident) continue;
            System.out.println("Module remains: " + (String)entry.getKey());
            ++count;
        }
        return count;
    }

    @Override
    public void removeModule(String moduleKey) {
        this.moduleRefs.remove(moduleKey);
    }

    private static class ModJSONClassLoader
    extends URLClassLoader {
        private final ClassLoader parent;

        private ModJSONClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
            this.parent = parent;
        }

        @Override
        public URL getResource(String name) {
            URL url = this.findResource(name);
            if (url == null) {
                url = super.getResource(name);
            }
            return url;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            ArrayList<URL> resources = new ArrayList<URL>(Collections.list(this.findResources(name)));
            if (this.parent != null) {
                resources.addAll(Collections.list(this.parent.getResources(name)));
            }
            return Collections.enumeration(resources);
        }
    }

    static final class ModuleZipInfo {
        final boolean oldStyle;
        final String filename;

        ModuleZipInfo(boolean oldStyle, String filename) {
            this.oldStyle = oldStyle;
            this.filename = filename;
        }
    }

    private static class LanguageImplInfo {
        final String moduleName;
        final String factoryName;

        private LanguageImplInfo(String moduleName, String factoryName) {
            this.moduleName = moduleName;
            this.factoryName = factoryName;
        }

        public String toString() {
            return (this.moduleName == null ? ":" : this.moduleName + ":") + this.factoryName;
        }
    }

    private static class ModuleInfo {
        final JsonObject modJSON;
        final List<URL> cp;
        final File modDir;

        private ModuleInfo(JsonObject modJSON, List<URL> cp, File modDir) {
            this.modJSON = modJSON;
            this.cp = cp;
            this.modDir = modDir;
        }
    }
}

