/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.file.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.file.AsyncFile;
import org.vertx.java.core.file.FileProps;
import org.vertx.java.core.file.FileSystem;
import org.vertx.java.core.file.FileSystemException;
import org.vertx.java.core.file.FileSystemProps;
import org.vertx.java.core.file.impl.DefaultAsyncFile;
import org.vertx.java.core.file.impl.DefaultFileProps;
import org.vertx.java.core.file.impl.DefaultFileSystemProps;
import org.vertx.java.core.file.impl.PathAdjuster;
import org.vertx.java.core.impl.BlockingAction;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class DefaultFileSystem
implements FileSystem {
    private static final Logger log = LoggerFactory.getLogger(DefaultFileSystem.class);
    protected final VertxInternal vertx;

    public DefaultFileSystem(VertxInternal vertx) {
        this.vertx = vertx;
    }

    @Override
    public FileSystem copy(String from, String to, Handler<AsyncResult<Void>> handler) {
        this.copyInternal(from, to, handler).run();
        return this;
    }

    @Override
    public FileSystem copySync(String from, String to) {
        this.copyInternal(from, to, null).action();
        return this;
    }

    @Override
    public FileSystem copy(String from, String to, boolean recursive, Handler<AsyncResult<Void>> handler) {
        this.copyInternal(from, to, recursive, handler).run();
        return this;
    }

    @Override
    public FileSystem copySync(String from, String to, boolean recursive) {
        this.copyInternal(from, to, recursive, null).action();
        return this;
    }

    @Override
    public FileSystem move(String from, String to, Handler<AsyncResult<Void>> handler) {
        this.moveInternal(from, to, handler).run();
        return this;
    }

    @Override
    public FileSystem moveSync(String from, String to) {
        this.moveInternal(from, to, null).action();
        return this;
    }

    @Override
    public FileSystem truncate(String path, long len, Handler<AsyncResult<Void>> handler) {
        this.truncateInternal(path, len, handler).run();
        return this;
    }

    @Override
    public FileSystem truncateSync(String path, long len) {
        this.truncateInternal(path, len, null).action();
        return this;
    }

    @Override
    public FileSystem chmod(String path, String perms, Handler<AsyncResult<Void>> handler) {
        this.chmodInternal(path, perms, handler).run();
        return this;
    }

    @Override
    public FileSystem chmodSync(String path, String perms) {
        this.chmodInternal(path, perms, null).action();
        return this;
    }

    @Override
    public FileSystem chmod(String path, String perms, String dirPerms, Handler<AsyncResult<Void>> handler) {
        this.chmodInternal(path, perms, dirPerms, handler).run();
        return this;
    }

    @Override
    public FileSystem chmodSync(String path, String perms, String dirPerms) {
        this.chmodInternal(path, perms, dirPerms, null).action();
        return this;
    }

    @Override
    public FileSystem chown(String path, String user, String group, Handler<AsyncResult<Void>> handler) {
        this.chownInternal(path, user, group, handler).run();
        return this;
    }

    @Override
    public FileSystem chownSync(String path, String user, String group) {
        this.chownInternal(path, user, group, null).action();
        return this;
    }

    @Override
    public FileSystem props(String path, Handler<AsyncResult<FileProps>> handler) {
        this.propsInternal(path, handler).run();
        return this;
    }

    @Override
    public FileProps propsSync(String path) {
        return this.propsInternal(path, null).action();
    }

    @Override
    public FileSystem lprops(String path, Handler<AsyncResult<FileProps>> handler) {
        this.lpropsInternal(path, handler).run();
        return this;
    }

    @Override
    public FileProps lpropsSync(String path) {
        return this.lpropsInternal(path, null).action();
    }

    @Override
    public FileSystem link(String link, String existing, Handler<AsyncResult<Void>> handler) {
        this.linkInternal(link, existing, handler).run();
        return this;
    }

    @Override
    public FileSystem linkSync(String link, String existing) {
        this.linkInternal(link, existing, null).action();
        return this;
    }

    @Override
    public FileSystem symlink(String link, String existing, Handler<AsyncResult<Void>> handler) {
        this.symlinkInternal(link, existing, handler).run();
        return this;
    }

    @Override
    public FileSystem symlinkSync(String link, String existing) {
        this.symlinkInternal(link, existing, null).action();
        return this;
    }

    @Override
    public FileSystem unlink(String link, Handler<AsyncResult<Void>> handler) {
        this.unlinkInternal(link, handler).run();
        return this;
    }

    @Override
    public FileSystem unlinkSync(String link) {
        this.unlinkInternal(link, null).action();
        return this;
    }

    @Override
    public FileSystem readSymlink(String link, Handler<AsyncResult<String>> handler) {
        this.readSymlinkInternal(link, handler).run();
        return this;
    }

    @Override
    public String readSymlinkSync(String link) {
        return this.readSymlinkInternal(link, null).action();
    }

    @Override
    public FileSystem delete(String path, Handler<AsyncResult<Void>> handler) {
        this.deleteInternal(path, handler).run();
        return this;
    }

    @Override
    public FileSystem deleteSync(String path) {
        this.deleteInternal(path, null).action();
        return this;
    }

    @Override
    public FileSystem delete(String path, boolean recursive, Handler<AsyncResult<Void>> handler) {
        this.deleteInternal(path, recursive, handler).run();
        return this;
    }

    @Override
    public FileSystem deleteSync(String path, boolean recursive) {
        this.deleteInternal(path, recursive, null).action();
        return this;
    }

    @Override
    public FileSystem mkdir(String path, Handler<AsyncResult<Void>> handler) {
        this.mkdirInternal(path, handler).run();
        return this;
    }

    @Override
    public FileSystem mkdirSync(String path) {
        this.mkdirInternal(path, null).action();
        return this;
    }

    @Override
    public FileSystem mkdir(String path, boolean createParents, Handler<AsyncResult<Void>> handler) {
        this.mkdirInternal(path, createParents, handler).run();
        return this;
    }

    @Override
    public FileSystem mkdirSync(String path, boolean createParents) {
        this.mkdirInternal(path, createParents, null).action();
        return this;
    }

    @Override
    public FileSystem mkdir(String path, String perms, Handler<AsyncResult<Void>> handler) {
        this.mkdirInternal(path, perms, handler).run();
        return this;
    }

    @Override
    public FileSystem mkdirSync(String path, String perms) {
        this.mkdirInternal(path, perms, null).action();
        return this;
    }

    @Override
    public FileSystem mkdir(String path, String perms, boolean createParents, Handler<AsyncResult<Void>> handler) {
        this.mkdirInternal(path, perms, createParents, handler).run();
        return this;
    }

    @Override
    public FileSystem mkdirSync(String path, String perms, boolean createParents) {
        this.mkdirInternal(path, perms, createParents, null).action();
        return this;
    }

    @Override
    public FileSystem readDir(String path, Handler<AsyncResult<String[]>> handler) {
        this.readDirInternal(path, handler).run();
        return this;
    }

    @Override
    public String[] readDirSync(String path) {
        return this.readDirInternal(path, null).action();
    }

    @Override
    public FileSystem readDir(String path, String filter, Handler<AsyncResult<String[]>> handler) {
        this.readDirInternal(path, filter, handler).run();
        return this;
    }

    @Override
    public String[] readDirSync(String path, String filter) {
        return this.readDirInternal(path, filter, null).action();
    }

    @Override
    public FileSystem readFile(String path, Handler<AsyncResult<Buffer>> handler) {
        this.readFileInternal(path, handler).run();
        return this;
    }

    @Override
    public Buffer readFileSync(String path) {
        return this.readFileInternal(path, null).action();
    }

    @Override
    public FileSystem writeFile(String path, Buffer data, Handler<AsyncResult<Void>> handler) {
        this.writeFileInternal(path, data, handler).run();
        return this;
    }

    @Override
    public FileSystem writeFileSync(String path, Buffer data) {
        this.writeFileInternal(path, data, null).action();
        return this;
    }

    @Override
    public FileSystem open(String path, Handler<AsyncResult<AsyncFile>> handler) {
        this.openInternal(path, handler).run();
        return this;
    }

    @Override
    public AsyncFile openSync(String path) {
        return this.openInternal(path, null).action();
    }

    @Override
    public FileSystem open(String path, String perms, Handler<AsyncResult<AsyncFile>> handler) {
        this.openInternal(path, perms, handler).run();
        return this;
    }

    @Override
    public AsyncFile openSync(String path, String perms) {
        return this.openInternal(path, perms, null).action();
    }

    @Override
    public FileSystem open(String path, String perms, boolean createNew, Handler<AsyncResult<AsyncFile>> handler) {
        this.openInternal(path, perms, createNew, handler).run();
        return this;
    }

    @Override
    public AsyncFile openSync(String path, String perms, boolean createNew) {
        return this.openInternal(path, perms, createNew, null).action();
    }

    @Override
    public FileSystem open(String path, String perms, boolean read, boolean write, boolean createNew, Handler<AsyncResult<AsyncFile>> handler) {
        this.openInternal(path, perms, read, write, createNew, handler).run();
        return this;
    }

    @Override
    public AsyncFile openSync(String path, String perms, boolean read, boolean write, boolean createNew) {
        return this.openInternal(path, perms, read, write, createNew, null).action();
    }

    @Override
    public FileSystem open(String path, String perms, boolean read, boolean write, boolean createNew, boolean flush, Handler<AsyncResult<AsyncFile>> handler) {
        this.openInternal(path, perms, read, write, createNew, flush, handler).run();
        return this;
    }

    @Override
    public AsyncFile openSync(String path, String perms, boolean read, boolean write, boolean createNew, boolean flush) {
        return this.openInternal(path, perms, read, write, createNew, flush, null).action();
    }

    @Override
    public FileSystem createFile(String path, Handler<AsyncResult<Void>> handler) {
        this.createFileInternal(path, handler).run();
        return this;
    }

    @Override
    public FileSystem createFileSync(String path) {
        this.createFileInternal(path, null).action();
        return this;
    }

    @Override
    public FileSystem createFile(String path, String perms, Handler<AsyncResult<Void>> handler) {
        this.createFileInternal(path, perms, handler).run();
        return this;
    }

    @Override
    public FileSystem createFileSync(String path, String perms) {
        this.createFileInternal(path, perms, null).action();
        return this;
    }

    @Override
    public FileSystem exists(String path, Handler<AsyncResult<Boolean>> handler) {
        this.existsInternal(path, handler).run();
        return this;
    }

    @Override
    public boolean existsSync(String path) {
        return this.existsInternal(path, null).action();
    }

    @Override
    public FileSystem fsProps(String path, Handler<AsyncResult<FileSystemProps>> handler) {
        this.fsPropsInternal(path, handler).run();
        return this;
    }

    @Override
    public FileSystemProps fsPropsSync(String path) {
        return this.fsPropsInternal(path, null).action();
    }

    private BlockingAction<Void> copyInternal(String from, String to, Handler<AsyncResult<Void>> handler) {
        return this.copyInternal(from, to, false, handler);
    }

    private BlockingAction<Void> copyInternal(String from, String to, final boolean recursive, Handler<AsyncResult<Void>> handler) {
        final Path source = PathAdjuster.adjust(this.vertx, Paths.get(from, new String[0]));
        final Path target = PathAdjuster.adjust(this.vertx, Paths.get(to, new String[0]));
        return new BlockingAction<Void>(this.vertx, handler){

            @Override
            public Void action() {
                try {
                    if (recursive) {
                        Files.walkFileTree(source, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                block2: {
                                    Path targetDir = target.resolve(source.relativize(dir));
                                    try {
                                        Files.copy(dir, targetDir, new CopyOption[0]);
                                    }
                                    catch (FileAlreadyExistsException e) {
                                        if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                                        throw e;
                                    }
                                }
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                Files.copy(file, target.resolve(source.relativize(file)), new CopyOption[0]);
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    } else {
                        Files.copy(source, target, new CopyOption[0]);
                    }
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> moveInternal(String from, String to, Handler<AsyncResult<Void>> handler) {
        final Path source = PathAdjuster.adjust(this.vertx, Paths.get(from, new String[0]));
        final Path target = PathAdjuster.adjust(this.vertx, Paths.get(to, new String[0]));
        return new BlockingAction<Void>(this.vertx, handler){

            @Override
            public Void action() {
                try {
                    Files.move(source, target, new CopyOption[0]);
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> truncateInternal(String p, final long len, Handler<AsyncResult<Void>> handler) {
        final String path = PathAdjuster.adjust(this.vertx, p);
        return new BlockingAction<Void>(this.vertx, handler){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void action() {
                if (len < 0L) {
                    throw new FileSystemException("Cannot truncate file to size < 0");
                }
                if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
                    throw new FileSystemException("Cannot truncate file " + path + ". Does not exist");
                }
                RandomAccessFile raf = null;
                try {
                    try {
                        raf = new RandomAccessFile(path, "rw");
                        raf.setLength(len);
                    }
                    finally {
                        if (raf != null) {
                            raf.close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> chmodInternal(String path, String perms, Handler<AsyncResult<Void>> handler) {
        return this.chmodInternal(path, perms, null, handler);
    }

    protected BlockingAction<Void> chmodInternal(String path, String perms, String dirPerms, Handler<AsyncResult<Void>> handler) {
        final Path target = PathAdjuster.adjust(this.vertx, Paths.get(path, new String[0]));
        final Set<PosixFilePermission> permissions = PosixFilePermissions.fromString(perms);
        final Set<PosixFilePermission> dirPermissions = dirPerms == null ? null : PosixFilePermissions.fromString(dirPerms);
        return new BlockingAction<Void>(this.vertx, handler){

            @Override
            public Void action() {
                try {
                    if (dirPermissions != null) {
                        Files.walkFileTree(target, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                Files.setPosixFilePermissions(dir, dirPermissions);
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                Files.setPosixFilePermissions(file, permissions);
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    } else {
                        Files.setPosixFilePermissions(target, permissions);
                    }
                }
                catch (SecurityException e) {
                    throw new FileSystemException("Accessed denied for chmod on " + target);
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    protected BlockingAction<Void> chownInternal(String path, final String user, final String group, Handler<AsyncResult<Void>> handler) {
        final Path target = PathAdjuster.adjust(this.vertx, Paths.get(path, new String[0]));
        final UserPrincipalLookupService service = target.getFileSystem().getUserPrincipalLookupService();
        return new BlockingAction<Void>(this.vertx, handler){

            @Override
            public Void action() {
                try {
                    GroupPrincipal groupPrincipal;
                    UserPrincipal userPrincipal = user == null ? null : service.lookupPrincipalByName(user);
                    GroupPrincipal groupPrincipal2 = groupPrincipal = group == null ? null : service.lookupPrincipalByGroupName(group);
                    if (groupPrincipal != null) {
                        PosixFileAttributeView view = Files.getFileAttributeView(target, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
                        if (view == null) {
                            throw new FileSystemException("Change group of file not supported");
                        }
                        view.setGroup(groupPrincipal);
                    }
                    if (userPrincipal != null) {
                        Files.setOwner(target, userPrincipal);
                    }
                }
                catch (SecurityException e) {
                    throw new FileSystemException("Accessed denied for chown on " + target);
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    private BlockingAction<FileProps> propsInternal(String path, Handler<AsyncResult<FileProps>> handler) {
        return this.props(path, true, handler);
    }

    private BlockingAction<FileProps> lpropsInternal(String path, Handler<AsyncResult<FileProps>> handler) {
        return this.props(path, false, handler);
    }

    private BlockingAction<FileProps> props(String path, final boolean followLinks, Handler<AsyncResult<FileProps>> handler) {
        final Path target = PathAdjuster.adjust(this.vertx, Paths.get(path, new String[0]));
        return new BlockingAction<FileProps>(this.vertx, handler){

            @Override
            public FileProps action() {
                try {
                    BasicFileAttributes attrs = followLinks ? Files.readAttributes(target, BasicFileAttributes.class, new LinkOption[0]) : Files.readAttributes(target, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    return new DefaultFileProps(attrs);
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
        };
    }

    private BlockingAction<Void> linkInternal(String link, String existing, Handler<AsyncResult<Void>> handler) {
        return this.link(link, existing, false, handler);
    }

    private BlockingAction<Void> symlinkInternal(String link, String existing, Handler<AsyncResult<Void>> handler) {
        return this.link(link, existing, true, handler);
    }

    private BlockingAction<Void> link(String link, String existing, final boolean symbolic, Handler<AsyncResult<Void>> handler) {
        final Path source = PathAdjuster.adjust(this.vertx, Paths.get(link, new String[0]));
        final Path target = PathAdjuster.adjust(this.vertx, Paths.get(existing, new String[0]));
        return new BlockingAction<Void>(this.vertx, handler){

            @Override
            public Void action() {
                try {
                    if (symbolic) {
                        Files.createSymbolicLink(source, target, new FileAttribute[0]);
                    } else {
                        Files.createLink(source, target);
                    }
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> unlinkInternal(String link, Handler<AsyncResult<Void>> handler) {
        return this.deleteInternal(link, handler);
    }

    private BlockingAction<String> readSymlinkInternal(String link, Handler<AsyncResult<String>> handler) {
        final Path source = PathAdjuster.adjust(this.vertx, Paths.get(link, new String[0]));
        return new BlockingAction<String>(this.vertx, handler){

            @Override
            public String action() {
                try {
                    return Files.readSymbolicLink(source).toString();
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
        };
    }

    private BlockingAction<Void> deleteInternal(String path, Handler<AsyncResult<Void>> handler) {
        return this.deleteInternal(path, false, handler);
    }

    private BlockingAction<Void> deleteInternal(String path, final boolean recursive, Handler<AsyncResult<Void>> handler) {
        final Path source = PathAdjuster.adjust(this.vertx, Paths.get(path, new String[0]));
        return new BlockingAction<Void>(this.vertx, handler){

            @Override
            public Void action() {
                try {
                    if (recursive) {
                        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                Files.delete(file);
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                                if (e == null) {
                                    Files.delete(dir);
                                    return FileVisitResult.CONTINUE;
                                }
                                throw e;
                            }
                        });
                    } else {
                        Files.delete(source);
                    }
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> mkdirInternal(String path, Handler<AsyncResult<Void>> handler) {
        return this.mkdirInternal(path, null, false, handler);
    }

    private BlockingAction<Void> mkdirInternal(String path, boolean createParents, Handler<AsyncResult<Void>> handler) {
        return this.mkdirInternal(path, null, createParents, handler);
    }

    private BlockingAction<Void> mkdirInternal(String path, String perms, Handler<AsyncResult<Void>> handler) {
        return this.mkdirInternal(path, perms, false, handler);
    }

    protected BlockingAction<Void> mkdirInternal(String path, String perms, final boolean createParents, Handler<AsyncResult<Void>> handler) {
        final Path source = PathAdjuster.adjust(this.vertx, Paths.get(path, new String[0]));
        final FileAttribute<Set<PosixFilePermission>> attrs = perms == null ? null : PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(perms));
        return new BlockingAction<Void>(this.vertx, handler){

            @Override
            public Void action() {
                try {
                    if (createParents) {
                        if (attrs != null) {
                            Files.createDirectories(source, attrs);
                        } else {
                            Files.createDirectories(source, new FileAttribute[0]);
                        }
                    } else if (attrs != null) {
                        Files.createDirectory(source, attrs);
                    } else {
                        Files.createDirectory(source, new FileAttribute[0]);
                    }
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    private BlockingAction<String[]> readDirInternal(String path, Handler<AsyncResult<String[]>> handler) {
        return this.readDirInternal(path, null, handler);
    }

    private BlockingAction<String[]> readDirInternal(String p, final String filter, Handler<AsyncResult<String[]>> handler) {
        final String path = PathAdjuster.adjust(this.vertx, p);
        return new BlockingAction<String[]>(this.vertx, handler){

            @Override
            public String[] action() {
                try {
                    File file = new File(path);
                    if (!file.exists()) {
                        throw new FileSystemException("Cannot read directory " + path + ". Does not exist");
                    }
                    if (!file.isDirectory()) {
                        throw new FileSystemException("Cannot read directory " + path + ". It's not a directory");
                    }
                    FilenameFilter fnFilter = filter != null ? new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return Pattern.matches(filter, name);
                        }
                    } : null;
                    File[] files = fnFilter == null ? file.listFiles() : file.listFiles(fnFilter);
                    String[] ret = new String[files.length];
                    int i = 0;
                    for (File f : files) {
                        ret[i++] = f.getCanonicalPath();
                    }
                    return ret;
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
        };
    }

    private BlockingAction<Buffer> readFileInternal(String path, Handler<AsyncResult<Buffer>> handler) {
        final Path target = PathAdjuster.adjust(this.vertx, Paths.get(path, new String[0]));
        return new BlockingAction<Buffer>(this.vertx, handler){

            @Override
            public Buffer action() {
                try {
                    byte[] bytes = Files.readAllBytes(target);
                    Buffer buff = new Buffer(bytes);
                    return buff;
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
        };
    }

    private BlockingAction<Void> writeFileInternal(String path, final Buffer data, Handler<AsyncResult<Void>> handler) {
        final Path target = PathAdjuster.adjust(this.vertx, Paths.get(path, new String[0]));
        return new BlockingAction<Void>(this.vertx, handler){

            @Override
            public Void action() {
                try {
                    Files.write(target, data.getBytes(), new OpenOption[0]);
                    return null;
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
        };
    }

    private BlockingAction<AsyncFile> openInternal(String path, Handler<AsyncResult<AsyncFile>> handler) {
        return this.openInternal(path, null, true, true, true, false, handler);
    }

    private BlockingAction<AsyncFile> openInternal(String path, String perms, Handler<AsyncResult<AsyncFile>> handler) {
        return this.openInternal(path, perms, true, true, true, false, handler);
    }

    private BlockingAction<AsyncFile> openInternal(String path, String perms, boolean createNew, Handler<AsyncResult<AsyncFile>> handler) {
        return this.openInternal(path, perms, true, true, createNew, false, handler);
    }

    private BlockingAction<AsyncFile> openInternal(String path, String perms, boolean read, boolean write, boolean createNew, Handler<AsyncResult<AsyncFile>> handler) {
        return this.openInternal(path, perms, read, write, createNew, false, handler);
    }

    private BlockingAction<AsyncFile> openInternal(String p, final String perms, final boolean read, final boolean write, final boolean createNew, final boolean flush, Handler<AsyncResult<AsyncFile>> handler) {
        final String path = PathAdjuster.adjust(this.vertx, p);
        return new BlockingAction<AsyncFile>(this.vertx, handler){

            @Override
            public AsyncFile action() {
                return DefaultFileSystem.this.doOpen(path, perms, read, write, createNew, flush, this.context);
            }
        };
    }

    protected AsyncFile doOpen(String path, String perms, boolean read, boolean write, boolean createNew, boolean flush, DefaultContext context) {
        return new DefaultAsyncFile(this.vertx, path, perms, read, write, createNew, flush, context);
    }

    private BlockingAction<Void> createFileInternal(String path, Handler<AsyncResult<Void>> handler) {
        return this.createFileInternal(path, null, handler);
    }

    protected BlockingAction<Void> createFileInternal(String p, String perms, Handler<AsyncResult<Void>> handler) {
        final String path = PathAdjuster.adjust(this.vertx, p);
        final FileAttribute<Set<PosixFilePermission>> attrs = perms == null ? null : PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(perms));
        return new BlockingAction<Void>(this.vertx, handler){

            @Override
            public Void action() {
                try {
                    Path target = Paths.get(path, new String[0]);
                    if (attrs != null) {
                        Files.createFile(target, attrs);
                    } else {
                        Files.createFile(target, new FileAttribute[0]);
                    }
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
                return null;
            }
        };
    }

    private BlockingAction<Boolean> existsInternal(String path, Handler<AsyncResult<Boolean>> handler) {
        final File file = new File(PathAdjuster.adjust(this.vertx, path));
        return new BlockingAction<Boolean>(this.vertx, handler){

            @Override
            public Boolean action() {
                return file.exists();
            }
        };
    }

    private BlockingAction<FileSystemProps> fsPropsInternal(String path, Handler<AsyncResult<FileSystemProps>> handler) {
        final Path target = PathAdjuster.adjust(this.vertx, Paths.get(path, new String[0]));
        return new BlockingAction<FileSystemProps>(this.vertx, handler){

            @Override
            public FileSystemProps action() {
                try {
                    FileStore fs = Files.getFileStore(target);
                    return new DefaultFileSystemProps(fs.getTotalSpace(), fs.getUnallocatedSpace(), fs.getUsableSpace());
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
        };
    }
}

