/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.pool;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.AbandonedConfig;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.pool.PoolableBroadcasterFactory;
import org.atmosphere.pool.PoolableProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnboundedApachePoolableProvider
implements PoolableProvider<Broadcaster, GenericObjectPool> {
    private final Logger logger = LoggerFactory.getLogger(UnboundedApachePoolableProvider.class);
    protected GenericObjectPool<Broadcaster> genericObjectPool;
    protected AtmosphereConfig config;
    protected final GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
    protected final AbandonedConfig abandonedConfig = new AbandonedConfig();
    private final AtomicLong count = new AtomicLong();

    @Override
    public void configure(AtmosphereConfig config) {
        this.config = config;
        this.configureGenericObjectPoolConfig();
        this.genericObjectPool = new GenericObjectPool((PooledObjectFactory)new BroadcasterFactory(), this.poolConfig, this.abandonedConfig);
    }

    protected void configureGenericObjectPoolConfig() {
        this.poolConfig.setMaxTotal(Integer.MAX_VALUE);
    }

    @Override
    public Broadcaster borrowBroadcaster(Object id) {
        try {
            return ((DefaultBroadcaster)DefaultBroadcaster.class.cast(this.genericObjectPool.borrowObject())).rename(id.toString());
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public PoolableProvider returnBroadcaster(Broadcaster b) {
        this.logger.trace("Return {} now at size {}", (Object)b.getID(), (Object)this.genericObjectPool.getNumActive());
        try {
            this.genericObjectPool.returnObject((Object)b);
        }
        catch (IllegalStateException ex) {
            this.logger.trace("", (Throwable)ex);
        }
        return this;
    }

    @Override
    public long poolSize() {
        return this.genericObjectPool.getCreatedCount();
    }

    @Override
    public long activeBroadcaster() {
        return this.genericObjectPool.getNumActive();
    }

    @Override
    public GenericObjectPool implementation() {
        return this.genericObjectPool;
    }

    private final class BroadcasterFactory
    extends BasePooledObjectFactory<Broadcaster> {
        private BroadcasterFactory() {
        }

        public Broadcaster create() {
            UnboundedApachePoolableProvider.this.logger.trace("Creating Broadcaster {}", (Object)UnboundedApachePoolableProvider.this.count.getAndIncrement());
            return ((PoolableBroadcasterFactory)PoolableBroadcasterFactory.class.cast(UnboundedApachePoolableProvider.this.config.getBroadcasterFactory())).createBroadcaster();
        }

        public PooledObject<Broadcaster> wrap(Broadcaster broadcaster) {
            UnboundedApachePoolableProvider.this.logger.trace("Wapping Object {}", (Object)broadcaster.getID());
            return new DefaultPooledObject((Object)broadcaster);
        }
    }
}

