/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.sstore.ClusteredSessionStore;
import io.vertx.ext.web.sstore.impl.SessionImpl;

public class ClusteredSessionStoreImpl
implements ClusteredSessionStore {
    private final Vertx vertx;
    private final String sessionMapName;
    private volatile AsyncMap<String, Session> sessionMap;

    public ClusteredSessionStoreImpl(Vertx vertx, String sessionMapName) {
        this.vertx = vertx;
        this.sessionMapName = sessionMapName;
    }

    @Override
    public Session createSession(long timeout) {
        return new SessionImpl(timeout);
    }

    @Override
    public void get(String id, Handler<AsyncResult<Session>> resultHandler) {
        this.getMap((Handler<AsyncResult<AsyncMap<String, Session>>>)((Handler)res -> {
            if (res.succeeded()) {
                ((AsyncMap)res.result()).get((Object)id, res2 -> {
                    if (res2.succeeded()) {
                        resultHandler.handle((Object)Future.succeededFuture((Object)res2.result()));
                    } else {
                        resultHandler.handle((Object)Future.failedFuture((Throwable)res2.cause()));
                    }
                });
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        }));
    }

    @Override
    public void delete(String id, Handler<AsyncResult<Boolean>> resultHandler) {
        this.getMap((Handler<AsyncResult<AsyncMap<String, Session>>>)((Handler)res -> {
            if (res.succeeded()) {
                ((AsyncMap)res.result()).remove((Object)id, res2 -> {
                    if (res2.succeeded()) {
                        resultHandler.handle((Object)Future.succeededFuture((Object)(res2.result() != null ? 1 : 0)));
                    } else {
                        resultHandler.handle((Object)Future.failedFuture((Throwable)res2.cause()));
                    }
                });
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        }));
    }

    @Override
    public void put(Session session, Handler<AsyncResult<Boolean>> resultHandler) {
        this.getMap((Handler<AsyncResult<AsyncMap<String, Session>>>)((Handler)res -> {
            if (res.succeeded()) {
                ((AsyncMap)res.result()).put((Object)session.id(), (Object)session, session.timeout(), res2 -> {
                    if (res2.succeeded()) {
                        resultHandler.handle((Object)Future.succeededFuture((Object)(res2.result() != null ? 1 : 0)));
                    } else {
                        resultHandler.handle((Object)Future.failedFuture((Throwable)res2.cause()));
                    }
                });
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        }));
    }

    @Override
    public void clear(Handler<AsyncResult<Boolean>> resultHandler) {
        this.getMap((Handler<AsyncResult<AsyncMap<String, Session>>>)((Handler)res -> {
            if (res.succeeded()) {
                ((AsyncMap)res.result()).clear(res2 -> {
                    if (res2.succeeded()) {
                        resultHandler.handle((Object)Future.succeededFuture((Object)(res2.result() != null ? 1 : 0)));
                    } else {
                        resultHandler.handle((Object)Future.failedFuture((Throwable)res2.cause()));
                    }
                });
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        }));
    }

    @Override
    public void size(Handler<AsyncResult<Integer>> resultHandler) {
        this.getMap((Handler<AsyncResult<AsyncMap<String, Session>>>)((Handler)res -> {
            if (res.succeeded()) {
                ((AsyncMap)res.result()).size(res2 -> {
                    if (res2.succeeded()) {
                        resultHandler.handle((Object)Future.succeededFuture((Object)res2.result()));
                    } else {
                        resultHandler.handle((Object)Future.failedFuture((Throwable)res2.cause()));
                    }
                });
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        }));
    }

    @Override
    public void close() {
    }

    private void getMap(Handler<AsyncResult<AsyncMap<String, Session>>> resultHandler) {
        if (this.sessionMap == null) {
            this.vertx.sharedData().getClusterWideMap(this.sessionMapName, res -> {
                if (res.succeeded()) {
                    this.sessionMap = (AsyncMap)res.result();
                    resultHandler.handle((Object)Future.succeededFuture((Object)res.result()));
                } else {
                    resultHandler.handle(res);
                }
            });
        } else {
            resultHandler.handle((Object)Future.succeededFuture(this.sessionMap));
        }
    }
}

