/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.shareddata.Lock;
import java.util.LinkedList;
import java.util.Queue;

public class AsynchronousLock
implements Lock {
    private Vertx vertx;
    private Queue<LockWaiter> waiters = new LinkedList<LockWaiter>();
    private boolean owned;

    public AsynchronousLock(Vertx vertx) {
        this.vertx = vertx;
    }

    public AsynchronousLock() {
    }

    public void acquire(long timeout, Handler<AsyncResult<Lock>> resultHandler) {
        Context context = this.vertx.getOrCreateContext();
        this.doAcquire(context, timeout, resultHandler);
    }

    @Override
    public synchronized void release() {
        LockWaiter waiter = this.pollWaiters();
        if (waiter != null) {
            waiter.acquire(this);
        } else {
            this.owned = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAcquire(Context context, long timeout, Handler<AsyncResult<Lock>> resultHandler) {
        AsynchronousLock asynchronousLock = this;
        synchronized (asynchronousLock) {
            if (!this.owned) {
                this.owned = true;
                this.lockAquired(context, resultHandler);
            } else {
                this.waiters.add(new LockWaiter(this, context, timeout, resultHandler));
            }
        }
    }

    private void lockAquired(Context context, Handler<AsyncResult<Lock>> resultHandler) {
        context.runOnContext(v -> resultHandler.handle(Future.succeededFuture(this)));
    }

    private LockWaiter pollWaiters() {
        LockWaiter waiter;
        do {
            if ((waiter = this.waiters.poll()) != null) continue;
            return null;
        } while (waiter.timedOut);
        return waiter;
    }

    private class LockWaiter {
        final AsynchronousLock lock;
        final Context context;
        final Handler<AsyncResult<Lock>> resultHandler;
        volatile boolean timedOut;
        volatile boolean acquired;

        LockWaiter(AsynchronousLock lock, Context context, long timeout, Handler<AsyncResult<Lock>> resultHandler) {
            this.lock = lock;
            this.context = context;
            this.resultHandler = resultHandler;
            if (timeout != Long.MAX_VALUE) {
                context.owner().setTimer(timeout, tid -> this.timedOut());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void timedOut() {
            AsynchronousLock asynchronousLock = this.lock;
            synchronized (asynchronousLock) {
                if (!this.acquired) {
                    this.timedOut = true;
                    this.context.runOnContext(v -> this.resultHandler.handle(Future.failedFuture(new VertxException("Timed out waiting to get lock"))));
                }
            }
        }

        void acquire(AsynchronousLock lock) {
            this.acquired = true;
            lock.lockAquired(this.context, this.resultHandler);
        }
    }
}

