/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.weblogic;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.weblogic.WebLogicCometSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weblogic.servlet.http.AbstractAsyncServlet;
import weblogic.servlet.http.RequestResponseKey;

public class AtmosphereWebLogicServlet
extends AbstractAsyncServlet {
    protected static final Logger logger = LoggerFactory.getLogger(AtmosphereServlet.class);
    protected AtmosphereFramework framework;

    public AtmosphereWebLogicServlet() {
        this(false);
    }

    public AtmosphereWebLogicServlet(boolean isFilter) {
        this(isFilter, true);
    }

    public AtmosphereWebLogicServlet(boolean isFilter, boolean autoDetectHandlers) {
        this.framework = new AtmosphereFramework(isFilter, autoDetectHandlers);
    }

    public void destroy() {
        this.framework.destroy();
    }

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.framework.setAsyncSupport((AsyncSupport)new WebLogicCometSupport(this.framework.getAtmosphereConfig()));
        this.framework.init(sc);
    }

    public AtmosphereFramework framework() {
        return this.framework;
    }

    protected boolean doRequest(RequestResponseKey rrk) throws IOException, ServletException {
        try {
            rrk.getRequest().getSession().setAttribute("RequestResponseKey", (Object)rrk);
            AtmosphereFramework.Action action = this.framework.doCometSupport(AtmosphereRequest.wrap((HttpServletRequest)rrk.getRequest()), AtmosphereResponse.wrap((HttpServletResponse)rrk.getResponse()));
            if (action.type == AtmosphereFramework.Action.TYPE.SUSPEND) {
                if (action.timeout == -1L) {
                    rrk.setTimeout(Integer.MAX_VALUE);
                } else {
                    rrk.setTimeout((int)action.timeout);
                }
            }
            return action.type == AtmosphereFramework.Action.TYPE.SUSPEND;
        }
        catch (IllegalStateException ex) {
            logger.error("AtmosphereServlet.doRequest exception", (Throwable)ex);
            throw ex;
        }
    }

    protected void doResponse(RequestResponseKey rrk, Object context) throws IOException, ServletException {
        rrk.getResponse().flushBuffer();
    }

    protected void doTimeout(RequestResponseKey rrk) throws IOException, ServletException {
        ((AsynchronousProcessor)this.framework.getAsyncSupport()).timedout(AtmosphereRequest.wrap((HttpServletRequest)rrk.getRequest()), AtmosphereResponse.wrap((HttpServletResponse)rrk.getResponse()));
    }
}

