/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.weblogic;

import java.io.IOException;
import javax.servlet.ServletException;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weblogic.servlet.http.AbstractAsyncServlet;
import weblogic.servlet.http.RequestResponseKey;

public class WebLogicCometSupport
extends AsynchronousProcessor {
    private static final Logger logger = LoggerFactory.getLogger(WebLogicCometSupport.class);
    public static final String RRK = "RequestResponseKey";

    public WebLogicCometSupport(AtmosphereConfig config) {
        super(config);
    }

    public Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Action action = this.suspended(req, res);
        if (action.type() == Action.TYPE.SUSPEND) {
            logger.debug("Suspending response: {}", (Object)res);
        } else if (action.type() == Action.TYPE.RESUME) {
            logger.debug("Resuming response: {}", (Object)res);
            Action nextAction = this.resumed(req, res);
            if (nextAction.type() == Action.TYPE.SUSPEND) {
                logger.debug("Suspending after resuming response: {}", (Object)res);
            }
        }
        return action;
    }

    public void action(AtmosphereResourceImpl actionEvent) {
        super.action(actionEvent);
        if (actionEvent.isInScope() && actionEvent.action().type() == Action.TYPE.RESUME && (this.config.getInitParameter("org.atmosphere.cpr.AtmosphereServlet.resumeAndKeepAlive") == null || this.config.getInitParameter("org.atmosphere.cpr.AtmosphereServlet.resumeAndKeepAlive").equalsIgnoreCase("false"))) {
            try {
                RequestResponseKey rrk = (RequestResponseKey)actionEvent.getRequest().getSession().getAttribute(RRK);
                AbstractAsyncServlet.notify((RequestResponseKey)rrk, null);
            }
            catch (IOException ex) {
                logger.debug("action failed", (Throwable)ex);
            }
        }
    }
}

