/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.xmpp;

import java.net.URI;
import org.atmosphere.util.AbstractBroadcasterProxy;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMPPBroadcaster
extends AbstractBroadcasterProxy {
    private static final Logger logger = LoggerFactory.getLogger(XMPPBroadcaster.class);
    private static final String XMPP_AUTH = XMPPBroadcaster.class.getName() + ".authorization";
    private static final String XMPP_SERVER = XMPPBroadcaster.class.getName() + ".server";
    private static final String XMPP_DEBUG = XMPPBroadcaster.class.getName() + ".debug";
    private URI uri;
    private String authToken;
    private XMPPConnection xmppConnection;
    private Chat channel;

    public XMPPBroadcaster() {
        this("atmosphere", URI.create("http://gmail.com"));
    }

    public XMPPBroadcaster(String id) {
        this(id, URI.create("http://gmail.com"));
    }

    public XMPPBroadcaster(URI uri) {
        this(XMPPBroadcaster.class.getSimpleName(), uri);
    }

    public XMPPBroadcaster(String id, URI uri) {
        super(id);
        this.uri = uri;
    }

    private void setUp() {
        if (this.uri == null) {
            return;
        }
        try {
            if (this.config != null) {
                if (this.config.getServletConfig().getInitParameter(XMPP_AUTH) == null) {
                    throw new IllegalStateException("No authorization token specified. Please make sure your web.xml contains:\n        <init-param>\n            <param-name>org.atmosphere.plugin.xmpp.XMPPBroadcaster.authorization</param-name>\n            <param-value>principal:password</param-value>\n        </init-param>");
                }
                this.authToken = this.config.getServletConfig().getInitParameter(XMPP_AUTH);
                if (this.config.getServletConfig().getInitParameter(XMPP_SERVER) != null) {
                    this.uri = URI.create(this.config.getServletConfig().getInitParameter(XMPP_SERVER));
                }
                if (this.config.getServletConfig().getInitParameter(XMPP_DEBUG) != null) {
                    XMPPConnection.DEBUG_ENABLED = true;
                }
            }
            ConnectionConfiguration config = null;
            int port = -1;
            try {
                port = this.uri.getPort();
            }
            catch (Throwable t) {
                // empty catch block
            }
            config = port == -1 ? new ConnectionConfiguration(this.uri.getHost()) : new ConnectionConfiguration(this.uri.getHost(), port);
            this.xmppConnection = new XMPPConnection(config);
            this.xmppConnection.connect();
            SASLAuthentication.supportSASLMechanism((String)"PLAIN", (int)0);
            String[] credentials = this.authToken.split(":");
            this.xmppConnection.login(credentials[0], credentials[1], this.getID());
            logger.info("Subscribing to: " + this.getID());
            this.channel = this.xmppConnection.getChatManager().createChat(this.getID(), new MessageListener(){

                public void processMessage(Chat chat, Message message) {
                    XMPPBroadcaster.this.broadcastReceivedMessage(message.getBody());
                }
            });
            logger.info("Connected to: " + this.getID());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void setID(String id) {
        super.setID(id);
        this.setUp();
    }

    public void destroy() {
        super.destroy();
        if (this.xmppConnection != null) {
            this.xmppConnection.disconnect();
        }
    }

    public void incomingBroadcast() {
    }

    public void outgoingBroadcast(Object message) {
        if (message instanceof String) {
            try {
                this.channel.sendMessage(message.toString());
            }
            catch (XMPPException e) {
                logger.debug("failed to send message on channel", (Throwable)e);
            }
        }
    }
}

