/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.extensions.gwt20.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.BufferedReader;
import java.io.IOException;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Serializer;
import org.atmosphere.extensions.gwt20.server.GwtRpcSerializer;
import org.atmosphere.gwt.shared.server.GwtRpcUtil;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwtRpcInterceptor
implements AtmosphereInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(GwtRpcInterceptor.class);

    public void configure(AtmosphereConfig config) {
    }

    public Action inspect(AtmosphereResource r) {
        if (r.getRequest().getContentType() == null || !r.getRequest().getContentType().startsWith("text/x-gwt-rpc") || this.isHandledByJersey(r)) {
            return Action.CONTINUE;
        }
        logger.debug("Found GWT-RPC Atmosphere request. method: " + r.getRequest().getMethod());
        if (r.getRequest().getMethod().equals("GET")) {
            if (!(r.getSerializer() instanceof GwtRpcSerializer)) {
                String contentType = r.getRequest().getContentType();
                String charEncoding = r.getRequest().getCharacterEncoding();
                r.getResponse().setContentType(contentType);
                r.getResponse().setCharacterEncoding(charEncoding);
                r.setSerializer((Serializer)new GwtRpcSerializer(r));
            }
        } else if (r.getRequest().getMethod().equals("POST")) {
            try {
                String data = GwtRpcUtil.readerToString((BufferedReader)r.getRequest().getReader());
                if (logger.isDebugEnabled()) {
                    logger.debug("Received message from client: " + data);
                }
                r.getRequest().setAttribute("gwt_deserialized_object", GwtRpcUtil.deserialize((String)data));
            }
            catch (IOException ex) {
                logger.error("Failed to read request data", (Throwable)ex);
            }
            catch (SerializationException ex) {
                logger.error("Failed to deserialize GWT RPC data");
            }
        }
        return Action.CONTINUE;
    }

    protected boolean isHandledByJersey(AtmosphereResource r) {
        if (r.getAtmosphereHandler() instanceof ReflectorServletProcessor) {
            return ((ReflectorServletProcessor)ReflectorServletProcessor.class.cast(r.getAtmosphereHandler())).getServletClassName().equals("com.sun.jersey.spi.container.servlet.ServletContainer");
        }
        return false;
    }

    public void postInspect(AtmosphereResource r) {
    }
}

