/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.extensions.gwt20.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.IOException;
import java.io.OutputStream;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Serializer;
import org.atmosphere.gwt.shared.server.GwtRpcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwtRpcSerializer
implements Serializer {
    private static final Logger logger = LoggerFactory.getLogger((String)GwtRpcSerializer.class.getName());
    private final AtmosphereResource resource;
    private final String outputEncoding;

    public GwtRpcSerializer(AtmosphereResource resource) {
        this.resource = resource;
        this.outputEncoding = resource.getResponse().getCharacterEncoding();
    }

    public void write(OutputStream out, Object o) throws IOException {
        String payload;
        try {
            payload = GwtRpcUtil.serialize((Object)o);
        }
        catch (SerializationException ex) {
            throw new IOException("Failed to deserialize message");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Writing to outputstream with encoding: " + this.outputEncoding + " data: " + payload);
        }
        out.write(payload.getBytes(this.outputEncoding));
        out.flush();
    }
}

