/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.gwt20.jackson;

import java.io.IOException;
import java.util.Map;
import org.atmosphere.gwt20.jackson.JacksonSerializerProvider;
import org.atmosphere.gwt20.server.SerializationException;
import org.atmosphere.gwt20.server.ServerSerializer;

public class JacksonSerializer
implements ServerSerializer {
    final JacksonSerializerProvider provider;

    public JacksonSerializer(JacksonSerializerProvider provider) {
        this.provider = provider;
    }

    public String serialize(Object data) throws SerializationException {
        try {
            return this.provider.mapper.writeValueAsString(data);
        }
        catch (IOException ex) {
            throw new SerializationException("Failed to serialize data", (Throwable)ex);
        }
    }

    public Object deserialize(String data) throws SerializationException {
        try {
            return this.provider.mapper.readValue(data, Map.class);
        }
        catch (IOException ex) {
            throw new SerializationException("Failed to deserialize data", (Throwable)ex);
        }
    }
}

