/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.gwt20.jersey;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.atmosphere.gwt20.jersey.MediaTypes;
import org.atmosphere.gwt20.server.GwtRpcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Consumes(value={"text/x-gwt-rpc"})
@Provider
public class GwtRpcReader
implements MessageBodyReader<Object> {
    private static final Logger logger = LoggerFactory.getLogger(GwtRpcReader.class);

    public boolean isReadable(Class<?> type, Type type1, Annotation[] antns, MediaType mt) {
        return mt.isCompatible(MediaTypes.GWT_RPC_MEDIA_TYPE);
    }

    public Object readFrom(Class<Object> type, Type type1, Annotation[] antns, MediaType mt, MultivaluedMap<String, String> headers, InputStream in) throws IOException, WebApplicationException {
        try {
            String data;
            String charset = (String)mt.getParameters().get("charset");
            if (charset == null || charset.isEmpty()) {
                charset = "UTF-8";
            }
            if ((data = GwtRpcUtil.streamToString((InputStream)in, (String)charset)).isEmpty()) {
                throw new WebApplicationException(Response.Status.NO_CONTENT);
            }
            return GwtRpcUtil.deserialize((String)data);
        }
        catch (SerializationException ex) {
            logger.error("Failed to deserialize RPC data", (Throwable)ex);
            throw new WebApplicationException((Throwable)ex, Response.Status.BAD_REQUEST);
        }
    }
}

