/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.rmi;

import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.ClusterBroadcastFilter;
import org.atmosphere.plugin.rmi.RMIPeerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMIFilter
implements ClusterBroadcastFilter {
    private final Logger logger = LoggerFactory.getLogger(RMIFilter.class);
    private Broadcaster bc;

    public void destroy() {
        this.logger.info("Destroying {}", (Object)this.getClass().getName());
        this.bc = null;
    }

    public void init(AtmosphereConfig config) {
        this.logger.info("Initializing {}", (Object)this.getClass().getName());
    }

    public BroadcastFilter.BroadcastAction filter(Object originalMessage, Object message) {
        this.logger.info("Filtering message '{}' with {}", new Object[]{message, this.getClass().getName()});
        RMIPeerManager.getInstance().sendAll(this.bc.getID(), message);
        return new BroadcastFilter.BroadcastAction(message);
    }

    public Broadcaster getBroadcaster() {
        return this.bc;
    }

    public void setBroadcaster(Broadcaster bc) {
        this.logger.info("Setting broadcaster for {}", (Object)this.getClass().getName());
        this.bc = bc;
    }

    public void setUri(String clusterUri) {
    }
}

