/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.rmi;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.atmosphere.plugin.rmi.RMIBroadcastService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMIPeerManager {
    private static RMIPeerManager instance;
    private static final String RMI_PROPERTIES_LOCATION = "/org/atmosphere/plugin/rmi/rmi.properties";
    private static final String RMI_SERVER_PORT_PROPERTY = "rmi.server.port";
    private static final String PEER_PROPERTY_PREFIX = "rmi.peer.";
    private static final String SYSTEM_PROPERTY_PREFIX = "org.atmosphere.";
    private final Logger logger = LoggerFactory.getLogger(RMIPeerManager.class);
    private List<Peer> peers;
    private Registry registry;
    private int serverPort;

    private RMIPeerManager() {
        this.logger.info("Looking for '{}' file in the classpath", (Object)RMI_PROPERTIES_LOCATION);
        InputStream peerProperties = this.getClass().getResourceAsStream(RMI_PROPERTIES_LOCATION);
        if (peerProperties == null) {
            throw new IllegalStateException("You must provide a '/org/atmosphere/plugin/rmi/rmi.properties' file in your classpath.");
        }
        this.peers = new ArrayList<Peer>();
        Properties properties = new Properties();
        try {
            this.logger.info("Loading '{}' file in found classpath", (Object)RMI_PROPERTIES_LOCATION);
            properties.load(peerProperties);
            this.discoverServerPort(properties);
            this.discoverPeers(properties);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unable to load '/org/atmosphere/plugin/rmi/rmi.properties' file from the classpath", ioe);
        }
    }

    private void discoverServerPort(Properties properties) {
        String portValue = properties.getProperty(RMI_SERVER_PORT_PROPERTY);
        if (portValue == null) {
            throw new IllegalArgumentException("rmi.server.port property's value is null. Must be a valid integer");
        }
        String sysPropertyKey = "org.atmosphere.rmi.server.port";
        String sysPropertyValue = System.getProperty("org.atmosphere.rmi.server.port");
        if (sysPropertyValue != null) {
            this.logger.info("System property '{}' set. Overriding value '{}' with '{}'", new Object[]{"org.atmosphere.rmi.server.port", portValue, sysPropertyValue});
            portValue = sysPropertyValue;
        }
        try {
            this.serverPort = Integer.parseInt(portValue);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("rmi.server.port property's value is not an integer : " + portValue, nfe);
        }
    }

    private void discoverPeers(Properties properties) {
        this.logger.info("Discovering RMI peers");
        for (String propertyKey : properties.stringPropertyNames()) {
            String propertyValue = String.valueOf(properties.get(propertyKey));
            if (!propertyKey.startsWith(PEER_PROPERTY_PREFIX)) continue;
            this.logger.info("Reading peer-key '{}' with value '{}'", (Object)propertyKey, (Object)propertyValue);
            String sysPropertyKey = SYSTEM_PROPERTY_PREFIX + propertyKey;
            String sysPropertyValue = System.getProperty(sysPropertyKey);
            if (sysPropertyValue != null) {
                this.logger.info("System property '{}' set. Overriding value '{}' with '{}'", new Object[]{sysPropertyKey, propertyValue, sysPropertyValue});
                propertyValue = sysPropertyValue;
            }
            try {
                String peerUrl = String.format("rmi://%s/%s/", propertyValue, RMIBroadcastService.class.getSimpleName());
                this.logger.info("Going to connect peer at {}", (Object)peerUrl);
                this.peers.add(new Peer(peerUrl));
            }
            catch (MalformedURLException mue) {
                throw new IllegalArgumentException("Property value for key '" + propertyKey + "' must corresponds to valid host name and port (for instance foo:4000). Incorrect found value : " + propertyValue);
            }
        }
    }

    public static synchronized RMIPeerManager getInstance() {
        if (instance == null) {
            instance = new RMIPeerManager();
        }
        return instance;
    }

    public synchronized void sendAll(String broadcasterId, Object message) {
        this.logger.info("Sending message to {} known RMI peers", (Object)this.peers.size());
        for (Peer peer : this.peers) {
            peer.send(broadcasterId, message, 1);
        }
    }

    public synchronized void server(String broadcasterId, RMIBroadcastService service) {
        try {
            if (this.registry == null) {
                this.logger.info("Creating registry with port {}", (Object)this.serverPort);
                this.registry = LocateRegistry.createRegistry(this.serverPort);
            }
            this.logger.info("Rebinding {}", (Object)RMIBroadcastService.class.getSimpleName());
            String url = RMIBroadcastService.class.getSimpleName() + "/" + broadcasterId;
            this.logger.info("URL : {}", (Object)url);
            this.registry.rebind(url, service);
        }
        catch (RemoteException re) {
            this.logger.error("Unable to create the RMI server. Won't receive message to broadcast from other peers", (Throwable)re);
        }
    }

    private class Peer {
        String url;

        Peer(String peerUrl) throws MalformedURLException {
            this.url = peerUrl;
            this.connect("");
        }

        RMIBroadcastService connect(String broadcasterId) throws MalformedURLException {
            try {
                RMIPeerManager.this.logger.info("Trying to connect to {}", (Object)this.url);
                return (RMIBroadcastService)Naming.lookup(this.url + broadcasterId);
            }
            catch (RemoteException re) {
                RMIPeerManager.this.logger.warn("Could not reach the remote host with the url {}. Reason is '{}'. Will try later", (Object)new Object[]{this.url, re.getMessage()}, (Object)re);
            }
            catch (NotBoundException nbe) {
                RMIPeerManager.this.logger.warn("{} for url {} not currently bound. Reason is {}. Will try later", (Object)new Object[]{RMIBroadcastService.class.getSimpleName(), this.url, nbe.getMessage()}, (Object)nbe);
            }
            return null;
        }

        synchronized void send(String broadcasterId, Object message, int retry) {
            try {
                RMIBroadcastService service = this.connect(broadcasterId);
                if (service != null) {
                    RMIPeerManager.this.logger.debug("Sending message '{}' to peer at url {}", new Object[]{message, this.url});
                    if (retry > 0) {
                        try {
                            service.send(message);
                        }
                        catch (Exception e) {
                            RMIPeerManager.this.logger.warn("Send operation failed {}. Retrying...", (Object)e.getMessage());
                            this.send(broadcasterId, message, retry - 1);
                        }
                    } else {
                        service.send(message);
                    }
                }
            }
            catch (MalformedURLException mue) {
                throw new IllegalStateException(mue);
            }
            catch (RemoteException re) {
                RMIPeerManager.this.logger.warn("Failed to send message to peer '{}'", (Object)this.url, (Object)re);
            }
        }
    }
}

