/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.rmi;

import java.util.concurrent.CountDownLatch;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.plugin.rmi.RMIBroadcastServiceImpl;
import org.atmosphere.plugin.rmi.RMIPeerManager;
import org.atmosphere.util.AbstractBroadcasterProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMIBroadcaster
extends AbstractBroadcasterProxy {
    private final CountDownLatch ready = new CountDownLatch(1);
    private final Logger logger = LoggerFactory.getLogger(RMIBroadcaster.class);

    public Broadcaster initialize(String id, AtmosphereConfig config) {
        return this.initialize(id, null, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingBroadcast() {
        try {
            this.logger.info("Starting Atmosphere RMI Clustering support");
            RMIPeerManager.getInstance().server(this.getID(), new RMIBroadcastServiceImpl(this), this.config);
        }
        catch (Throwable t) {
            this.logger.warn("Failed to initialize RMI server", t);
        }
        finally {
            this.ready.countDown();
        }
    }

    public void outgoingBroadcast(Object o) {
        this.logger.info("Outgoing broadcast for {}", o);
        super.broadcastReceivedMessage(o);
        RMIPeerManager.getInstance().sendAll(this.getID(), o);
    }

    public void broadcastReceivedMessage(Object message) {
        super.broadcastReceivedMessage(message);
    }
}

