/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.rmi;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.plugin.rmi.RMIBroadcastService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMIPeerManager {
    private static RMIPeerManager instance;
    private static final String RMI_PROPERTIES_LOCATION = "/org/atmosphere/plugin/rmi/rmi.properties";
    private static final String RMI_SERVER_PORT_PROPERTY = "rmi.server.port";
    private static final String PEER_PROPERTY_PREFIX = "rmi.peer.";
    private static final String SYSTEM_PROPERTY_PREFIX = "org.atmosphere.";
    private static final String RMI_SERVER_PORT_SYSTEM_PROPERTY = "org.atmosphere.rmi.server.port";
    private static final String PEER_SYSTEM_PROPERTY_PREFIX = "org.atmosphere.rmi.peer.";
    private final Logger logger = LoggerFactory.getLogger(RMIPeerManager.class);
    private List<Peer> peers;
    private Registry registry;
    private int serverPort;

    private RMIPeerManager() {
        Properties properties = new Properties();
        this.logger.info("Looking for '{}' file in the classpath", (Object)RMI_PROPERTIES_LOCATION);
        InputStream peerProperties = this.getClass().getResourceAsStream(RMI_PROPERTIES_LOCATION);
        if (peerProperties != null) {
            try {
                this.logger.info("Loading '{}' file from classpath", (Object)RMI_PROPERTIES_LOCATION);
                properties.load(peerProperties);
            }
            catch (IOException ioe) {
                this.logger.error("Unable to load '/org/atmosphere/plugin/rmi/rmi.properties' file from the classpath", (Throwable)ioe);
            }
        }
        this.peers = new ArrayList<Peer>();
        this.discoverServerPort(properties);
        this.discoverPeers(properties);
    }

    private void discoverServerPort(Properties properties) {
        String portValue = properties.getProperty(RMI_SERVER_PORT_PROPERTY);
        String sysPropertyValue = System.getProperty(RMI_SERVER_PORT_SYSTEM_PROPERTY);
        if (sysPropertyValue != null) {
            this.logger.info("System property '{}' set. Overriding value '{}' with '{}'", new Object[]{RMI_SERVER_PORT_SYSTEM_PROPERTY, portValue, sysPropertyValue});
            portValue = sysPropertyValue;
        }
        if (portValue == null) {
            throw new IllegalArgumentException("rmi.server.port property's value is null. Must be a valid integer");
        }
        try {
            this.serverPort = Integer.parseInt(portValue);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("rmi.server.port property's value is not an integer : " + portValue, nfe);
        }
    }

    private void discoverPeers(Properties properties) {
        String peerAuthority;
        String peerName;
        this.logger.info("Discovering RMI peers");
        HashMap<String, String> sysPropPeerAuthorityByPeerName = new HashMap<String, String>();
        for (Map.Entry<Object, Object> sysProp : System.getProperties().entrySet()) {
            String sysPropKey = sysProp.getKey().toString();
            if (!sysPropKey.startsWith(PEER_SYSTEM_PROPERTY_PREFIX)) continue;
            peerName = sysPropKey.substring(PEER_SYSTEM_PROPERTY_PREFIX.length());
            peerAuthority = sysProp.getValue().toString();
            this.addPeer(peerName, peerAuthority);
            sysPropPeerAuthorityByPeerName.put(peerName, peerAuthority);
            this.logger.info("Added peer '{}' with authority '{}' from system properties", (Object)peerName, (Object)peerAuthority);
        }
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            String propertyKey = property.getKey().toString();
            if (!propertyKey.startsWith(PEER_PROPERTY_PREFIX)) continue;
            peerName = propertyKey.substring(PEER_PROPERTY_PREFIX.length());
            peerAuthority = property.getValue().toString();
            String sysPropPeerAuthority = (String)sysPropPeerAuthorityByPeerName.get(peerName);
            if (sysPropPeerAuthority == null) {
                this.addPeer(peerName, peerAuthority);
                this.logger.info("Added peer '{}' with authority '{}' from properties", (Object)peerName, (Object)peerAuthority);
                continue;
            }
            if (sysPropPeerAuthority.equals(peerAuthority)) continue;
            this.logger.info("Peer '{}' with authority '{}' from system properties overrode authority '{}'", new Object[]{peerName, sysPropPeerAuthority, peerAuthority});
        }
    }

    private void addPeer(String peerName, String peerAuthority) {
        try {
            this.peers.add(new Peer("rmi://" + peerAuthority + '/' + RMIBroadcastService.class.getSimpleName() + '/'));
        }
        catch (MalformedURLException mue) {
            throw new IllegalArgumentException("Value for peer '" + peerName + "' must be a valid host name and port (e.g., foo:40001). Invalid value: " + peerAuthority);
        }
    }

    public static synchronized RMIPeerManager getInstance() {
        if (instance == null) {
            instance = new RMIPeerManager();
        }
        return instance;
    }

    public synchronized void sendAll(String broadcasterId, Object message) {
        this.logger.info("Sending message to {} known RMI peers", (Object)this.peers.size());
        for (Peer peer : this.peers) {
            peer.send(broadcasterId, message, 1);
        }
    }

    public synchronized void server(String broadcasterId, RMIBroadcastService service, AtmosphereConfig config) {
        try {
            if (this.registry == null) {
                this.logger.info("Creating registry with port {}", (Object)this.serverPort);
                this.registry = LocateRegistry.createRegistry(this.serverPort);
                if (config != null) {
                    config.shutdownHook(new AtmosphereConfig.ShutdownHook(){

                        public void shutdown() {
                            for (Thread t : Thread.getAllStackTraces().keySet()) {
                                if (!"RMI Reaper".equals(t.getName())) continue;
                                t.interrupt();
                            }
                        }
                    });
                }
            }
            this.logger.info("Rebinding {}", (Object)RMIBroadcastService.class.getSimpleName());
            String url = RMIBroadcastService.class.getSimpleName() + "/" + broadcasterId;
            this.logger.info("URL : {}", (Object)url);
            this.registry.rebind(url, service);
        }
        catch (RemoteException re) {
            this.logger.error("Unable to create the RMI server. Won't receive message to broadcast from other peers", (Throwable)re);
        }
    }

    private class Peer {
        String url;

        Peer(String peerUrl) throws MalformedURLException {
            RMIPeerManager.this.logger.info("Connecting to peer at {}", (Object)peerUrl);
            this.url = peerUrl;
            this.connect("");
        }

        RMIBroadcastService connect(String broadcasterId) throws MalformedURLException {
            try {
                RMIPeerManager.this.logger.info("Trying to connect to {}", (Object)this.url);
                return (RMIBroadcastService)Naming.lookup(this.url + broadcasterId);
            }
            catch (RemoteException re) {
                RMIPeerManager.this.logger.warn("Could not reach the remote host with the url {}. Reason is '{}'. Will try later", (Object)new Object[]{this.url, re.getMessage()}, (Object)re);
            }
            catch (NotBoundException nbe) {
                RMIPeerManager.this.logger.warn("{} for url {} not currently bound. Reason is {}. Will try later", (Object)new Object[]{RMIBroadcastService.class.getSimpleName(), this.url, nbe.getMessage()}, (Object)nbe);
            }
            return null;
        }

        synchronized void send(String broadcasterId, Object message, int retry) {
            try {
                RMIBroadcastService service = this.connect(broadcasterId);
                if (service != null) {
                    RMIPeerManager.this.logger.debug("Sending message '{}' to peer at url {}", new Object[]{message, this.url});
                    if (retry > 0) {
                        try {
                            service.send(message);
                        }
                        catch (Exception e) {
                            RMIPeerManager.this.logger.warn("Send operation failed {}. Retrying...", (Object)e.getMessage());
                            this.send(broadcasterId, message, retry - 1);
                        }
                    } else {
                        service.send(message);
                    }
                }
            }
            catch (MalformedURLException mue) {
                throw new IllegalStateException(mue);
            }
            catch (RemoteException re) {
                RMIPeerManager.this.logger.warn("Failed to send message to peer '{}'", (Object)this.url, (Object)re);
            }
        }
    }
}

