/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jboss.websockets.oio.internal.protocol.ietf07;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.atmosphere.jboss.websockets.oio.ClosingStrategy;
import org.atmosphere.jboss.websockets.oio.HttpRequestBridge;
import org.atmosphere.jboss.websockets.oio.HttpResponseBridge;
import org.atmosphere.jboss.websockets.oio.OioWebSocket;
import org.atmosphere.jboss.websockets.oio.internal.Handshake;
import org.atmosphere.jboss.websockets.oio.internal.WebSocketHeaders;
import org.atmosphere.jboss.websockets.oio.internal.protocol.ietf07.Hybi07Socket;
import org.atmosphere.jboss.websockets.oio.internal.util.Base64;

public class Hybi07Handshake
extends Handshake {
    protected Hybi07Handshake(String version) {
        super(version, "SHA1", "258EAFA5-E914-47DA-95CA-C5AB0DC85B11");
    }

    public Hybi07Handshake() {
        this("7");
    }

    public OioWebSocket getWebSocket(HttpRequestBridge request, HttpResponseBridge response, ClosingStrategy closingStrategy) throws IOException {
        return Hybi07Socket.from(request, response, closingStrategy);
    }

    public boolean matches(HttpRequestBridge request) {
        return WebSocketHeaders.SEC_WEBSOCKET_KEY.isIn(request) && WebSocketHeaders.SEC_WEBSOCKET_VERSION.matches(request, this.getVersion());
    }

    public byte[] generateResponse(HttpRequestBridge request, HttpResponseBridge response) throws IOException {
        if (WebSocketHeaders.ORIGIN.isIn(request)) {
            WebSocketHeaders.SEC_WEBSOCKET_ORIGIN.set(response, WebSocketHeaders.ORIGIN.get(request));
        }
        WebSocketHeaders.SEC_WEBSOCKET_PROTOCOL.copy(request, response);
        WebSocketHeaders.SEC_WEBSOCKET_LOCATION.set(response, this.getWebSocketLocation(request));
        String key = WebSocketHeaders.SEC_WEBSOCKET_KEY.get(request);
        String solution = this.solve(key);
        WebSocketHeaders.SEC_WEBSOCKET_ACCEPT.set(response, solution);
        return new byte[0];
    }

    public String solve(String nonceBase64) {
        try {
            String concat = nonceBase64.trim().concat(this.getMagicNumber());
            MessageDigest digest = MessageDigest.getInstance(this.getHashAlgorithm());
            digest.update(concat.getBytes("UTF-8"));
            String result = Base64.encodeBase64String(digest.digest()).trim();
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("error generating hash", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("could not get UTF-8 bytes");
        }
    }
}

