/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jboss.websockets.oio.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.atmosphere.jboss.websockets.oio.ClosingStrategy;
import org.atmosphere.jboss.websockets.oio.OioWebSocket;
import org.atmosphere.jboss.websockets.oio.internal.util.Assert;
import org.atmosphere.jboss.websockets.oio.internal.util.Hash;

public abstract class AbstractWebSocket
implements OioWebSocket {
    protected final String webSocketId = Hash.newUniqueHash();
    protected final InputStream inputStream;
    protected final OutputStream outputStream;
    protected final ClosingStrategy closingStrategy;

    protected AbstractWebSocket(InputStream inputStream, OutputStream outputStream, ClosingStrategy closingStrategy) {
        this.inputStream = Assert.notNull(inputStream, "inputStream must NOT be null");
        this.outputStream = Assert.notNull(outputStream, "outputStream must NOT be null");
        this.closingStrategy = Assert.notNull(closingStrategy, "closingStrategy must NOT be null");
    }

    public final String getSocketID() {
        return this.webSocketId;
    }

    public void closeSocket() throws IOException {
        this.closingStrategy.doClose();
    }
}

