/*
 * Decompiled with CFR 0.152.
 */
package eu.infomas.annotation;

import eu.infomas.annotation.ZipFileIterator;
import eu.infomas.util.FileIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

final class ClassFileIterator {
    private final FileIterator fileIterator;
    private ZipFileIterator zipIterator;

    ClassFileIterator() throws IOException {
        this(ClassFileIterator.classPath());
    }

    public ClassFileIterator(File ... filesOrDirectories) throws IOException {
        this.fileIterator = new FileIterator(filesOrDirectories);
    }

    public String getName() {
        return this.zipIterator == null ? this.fileIterator.getFile().getPath() : this.zipIterator.getEntry().getName();
    }

    public InputStream next() throws IOException {
        if (this.zipIterator == null) {
            File file = this.fileIterator.next();
            if (file == null) {
                return null;
            }
            String name = file.getName();
            if (name.endsWith(".class")) {
                return new FileInputStream(file);
            }
            if (this.fileIterator.isRootFile() && ClassFileIterator.endsWithIgnoreCase(name, ".jar")) {
                this.zipIterator = new ZipFileIterator(file);
            }
            return this.next();
        }
        InputStream is = this.zipIterator.next();
        if (is == null) {
            this.zipIterator = null;
            return this.next();
        }
        return is;
    }

    private static File[] classPath() {
        String[] fileNames = System.getProperty("java.class.path").split(File.pathSeparator);
        File[] files = new File[fileNames.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new File(fileNames[i]);
        }
        return files;
    }

    private static boolean endsWithIgnoreCase(String value, String suffix) {
        int n = suffix.length();
        return value.regionMatches(true, value.length() - n, suffix, 0, n);
    }
}

