/*
 * Decompiled with CFR 0.152.
 */
package eu.infomas.annotation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

final class ZipFileIterator {
    private final ZipFile zipFile;
    private final Enumeration<? extends ZipEntry> entries;
    private ZipEntry current;

    ZipFileIterator(File file) throws IOException {
        this.zipFile = new ZipFile(file);
        this.entries = this.zipFile.entries();
    }

    public ZipEntry getEntry() {
        return this.current;
    }

    public InputStream next() throws IOException {
        while (this.entries.hasMoreElements()) {
            this.current = this.entries.nextElement();
            if (this.current.isDirectory()) continue;
            return this.zipFile.getInputStream(this.current);
        }
        return null;
    }
}

