/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cache;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.atmosphere.cache.AbstractBroadcasterCache;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.BroadcasterCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionBroadcasterCache
extends AbstractBroadcasterCache {
    private static final Logger logger = LoggerFactory.getLogger(SessionBroadcasterCache.class);
    private static final String ERROR_MESSAGE = "Session was null. The request has been recycled by the underlying container";

    @Override
    public void addToCache(String broadcasterId, AtmosphereResource r, BroadcasterCache.Message message) {
        long now = System.nanoTime();
        this.put(message, now);
        if (r == null) {
            return;
        }
        HttpSession session = r.session();
        if (session == null) {
            logger.error(ERROR_MESSAGE);
            return;
        }
        session.setAttribute(broadcasterId, String.valueOf(now));
    }

    @Override
    public List<Object> retrieveFromCache(String broadcasterId, AtmosphereResource r) {
        if (r == null) {
            throw new IllegalArgumentException("AtmosphereResource can't be null");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        HttpSession session = r.session();
        if (session == null) {
            logger.error(ERROR_MESSAGE);
            return result;
        }
        String cacheHeaderTimeStr = (String)session.getAttribute(broadcasterId);
        if (cacheHeaderTimeStr == null) {
            return result;
        }
        Long cacheHeaderTime = Long.valueOf(cacheHeaderTimeStr);
        if (cacheHeaderTime == null) {
            return result;
        }
        return this.get(cacheHeaderTime);
    }
}

