/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Servlet30CometSupport
extends AsynchronousProcessor {
    private static final Logger logger = LoggerFactory.getLogger(Servlet30CometSupport.class);

    public Servlet30CometSupport(AtmosphereConfig config) {
        super(config);
    }

    @Override
    public String getContainerName() {
        return super.getContainerName() + " using javax.servlet/3.0";
    }

    @Override
    public Action service(AtmosphereRequest request, AtmosphereResponse response) throws IOException, ServletException {
        Action action = this.suspended(request, response);
        if (action.type() == Action.TYPE.SUSPEND) {
            this.suspend(action, request, response);
        } else if (action.type() == Action.TYPE.RESUME) {
            Action nextAction;
            AsyncContext asyncContext;
            if (this.supportSession() && (asyncContext = (AsyncContext)request.getSession().getAttribute("org.atmosphere.container.asyncContext")) != null) {
                asyncContext.complete();
            }
            if ((nextAction = this.resumed(request, response)).type() == Action.TYPE.SUSPEND) {
                this.suspend(action, request, response);
            }
        }
        return action;
    }

    private void suspend(Action action, AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        if (!req.isAsyncStarted()) {
            AsyncContext asyncContext = req.startAsync(req, res);
            asyncContext.addListener((AsyncListener)new CometListener(this));
            if (action.timeout() != -1L) {
                asyncContext.setTimeout(action.timeout());
            } else {
                asyncContext.setTimeout(Integer.MAX_VALUE);
            }
            req.setAttribute("org.atmosphere.container.asyncContext", asyncContext);
            if (this.supportSession()) {
                req.getSession().setAttribute("org.atmosphere.container.asyncContext", asyncContext);
            }
        }
    }

    @Override
    public void action(AtmosphereResourceImpl actionEvent) {
        super.action(actionEvent);
        if (actionEvent.action().type() == Action.TYPE.RESUME && actionEvent.isInScope()) {
            AsyncContext asyncContext = (AsyncContext)actionEvent.getRequest().getAttribute("org.atmosphere.container.asyncContext");
            if (asyncContext == null && this.supportSession()) {
                asyncContext = (AsyncContext)actionEvent.getRequest().getSession().getAttribute("org.atmosphere.container.asyncContext");
            }
            if (asyncContext != null && (this.config.getInitParameter("org.atmosphere.cpr.AtmosphereServlet.resumeAndKeepAlive") == null || this.config.getInitParameter("org.atmosphere.cpr.AtmosphereServlet.resumeAndKeepAlive").equalsIgnoreCase("false"))) {
                try {
                    asyncContext.complete();
                }
                catch (IllegalStateException ex) {
                    logger.trace("Already resumed!", ex);
                }
            }
        } else if (!actionEvent.isInScope()) {
            logger.debug("Already resumed or cancelled: event: {}", actionEvent);
        }
    }

    private static final class CometListener
    implements AsyncListener {
        private final AsynchronousProcessor p;

        public CometListener() {
            this.p = null;
        }

        public CometListener(AsynchronousProcessor processor) {
            this.p = processor;
        }

        public void onComplete(AsyncEvent event) throws IOException {
            logger.debug("Resumed (completed): event: {}", event.getAsyncContext().getRequest());
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            logger.debug("onTimeout(): event: {}", event.getAsyncContext().getRequest());
            if (this.p == null) {
                logger.error("Invalid state - CometListener");
                return;
            }
            try {
                this.p.timedout((AtmosphereRequest)event.getAsyncContext().getRequest(), (AtmosphereResponse)event.getAsyncContext().getResponse());
            }
            catch (ServletException ex) {
                logger.debug("onTimeout(): failed timing out comet response: " + event.getAsyncContext().getResponse(), ex);
            }
        }

        public void onError(AsyncEvent event) {
            logger.debug("onError(): event: {}", event.getAsyncContext().getResponse());
            if (this.p == null) {
                logger.error("Invalid state - CometListener");
                return;
            }
            try {
                this.p.cancelled((AtmosphereRequest)event.getAsyncContext().getRequest(), (AtmosphereResponse)event.getAsyncContext().getResponse());
            }
            catch (Throwable ex) {
                logger.debug("failed cancelling comet response: " + event.getAsyncContext().getResponse(), ex);
            }
        }

        public void onStartAsync(AsyncEvent event) {
            logger.debug("onStartAsync(): event: {}", event.getAsyncContext().getResponse());
        }
    }
}

