/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import eu.infomas.annotation.AnnotationDetector;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.atmosphere.cache.BroadcasterCacheInspector;
import org.atmosphere.config.service.AsyncSupportListenerService;
import org.atmosphere.config.service.AsyncSupportService;
import org.atmosphere.config.service.AtmosphereHandlerService;
import org.atmosphere.config.service.AtmosphereInterceptorService;
import org.atmosphere.config.service.BroadcasterCacheInspectorService;
import org.atmosphere.config.service.BroadcasterCacheService;
import org.atmosphere.config.service.BroadcasterFactoryService;
import org.atmosphere.config.service.BroadcasterFilterService;
import org.atmosphere.config.service.BroadcasterListenerService;
import org.atmosphere.config.service.BroadcasterService;
import org.atmosphere.config.service.EndpoinMapperService;
import org.atmosphere.config.service.ManagedService;
import org.atmosphere.config.service.MeteorService;
import org.atmosphere.config.service.WebSocketHandlerService;
import org.atmosphere.config.service.WebSocketProcessorService;
import org.atmosphere.config.service.WebSocketProtocolService;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AnnotationProcessor;
import org.atmosphere.cpr.AsyncSupportListener;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.BroadcasterListener;
import org.atmosphere.cpr.DefaultAsyncSupportResolver;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.handler.ManagedAtmosphereHandler;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.util.EndpointMapper;
import org.atmosphere.util.IntrospectionUtils;
import org.atmosphere.websocket.WebSocketHandler;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAnnotationProcessor
implements AnnotationProcessor {
    private Logger logger = LoggerFactory.getLogger(DefaultAnnotationProcessor.class);
    protected AnnotationDetector detector;

    @Override
    public AnnotationProcessor configure(final AtmosphereFramework framework) {
        AnnotationDetector.TypeReporter reporter = new AnnotationDetector.TypeReporter(){

            @Override
            public Class<? extends Annotation>[] annotations() {
                return new Class[]{AtmosphereHandlerService.class, BroadcasterCacheService.class, BroadcasterFilterService.class, BroadcasterFactoryService.class, BroadcasterService.class, MeteorService.class, WebSocketHandlerService.class, WebSocketProtocolService.class, AtmosphereInterceptorService.class, BroadcasterListenerService.class, AsyncSupportService.class, AsyncSupportListenerService.class, WebSocketProcessorService.class, BroadcasterCacheInspectorService.class, ManagedService.class, EndpoinMapperService.class};
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void reportTypeAnnotation(Class<? extends Annotation> annotation, String className) {
                DefaultAnnotationProcessor.this.logger.info("Found Annotation in {} being scanned: {}", (Object)className, annotation);
                if (AtmosphereHandlerService.class.equals(annotation)) {
                    try {
                        String[] nv;
                        AtmosphereHandler handler = (AtmosphereHandler)DefaultAnnotationProcessor.this.loadClass(className).newInstance();
                        AtmosphereHandlerService a = handler.getClass().getAnnotation(AtmosphereHandlerService.class);
                        framework.setDefaultBroadcasterClassName(a.broadcaster().getName());
                        Class<? extends BroadcastFilter>[] bf = a.broadcastFilters();
                        for (Class<? extends BroadcastFilter> clazz : bf) {
                            framework.broadcasterFilters().add(clazz.getName());
                        }
                        for (String string : a.properties()) {
                            nv = string.split("=");
                            IntrospectionUtils.setProperty(handler, nv[0], nv[1]);
                            IntrospectionUtils.addProperty(handler, nv[0], nv[1]);
                        }
                        for (String string : a.atmosphereConfig()) {
                            nv = string.split("=");
                            framework.addInitParameter(nv[0], nv[1]);
                        }
                        Class<? extends AtmosphereInterceptor>[] interceptors = a.interceptors();
                        ArrayList<AtmosphereInterceptor> l = new ArrayList<AtmosphereInterceptor>();
                        for (Class<? extends AtmosphereInterceptor> i : interceptors) {
                            try {
                                AtmosphereInterceptor ai = i.newInstance();
                                l.add(ai);
                            }
                            catch (Throwable e) {
                                DefaultAnnotationProcessor.this.logger.warn("", e);
                            }
                        }
                        framework.addAtmosphereHandler(a.path(), handler, l);
                        framework.setBroadcasterCacheClassName(a.broadcasterCache().getName());
                        framework.sessionSupport(a.supportSession());
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (BroadcasterCacheService.class.equals(annotation)) {
                    framework.setBroadcasterCacheClassName(className);
                } else if (BroadcasterCacheInspectorService.class.equals(annotation)) {
                    try {
                        framework.addBroadcasterCacheInjector((BroadcasterCacheInspector)DefaultAnnotationProcessor.this.loadClass(className).newInstance());
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (MeteorService.class.equals(annotation)) {
                    try {
                        ReflectorServletProcessor r = new ReflectorServletProcessor();
                        r.setServletClassName(className);
                        Class s = DefaultAnnotationProcessor.this.loadClass(className);
                        MeteorService m = s.getAnnotation(MeteorService.class);
                        String mapping = m.path();
                        framework.setDefaultBroadcasterClassName(m.broadcaster().getName());
                        Class<? extends BroadcastFilter>[] bf = m.broadcastFilters();
                        for (Class<? extends BroadcastFilter> b : bf) {
                            framework.broadcasterFilters().add(b.getName());
                        }
                        for (String i : m.atmosphereConfig()) {
                            String[] nv = i.split("=");
                            framework.addInitParameter(nv[0], nv[1]);
                        }
                        Class<? extends AtmosphereInterceptor>[] interceptors = m.interceptors();
                        ArrayList<AtmosphereInterceptor> arrayList = new ArrayList<AtmosphereInterceptor>();
                        for (Class<? extends AtmosphereInterceptor> i : interceptors) {
                            try {
                                AtmosphereInterceptor ai = i.newInstance();
                                arrayList.add(ai);
                            }
                            catch (Throwable e) {
                                DefaultAnnotationProcessor.this.logger.warn("", e);
                            }
                        }
                        framework.addAtmosphereHandler(mapping, (AtmosphereHandler)r, arrayList);
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (BroadcasterFilterService.class.equals(annotation)) {
                    framework.broadcasterFilters().add(className);
                } else if (BroadcasterService.class.equals(annotation)) {
                    framework.setDefaultBroadcasterClassName(className);
                } else if (WebSocketHandlerService.class.equals(annotation)) {
                    try {
                        void var9_50;
                        Class<? extends BroadcastFilter>[] bf;
                        Class s = DefaultAnnotationProcessor.this.loadClass(className);
                        WebSocketHandlerService m = s.getAnnotation(WebSocketHandlerService.class);
                        framework.addAtmosphereHandler(m.path(), new AbstractReflectorAtmosphereHandler(){

                            @Override
                            public void onRequest(AtmosphereResource resource) throws IOException {
                            }

                            @Override
                            public void destroy() {
                            }
                        }).initWebSocket();
                        WebSocketProcessor p = WebSocketProcessorFactory.getDefault().getWebSocketProcessor(framework);
                        p.registerWebSocketHandler(m.path(), (WebSocketHandler)s.newInstance());
                        framework.setDefaultBroadcasterClassName(m.broadcaster().getName());
                        Class<? extends BroadcastFilter>[] arr$ = bf = m.broadcastFilters();
                        int len$ = arr$.length;
                        boolean bl = false;
                        while (var9_50 < len$) {
                            Class<? extends BroadcastFilter> b = arr$[var9_50];
                            framework.broadcasterFilters().add(b.getName());
                            ++var9_50;
                        }
                        framework.setBroadcasterCacheClassName(m.broadcasterCache().getName());
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (WebSocketProtocolService.class.equals(annotation)) {
                    framework.setWebSocketProtocolClassName(className);
                } else if (AtmosphereInterceptorService.class.equals(annotation)) {
                    try {
                        AtmosphereInterceptor a = (AtmosphereInterceptor)DefaultAnnotationProcessor.this.loadClass(className).newInstance();
                        framework.interceptor(a);
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (AsyncSupportService.class.equals(annotation)) {
                    try {
                        framework.setAsyncSupport(new DefaultAsyncSupportResolver(framework.config).newCometSupport(className));
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (AsyncSupportListenerService.class.equals(annotation)) {
                    try {
                        framework.asyncSupportListener((AsyncSupportListener)DefaultAnnotationProcessor.this.loadClass(className).newInstance());
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (BroadcasterFactoryService.class.equals(annotation)) {
                    try {
                        Class bf = DefaultAnnotationProcessor.this.loadClass(className);
                        framework.setBroadcasterFactory((BroadcasterFactory)bf.newInstance());
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (BroadcasterListenerService.class.equals(annotation)) {
                    try {
                        framework.addBroadcasterListener((BroadcasterListener)DefaultAnnotationProcessor.this.loadClass(className).newInstance());
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (WebSocketProcessorService.class.equals(annotation)) {
                    try {
                        framework.setWebsocketProcessorClassName(className);
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (ManagedService.class.equals(annotation)) {
                    try {
                        AtmosphereHandler handler;
                        try {
                            handler = (AtmosphereHandler)DefaultAnnotationProcessor.this.loadClass(className).newInstance();
                        }
                        catch (Throwable t) {
                            Object c = DefaultAnnotationProcessor.this.loadClass(className).newInstance();
                            handler = new ManagedAtmosphereHandler(c);
                        }
                        this.managed(handler, annotation);
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                } else if (EndpoinMapperService.class.equals(annotation)) {
                    try {
                        framework.endPointMapper((EndpointMapper)DefaultAnnotationProcessor.this.loadClass(className).newInstance());
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                }
            }

            void managed(AtmosphereHandler handler, Class<? extends Annotation> annotation) {
                ManagedService a = handler.getClass().getAnnotation(ManagedService.class);
                if (a == null) {
                    a = ((ManagedAtmosphereHandler)ManagedAtmosphereHandler.class.cast(handler)).object().getClass().getAnnotation(ManagedService.class);
                }
                framework.setDefaultBroadcasterClassName(a.broadcaster().getName());
                Class<? extends AtmosphereInterceptor>[] interceptors = a.interceptors();
                ArrayList<AtmosphereInterceptor> l = new ArrayList<AtmosphereInterceptor>();
                for (Class<? extends AtmosphereInterceptor> i : interceptors) {
                    try {
                        AtmosphereInterceptor ai = i.newInstance();
                        l.add(ai);
                    }
                    catch (Throwable e) {
                        DefaultAnnotationProcessor.this.logger.warn("", e);
                    }
                }
                final Class[] listeners = a.listeners();
                try {
                    AtmosphereInterceptor ai = new AtmosphereInterceptor(){

                        @Override
                        public void configure(AtmosphereConfig config) {
                        }

                        @Override
                        public Action inspect(AtmosphereResource r) {
                            for (Class l : listeners) {
                                try {
                                    r.addEventListener((AtmosphereResourceEventListener)l.newInstance());
                                }
                                catch (Throwable e) {
                                    DefaultAnnotationProcessor.this.logger.warn("", e);
                                }
                            }
                            return Action.CONTINUE;
                        }

                        @Override
                        public void postInspect(AtmosphereResource r) {
                        }

                        public String toString() {
                            return "Managed Event Listeners";
                        }
                    };
                    l.add(ai);
                }
                catch (Throwable e) {
                    DefaultAnnotationProcessor.this.logger.warn("", e);
                }
                framework.addAtmosphereHandler(a.path(), handler, l);
                framework.setBroadcasterCacheClassName(a.broadcasterCache().getName());
            }
        };
        this.detector = new AnnotationDetector(reporter);
        return this;
    }

    @Override
    public AnnotationProcessor scan(File rootDir) throws IOException {
        this.detector.detect(rootDir);
        return this;
    }

    @Override
    public AnnotationProcessor scan(String packageName) throws IOException {
        this.logger.trace("Scanning @Service annotations in {}", (Object)packageName);
        this.detector.detect(packageName);
        return this;
    }

    private Class<?> loadClass(String className) throws Exception {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (Throwable t) {
            return this.getClass().getClassLoader().loadClass(className);
        }
    }
}

