/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import java.io.IOException;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScriptProtocol
implements AtmosphereInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(JavaScriptProtocol.class);
    private String wsDelimiter = "|";

    @Override
    public void configure(AtmosphereConfig config) {
        String s = config.getInitParameter(ApplicationConfig.MESSAGE_DELIMITER);
        if (s != null) {
            this.wsDelimiter = s;
        }
    }

    @Override
    public Action inspect(final AtmosphereResource r) {
        String uuid = r.getRequest().getHeader("X-Atmosphere-tracking-id");
        String handshakeUUID = r.getRequest().getHeader("X-atmo-protocol");
        if (uuid != null && uuid.equals("0") && handshakeUUID != null) {
            r.getRequest().header("X-atmo-protocol", null);
            r.addEventListener(new AtmosphereResourceEventListenerAdapter(){

                @Override
                public void onSuspend(AtmosphereResourceEvent event) {
                    r.getResponse().write(r.uuid() + JavaScriptProtocol.this.wsDelimiter + System.currentTimeMillis());
                    if (r.transport() == AtmosphereResource.TRANSPORT.LONG_POLLING || r.transport() == AtmosphereResource.TRANSPORT.JSONP) {
                        r.resume();
                    } else {
                        try {
                            r.getResponse().flushBuffer();
                        }
                        catch (IOException e) {
                            logger.trace("", e);
                        }
                    }
                }
            });
        }
        return Action.CONTINUE;
    }

    @Override
    public void postInspect(AtmosphereResource r) {
    }

    public String toString() {
        return "Atmosphere JavaScript Protocol";
    }
}

