/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import java.io.IOException;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceFactory;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnDisconnectInterceptor
implements AtmosphereInterceptor {
    private final Logger logger = LoggerFactory.getLogger(OnDisconnectInterceptor.class);

    @Override
    public void configure(AtmosphereConfig config) {
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        AtmosphereRequest request = ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).getRequest(false);
        String s = request.getHeader("X-Atmosphere-Transport");
        String uuid = request.getHeader("X-Atmosphere-tracking-id");
        if (s != null && uuid != null && s.equalsIgnoreCase("close")) {
            this.logger.debug("AtmosphereResource {} disconnected", (Object)uuid);
            AtmosphereResource ss = AtmosphereResourceFactory.getDefault().find(uuid);
            if (ss != null) {
                ss.notifyListeners(new AtmosphereResourceEventImpl((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r), true, false));
                try {
                    ss.getRequest().setAttribute(AtmosphereResourceImpl.PRE_SUSPEND, "");
                    ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(ss)).cancel();
                }
                catch (IOException e) {
                    this.logger.trace("", e);
                }
            }
            return Action.CANCELLED;
        }
        return Action.CONTINUE;
    }

    @Override
    public void postInspect(AtmosphereResource r) {
    }

    public String toString() {
        return "Browser disconnection detection";
    }
}

