/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.util.HashMap;
import java.util.Map;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.util.EndpointMapper;
import org.atmosphere.util.uri.UriTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEndpointMapper<U>
implements EndpointMapper<U> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEndpointMapper.class);

    protected U match(String path, Map<String, U> handlers) {
        U handler = handlers.get(path);
        if (handler == null) {
            HashMap<String, String> m = new HashMap<String, String>();
            for (Map.Entry<String, U> e : handlers.entrySet()) {
                UriTemplate t = new UriTemplate(e.getKey());
                logger.trace("Trying to map {} to {}", t, (Object)path);
                if (!t.match((CharSequence)path, m)) continue;
                handler = e.getValue();
                logger.trace("Mapped {} to {}", t, e.getValue());
                break;
            }
        }
        return handler;
    }

    @Override
    public U map(AtmosphereRequest req, Map<String, U> handlers) {
        String pathInfo = null;
        try {
            pathInfo = req.getPathInfo();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        String path = pathInfo != null ? req.getServletPath() + pathInfo : req.getServletPath();
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        U handler = this.map(path + (path.endsWith("/") ? "all" : "/all"), handlers);
        if (handler == null && (handler = this.map(path, handlers)) == null) {
            handler = this.map(path + "*", handlers);
            if (handler == null) {
                String p;
                String string = p = path.lastIndexOf("/") == 0 ? "/" : path.substring(0, path.lastIndexOf("/"));
                while (p.length() > 0 && (handler = this.map(p, handlers)) == null) {
                    p = p.substring(0, p.lastIndexOf("/"));
                }
            }
            if (handler == null) {
                path = path.substring(req.getContextPath().length());
                handler = this.map(path, handlers);
            }
        }
        return handler;
    }

    @Override
    public U map(String path, Map<String, U> handlers) {
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        U handler = this.match(path + (path.endsWith("/") ? "all" : "/all"), handlers);
        if (handler == null && (handler = this.match(path, handlers)) == null && (handler = this.match(path + "*", handlers)) == null) {
            String p;
            String string = p = path.lastIndexOf("/") == 0 ? "/" : path.substring(0, path.lastIndexOf("/"));
            while (p.length() > 0 && p.indexOf("/") != -1 && (handler = this.match(p, handlers)) == null) {
                p = p.substring(0, p.lastIndexOf("/"));
            }
        }
        return handler;
    }
}

