/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.websocket.WebSocket;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.buffer.HeapChannelBufferFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyWebSocket
extends WebSocket {
    private static final Logger logger = LoggerFactory.getLogger(NettyWebSocket.class);
    private final Channel channel;
    private final ChannelBufferFactory factory = new HeapChannelBufferFactory();
    private final AtomicBoolean firstWrite = new AtomicBoolean(false);

    public NettyWebSocket(Channel channel, AtmosphereConfig config) {
        super(config);
        this.channel = channel;
    }

    @Override
    public WebSocket write(String data) throws IOException {
        this.firstWrite.set(true);
        if (!this.channel.isOpen()) {
            throw new IOException("Connection remotely closed");
        }
        logger.trace("WebSocket.write()");
        if (this.binaryWrite) {
            this.channel.write((Object)new BinaryWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])data.getBytes("UTF-8"))));
        } else {
            this.channel.write((Object)new TextWebSocketFrame(data));
        }
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    @Override
    public WebSocket write(AtmosphereResponse r, byte[] data) throws IOException {
        this.firstWrite.set(true);
        if (!this.channel.isOpen()) {
            throw new IOException("Connection remotely closed");
        }
        logger.trace("WebSocket.write()");
        if (this.binaryWrite) {
            this.channel.write((Object)new BinaryWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])data)));
        } else {
            this.channel.write((Object)new TextWebSocketFrame(new String(data, "UTF-8")));
        }
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    @Override
    public WebSocket write(byte[] data, int offset, int length) throws IOException {
        String s;
        this.firstWrite.set(true);
        if (this.channel.isOpen() && (s = this.config().getInitParameter("org.atmosphere.websocket.binaryWrite")) != null && Boolean.parseBoolean(s)) {
            ChannelBuffer c = this.factory.getBuffer(length - offset);
            c.writeBytes(data);
            this.channel.write((Object)new BinaryWebSocketFrame(c));
        }
        return this;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() {
        this.channel.close().addListener(ChannelFutureListener.CLOSE);
    }
}

