/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.BroadcasterListenerAdapter;
import org.atmosphere.util.ExecutorsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereResourceStateRecovery
implements AtmosphereInterceptor {
    private final Logger logger = LoggerFactory.getLogger(AtmosphereResourceStateRecovery.class);
    private final ConcurrentHashMap<String, BroadcasterTracker> states = new ConcurrentHashMap();
    private BroadcasterFactory factory;
    private ScheduledExecutorService stateTracker;
    private long timeout = 300000L;

    @Override
    public void configure(AtmosphereConfig config) {
        this.factory = config.getBroadcasterFactory();
        this.factory.addBroadcasterListener(new B());
        this.stateTracker = ExecutorsFactory.getScheduler(config);
        String s = config.getInitParameter(ApplicationConfig.STATE_RECOVERY_TIMEOUT);
        if (s != null) {
            this.timeout = Long.parseLong(s);
        }
        this.clearStateTracker();
    }

    protected void clearStateTracker() {
        this.stateTracker.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                long now = System.currentTimeMillis();
                for (Map.Entry t : AtmosphereResourceStateRecovery.this.states.entrySet()) {
                    if (now - ((BroadcasterTracker)t.getValue()).lastTick() <= AtmosphereResourceStateRecovery.this.timeout) continue;
                    AtmosphereResourceStateRecovery.this.logger.trace("AtmosphereResource {} state destroyed.", t.getKey());
                    AtmosphereResourceStateRecovery.this.states.remove(t.getKey());
                }
            }
        }, this.timeout, this.timeout, TimeUnit.NANOSECONDS);
    }

    @Override
    public Action inspect(final AtmosphereResource r) {
        if (!r.transport().equals((Object)AtmosphereResource.TRANSPORT.POLLING) && !r.transport().equals((Object)AtmosphereResource.TRANSPORT.AJAX)) {
            r.addEventListener(new AtmosphereResourceEventListenerAdapter(){

                @Override
                public void onPreSuspend(AtmosphereResourceEvent e) {
                    BroadcasterTracker tracker = AtmosphereResourceStateRecovery.this.track(r).tick();
                    for (String broadcasterID : tracker.ids()) {
                        Object b = AtmosphereResourceStateRecovery.this.factory.lookup(broadcasterID, false);
                        if (b != null && !b.getID().equalsIgnoreCase(r.getBroadcaster().getID())) {
                            AtmosphereResourceStateRecovery.this.logger.trace("Associate AtmosphereResource {} with Broadcaster {}", (Object)r.uuid(), (Object)broadcasterID);
                            b.addAtmosphereResource(r);
                            continue;
                        }
                        AtmosphereResourceStateRecovery.this.logger.trace("Broadcaster {} is no longer available", (Object)broadcasterID);
                    }
                    r.removeEventListener(this);
                }
            });
        }
        return Action.CONTINUE;
    }

    private BroadcasterTracker track(AtmosphereResource r) {
        BroadcasterTracker tracker = this.states.get(r.uuid());
        if (tracker == null) {
            tracker = new BroadcasterTracker();
            this.states.put(r.uuid(), tracker);
            this.logger.trace("AtmosphereResource {} state now tracked", (Object)r.uuid());
        }
        return tracker;
    }

    @Override
    public void postInspect(AtmosphereResource r) {
    }

    public ConcurrentHashMap<String, BroadcasterTracker> states() {
        return this.states;
    }

    public String toString() {
        return "AtmosphereResource state recovery";
    }

    public static final class BroadcasterTracker {
        private final List<String> broadcasterIds = new LinkedList<String>();
        private long tick = System.currentTimeMillis();

        public BroadcasterTracker add(Broadcaster b) {
            this.broadcasterIds.add(b.getID());
            return this;
        }

        public BroadcasterTracker remove(Broadcaster b) {
            this.broadcasterIds.remove(b.getID());
            return this;
        }

        public List<String> ids() {
            return this.broadcasterIds;
        }

        public BroadcasterTracker tick() {
            this.tick = System.currentTimeMillis();
            return this;
        }

        public long lastTick() {
            return this.tick;
        }
    }

    public final class B
    extends BroadcasterListenerAdapter {
        @Override
        public void onAddAtmosphereResource(Broadcaster b, AtmosphereResource r) {
            BroadcasterTracker t = (BroadcasterTracker)AtmosphereResourceStateRecovery.this.states.get(r.uuid());
            if (t == null) {
                t = AtmosphereResourceStateRecovery.this.track(r);
            }
            t.add(b);
        }

        @Override
        public void onRemoveAtmosphereResource(Broadcaster b, AtmosphereResource r) {
            BroadcasterTracker t = (BroadcasterTracker)AtmosphereResourceStateRecovery.this.states.get(r.uuid());
            if (!r.isCancelled() && t != null) {
                t.remove(b);
            }
        }
    }
}

